/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Color;
import android.graphics.ColorSpace;
import android.graphics.Shader;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;

@RavenwoodKeepWholeClass
public class LinearGradient
extends Shader {
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private float mX0;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private float mY0;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private float mX1;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private float mY1;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private float[] mPositions;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private Shader.TileMode mTileMode;
    @UnsupportedAppUsage
    private int[] mColors;
    @UnsupportedAppUsage
    private int mColor0;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int mColor1;
    private final long[] mColorLongs;

    public LinearGradient(float x0, float y0, float x1, float y1, @NonNull int[] colors, @Nullable float[] positions, @NonNull Shader.TileMode tile) {
        this(x0, y0, x1, y1, LinearGradient.convertColors(colors), positions, tile, ColorSpace.get(ColorSpace.Named.SRGB));
    }

    public LinearGradient(float x0, float y0, float x1, float y1, @NonNull long[] colors, @Nullable float[] positions, @NonNull Shader.TileMode tile) {
        this(x0, y0, x1, y1, (long[])colors.clone(), positions, tile, LinearGradient.detectColorSpace(colors));
    }

    private LinearGradient(float x0, float y0, float x1, float y1, @NonNull long[] colors, @Nullable float[] positions, @NonNull Shader.TileMode tile, @NonNull ColorSpace colorSpace) {
        super(colorSpace);
        if (positions != null && colors.length != positions.length) {
            throw new IllegalArgumentException("color and position arrays must be of equal length");
        }
        this.mX0 = x0;
        this.mY0 = y0;
        this.mX1 = x1;
        this.mY1 = y1;
        this.mColorLongs = colors;
        this.mPositions = positions != null ? (float[])positions.clone() : null;
        this.mTileMode = tile;
    }

    public LinearGradient(float x0, float y0, float x1, float y1, int color0, int color1, @NonNull Shader.TileMode tile) {
        this(x0, y0, x1, y1, Color.pack(color0), Color.pack(color1), tile);
    }

    public LinearGradient(float x0, float y0, float x1, float y1, long color0, long color1, @NonNull Shader.TileMode tile) {
        this(x0, y0, x1, y1, new long[]{color0, color1}, null, tile);
    }

    @Override
    protected long createNativeInstance(long nativeMatrix, boolean filterFromPaint) {
        return this.nativeCreate(nativeMatrix, this.mX0, this.mY0, this.mX1, this.mY1, this.mColorLongs, this.mPositions, this.mTileMode.nativeInt, this.colorSpace().getNativeInstance());
    }

    private native long nativeCreate(long var1, float var3, float var4, float var5, float var6, long[] var7, float[] var8, int var9, long var10);
}

