/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.NonNull;
import android.annotation.SuppressLint;
import android.graphics.ColorSpace;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import libcore.util.NativeAllocationRegistry;

@RavenwoodKeepWholeClass
public class MeshSpecification {
    long mNativeMeshSpec;
    public static final int ALPHA_TYPE_UNKNOWN = 0;
    public static final int ALPHA_TYPE_OPAQUE = 1;
    public static final int ALPHA_TYPE_PREMULTIPLIED = 2;
    public static final int ALPHA_TYPE_UNPREMULTIPLIED = 3;
    public static final int TYPE_FLOAT = 0;
    public static final int TYPE_FLOAT2 = 1;
    public static final int TYPE_FLOAT3 = 2;
    public static final int TYPE_FLOAT4 = 3;
    public static final int TYPE_UBYTE4 = 4;

    @NonNull
    public static MeshSpecification make(@SuppressLint(value={"ArrayReturn"}) @NonNull Attribute[] attributes, int vertexStride, @SuppressLint(value={"ArrayReturn"}) @NonNull Varying[] varyings, @NonNull String vertexShader, @NonNull String fragmentShader) {
        long nativeMeshSpec = MeshSpecification.nativeMake(attributes, vertexStride, varyings, vertexShader, fragmentShader);
        if (nativeMeshSpec == 0L) {
            throw new IllegalArgumentException("MeshSpecification construction failed");
        }
        return new MeshSpecification(nativeMeshSpec);
    }

    @NonNull
    public static MeshSpecification make(@SuppressLint(value={"ArrayReturn"}) @NonNull Attribute[] attributes, int vertexStride, @SuppressLint(value={"ArrayReturn"}) @NonNull Varying[] varyings, @NonNull String vertexShader, @NonNull String fragmentShader, @NonNull ColorSpace colorSpace) {
        long nativeMeshSpec = MeshSpecification.nativeMakeWithCS(attributes, vertexStride, varyings, vertexShader, fragmentShader, colorSpace.getNativeInstance());
        if (nativeMeshSpec == 0L) {
            throw new IllegalArgumentException("MeshSpecification construction failed");
        }
        return new MeshSpecification(nativeMeshSpec);
    }

    @NonNull
    public static MeshSpecification make(@SuppressLint(value={"ArrayReturn"}) @NonNull Attribute[] attributes, int vertexStride, @SuppressLint(value={"ArrayReturn"}) @NonNull Varying[] varyings, @NonNull String vertexShader, @NonNull String fragmentShader, @NonNull ColorSpace colorSpace, int alphaType) {
        long nativeMeshSpec = MeshSpecification.nativeMakeWithAlpha(attributes, vertexStride, varyings, vertexShader, fragmentShader, colorSpace.getNativeInstance(), alphaType);
        if (nativeMeshSpec == 0L) {
            throw new IllegalArgumentException("MeshSpecification construction failed");
        }
        return new MeshSpecification(nativeMeshSpec);
    }

    private MeshSpecification(long meshSpec) {
        this.mNativeMeshSpec = meshSpec;
        MeshSpecificationHolder.MESH_SPECIFICATION_REGISTRY.registerNativeAllocation(this, meshSpec);
    }

    private static native long nativeGetFinalizer();

    private static native long nativeMake(Attribute[] var0, int var1, Varying[] var2, String var3, String var4);

    private static native long nativeMakeWithCS(Attribute[] var0, int var1, Varying[] var2, String var3, String var4, long var5);

    private static native long nativeMakeWithAlpha(Attribute[] var0, int var1, Varying[] var2, String var3, String var4, long var5, int var7);

    public static class Attribute {
        private final int mType;
        private final int mOffset;
        private final String mName;

        public Attribute(int type, int offset, @NonNull String name) {
            this.mType = type;
            this.mOffset = offset;
            this.mName = name;
        }

        public int getType() {
            return this.mType;
        }

        public int getOffset() {
            return this.mOffset;
        }

        @NonNull
        public String getName() {
            return this.mName;
        }

        public String toString() {
            return "Attribute{mType=" + this.mType + ", mOffset=" + this.mOffset + ", mName='" + this.mName + '\'' + '}';
        }
    }

    public static class Varying {
        private final int mType;
        private final String mName;

        public Varying(int type, @NonNull String name) {
            this.mType = type;
            this.mName = name;
        }

        public int getType() {
            return this.mType;
        }

        @NonNull
        public String getName() {
            return this.mName;
        }

        public String toString() {
            return "Varying{mType=" + this.mType + ", mName='" + this.mName + '\'' + '}';
        }
    }

    private static class MeshSpecificationHolder {
        public static final NativeAllocationRegistry MESH_SPECIFICATION_REGISTRY = NativeAllocationRegistry.createMalloced(MeshSpecification.class.getClassLoader(), MeshSpecification.nativeGetFinalizer());

        private MeshSpecificationHolder() {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface Type {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface AlphaType {
    }
}

