/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.ColorSpace;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import com.android.tools.layoutlib.create.OverrideMethod;
import libcore.util.NativeAllocationRegistry;

@FlaggedApi(value="com.android.graphics.hwui.flags.runtime_color_filters_blenders")
@RavenwoodKeepWholeClass
public class RuntimeXfermode
extends Xfermode {
    private long mBuilderNativeInstance;

    public RuntimeXfermode(@NonNull String agsl) {
        if (agsl == null) {
            throw new NullPointerException("RuntimeShader requires a non-null AGSL string");
        }
        this.mBuilderNativeInstance = RuntimeXfermode.nativeCreateBlenderBuilder(agsl);
        NoImagePreloadHolder.sRegistry.registerNativeAllocation(this, this.mBuilderNativeInstance);
    }

    public void setColorUniform(@NonNull String uniformName, int color2) {
        this.setUniform(uniformName, Color.valueOf(color2).getComponents(), true);
    }

    public void setColorUniform(@NonNull String uniformName, long color2) {
        Color exSRGB = Color.valueOf(color2).convert(ColorSpace.get(ColorSpace.Named.EXTENDED_SRGB));
        this.setUniform(uniformName, exSRGB.getComponents(), true);
    }

    public void setColorUniform(@NonNull String uniformName, @NonNull Color color2) {
        if (color2 == null) {
            throw new NullPointerException("The color parameter must not be null");
        }
        Color exSRGB = color2.convert(ColorSpace.get(ColorSpace.Named.EXTENDED_SRGB));
        this.setUniform(uniformName, exSRGB.getComponents(), true);
    }

    public void setFloatUniform(@NonNull String uniformName, float value) {
        this.setFloatUniform(uniformName, value, 0.0f, 0.0f, 0.0f, 1);
    }

    public void setFloatUniform(@NonNull String uniformName, float value1, float value2) {
        this.setFloatUniform(uniformName, value1, value2, 0.0f, 0.0f, 2);
    }

    public void setFloatUniform(@NonNull String uniformName, float value1, float value2, float value3) {
        this.setFloatUniform(uniformName, value1, value2, value3, 0.0f, 3);
    }

    public void setFloatUniform(@NonNull String uniformName, float value1, float value2, float value3, float value4) {
        this.setFloatUniform(uniformName, value1, value2, value3, value4, 4);
    }

    public void setFloatUniform(@NonNull String uniformName, @NonNull float[] values) {
        this.setUniform(uniformName, values, false);
    }

    private void setFloatUniform(@NonNull String uniformName, float value1, float value2, float value3, float value4, int count) {
        if (uniformName == null) {
            throw new NullPointerException("The uniformName parameter must not be null");
        }
        RuntimeXfermode.nativeUpdateUniforms(this.mBuilderNativeInstance, uniformName, value1, value2, value3, value4, count);
    }

    private void setUniform(@NonNull String uniformName, @NonNull float[] values, boolean isColor) {
        if (uniformName == null) {
            throw new NullPointerException("The uniformName parameter must not be null");
        }
        if (values == null) {
            throw new NullPointerException("The uniform values parameter must not be null");
        }
        RuntimeXfermode.nativeUpdateUniforms(this.mBuilderNativeInstance, uniformName, values, isColor);
    }

    public void setIntUniform(@NonNull String uniformName, int value) {
        this.setIntUniform(uniformName, value, 0, 0, 0, 1);
    }

    public void setIntUniform(@NonNull String uniformName, int value1, int value2) {
        this.setIntUniform(uniformName, value1, value2, 0, 0, 2);
    }

    public void setIntUniform(@NonNull String uniformName, int value1, int value2, int value3) {
        this.setIntUniform(uniformName, value1, value2, value3, 0, 3);
    }

    public void setIntUniform(@NonNull String uniformName, int value1, int value2, int value3, int value4) {
        this.setIntUniform(uniformName, value1, value2, value3, value4, 4);
    }

    public void setIntUniform(@NonNull String uniformName, @NonNull int[] values) {
        if (uniformName == null) {
            throw new NullPointerException("The uniformName parameter must not be null");
        }
        if (values == null) {
            throw new NullPointerException("The uniform values parameter must not be null");
        }
        RuntimeXfermode.nativeUpdateUniforms(this.mBuilderNativeInstance, uniformName, values);
    }

    private void setIntUniform(@NonNull String uniformName, int value1, int value2, int value3, int value4, int count) {
        if (uniformName == null) {
            throw new NullPointerException("The uniformName parameter must not be null");
        }
        RuntimeXfermode.nativeUpdateUniforms(this.mBuilderNativeInstance, uniformName, value1, value2, value3, value4, count);
    }

    public void setInputShader(@NonNull String shaderName, @NonNull Shader shader) {
        if (shaderName == null) {
            throw new NullPointerException("The shaderName parameter must not be null");
        }
        if (shader == null) {
            throw new NullPointerException("The shader parameter must not be null");
        }
        RuntimeXfermode.nativeUpdateChild(this.mBuilderNativeInstance, shaderName, shader.getNativeInstance());
    }

    public void setInputColorFilter(@NonNull String filterName, @NonNull ColorFilter colorFilter) {
        if (filterName == null) {
            throw new NullPointerException("The filterName parameter must not be null");
        }
        if (colorFilter == null) {
            throw new NullPointerException("The colorFilter parameter must not be null");
        }
        RuntimeXfermode.nativeUpdateColorFilter(this.mBuilderNativeInstance, filterName, colorFilter.getNativeInstance());
    }

    public void setInputXfermode(@NonNull String xfermodeName, @NonNull RuntimeXfermode xfermode) {
        if (xfermodeName == null) {
            throw new NullPointerException("The xfermodeName parameter must not be null");
        }
        if (xfermode == null) {
            throw new NullPointerException("The xfermode parameter must not be null");
        }
        RuntimeXfermode.nativeUpdateChild(this.mBuilderNativeInstance, xfermodeName, xfermode.createNativeInstance());
    }

    public long createNativeInstance() {
        return RuntimeXfermode.nativeCreateNativeInstance(this.mBuilderNativeInstance);
    }

    private static long nativeGetFinalizer() {
        return OverrideMethod.invokeL("android.graphics.RuntimeXfermode#nativeGetFinalizer()J", true, null);
    }

    private static long nativeCreateBlenderBuilder(String string2) {
        return OverrideMethod.invokeL("android.graphics.RuntimeXfermode#nativeCreateBlenderBuilder(Ljava/lang/String;)J", true, null);
    }

    private static long nativeCreateNativeInstance(long l) {
        return OverrideMethod.invokeL("android.graphics.RuntimeXfermode#nativeCreateNativeInstance(J)J", true, null);
    }

    private static void nativeUpdateUniforms(long l, String string2, float[] fArray, boolean bl) {
        OverrideMethod.invokeV("android.graphics.RuntimeXfermode#nativeUpdateUniforms(JLjava/lang/String;[FZ)V", true, null);
    }

    private static void nativeUpdateUniforms(long l, String string2, float f, float f2, float f3, float f4, int n) {
        OverrideMethod.invokeV("android.graphics.RuntimeXfermode#nativeUpdateUniforms(JLjava/lang/String;FFFFI)V", true, null);
    }

    private static void nativeUpdateUniforms(long l, String string2, int[] nArray) {
        OverrideMethod.invokeV("android.graphics.RuntimeXfermode#nativeUpdateUniforms(JLjava/lang/String;[I)V", true, null);
    }

    private static void nativeUpdateUniforms(long l, String string2, int n, int n2, int n3, int n4, int n5) {
        OverrideMethod.invokeV("android.graphics.RuntimeXfermode#nativeUpdateUniforms(JLjava/lang/String;IIIII)V", true, null);
    }

    private static void nativeUpdateChild(long l, String string2, long l2) {
        OverrideMethod.invokeV("android.graphics.RuntimeXfermode#nativeUpdateChild(JLjava/lang/String;J)V", true, null);
    }

    private static void nativeUpdateColorFilter(long l, String string2, long l2) {
        OverrideMethod.invokeV("android.graphics.RuntimeXfermode#nativeUpdateColorFilter(JLjava/lang/String;J)V", true, null);
    }

    private static class NoImagePreloadHolder {
        public static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(RuntimeXfermode.class.getClassLoader(), RuntimeXfermode.nativeGetFinalizer());

        private NoImagePreloadHolder() {
        }
    }
}

