/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableInflater;
import android.util.LruCache;
import android.view.InflateException;
import com.android.layoutlib.bridge.impl.RenderAction;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.lang.reflect.Constructor;

public class DrawableInflater_Delegate {
    private static final LruCache<String, Constructor<? extends Drawable>> CONSTRUCTOR_MAP = new LruCache(20);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LayoutlibDelegate
    static Drawable inflateFromClass(DrawableInflater thisInflater, String className) {
        try {
            Constructor<? extends Drawable> constructor;
            LruCache<String, Constructor<? extends Drawable>> lruCache = CONSTRUCTOR_MAP;
            synchronized (lruCache) {
                constructor = CONSTRUCTOR_MAP.get(className);
                if (constructor == null) {
                    Class<Drawable> clazz = RenderAction.getCurrentContext().getLayoutlibCallback().findClass(className).asSubclass(Drawable.class);
                    constructor = clazz.getConstructor(new Class[0]);
                    CONSTRUCTOR_MAP.put(className, constructor);
                }
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (ClassCastException e) {
            throw new InflateException("Class is not a Drawable " + className, e);
        }
        catch (ClassNotFoundException e) {
            throw new InflateException("Class not found " + className, e);
        }
        catch (Exception e) {
            throw new InflateException("Error inflating class " + className, e);
        }
    }

    public static void clearConstructorCache() {
        CONSTRUCTOR_MAP.evictAll();
    }
}

