/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.fonts;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.FontListParser;
import android.graphics.Typeface;
import android.graphics.fonts.Font;
import android.graphics.fonts.FontFamily;
import android.graphics.fonts.SystemFonts_Delegate;
import android.os.LocaleList;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodReplace;
import android.text.FontConfig;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseIntArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.ravenwood.RavenwoodEnvironment;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParserException;

@RavenwoodKeepWholeClass
public final class SystemFonts {
    private static final String TAG = "SystemFonts";
    private static final String FONTS_XML = SystemFonts.getFontsXmlDir() + "font_fallback.xml";
    public static final String LEGACY_FONTS_XML = SystemFonts.getFontsXmlDir() + "fonts.xml";
    public static final String SYSTEM_FONT_DIR = SystemFonts.getSystemFontDir();
    private static final String OEM_XML = "/product/etc/fonts_customization.xml";
    public static final String OEM_FONT_DIR = "/product/fonts/";
    private static final String DEVICE_FONTS_XML_DIR = "/system/etc/";
    private static final String DEVICE_FONT_DIR = "/system/fonts/";
    private static final Object LOCK = new Object();
    @GuardedBy(value={"sLock"})
    private static Set<Font> sAvailableFonts;

    private SystemFonts() {
    }

    @RavenwoodReplace
    private static String getFontsXmlDir() {
        return DEVICE_FONTS_XML_DIR;
    }

    private static String getFontsXmlDir$ravenwood() {
        return RavenwoodEnvironment.getInstance().getRavenwoodRuntimePath() + "fonts/";
    }

    @RavenwoodReplace
    private static String getSystemFontDir() {
        return DEVICE_FONT_DIR;
    }

    private static String getSystemFontDir$ravenwood() {
        return RavenwoodEnvironment.getInstance().getRavenwoodRuntimePath() + "fonts/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static Set<Font> getAvailableFonts() {
        Object object = LOCK;
        synchronized (object) {
            if (sAvailableFonts == null) {
                sAvailableFonts = Font.getAvailableFonts();
            }
            return sAvailableFonts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetAvailableFonts() {
        Object object = LOCK;
        synchronized (object) {
            sAvailableFonts = null;
        }
    }

    @Nullable
    static ByteBuffer mmap_Original(@NonNull String fullPath) {
        MappedByteBuffer mappedByteBuffer;
        FileInputStream file = new FileInputStream(fullPath);
        try {
            FileChannel fileChannel = file.getChannel();
            long fontSize = fileChannel.size();
            mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fontSize);
        }
        catch (Throwable throwable) {
            try {
                try {
                    file.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        file.close();
        return mappedByteBuffer;
    }

    @LayoutlibDelegate
    private static ByteBuffer mmap(String string2) {
        return SystemFonts_Delegate.mmap(string2);
    }

    @VisibleForTesting
    public static int resolveVarFamilyType(@NonNull FontConfig.FontFamily xmlFamily, @Nullable String familyName) {
        int wghtCount = 0;
        int italCount = 0;
        int targetFonts = 0;
        boolean hasItalicFont = false;
        List<FontConfig.Font> fonts = xmlFamily.getFontList();
        for (int i = 0; i < fonts.size(); ++i) {
            FontConfig.Font font = fonts.get(i);
            if (familyName != null ? !familyName.equals(font.getFontFamilyName()) : font.getFontFamilyName() != null) continue;
            int varTypeAxes = font.getVarTypeAxes();
            if (varTypeAxes == 0) {
                return 0;
            }
            if ((varTypeAxes & 1) != 0) {
                ++wghtCount;
            }
            if ((varTypeAxes & 2) != 0) {
                ++italCount;
            }
            if (font.getStyle().getSlant() == 1) {
                hasItalicFont = true;
            }
            ++targetFonts;
        }
        if (italCount == 0) {
            if (targetFonts == 1 && wghtCount == 1) {
                return 1;
            }
            if (targetFonts == 2 && wghtCount == 2 && hasItalicFont) {
                return 3;
            }
        } else if (italCount == 1 && wghtCount == 1 && targetFonts == 1) {
            return 2;
        }
        return 0;
    }

    private static void pushFamilyToFallback(@NonNull FontConfig.FontFamily xmlFamily, @NonNull ArrayMap<String, NativeFamilyListSet> fallbackMap, @NonNull Map<String, ByteBuffer> cache) {
        ArrayList fallback;
        String languageTags = xmlFamily.getLocaleList().toLanguageTags();
        int variant = xmlFamily.getVariant();
        ArrayList<FontConfig.Font> defaultFonts = new ArrayList<FontConfig.Font>();
        ArrayMap<String, ArrayList> specificFallbackFonts = new ArrayMap<String, ArrayList>();
        for (FontConfig.Font font : xmlFamily.getFonts()) {
            String fallbackName = font.getFontFamilyName();
            if (fallbackName == null) {
                defaultFonts.add(font);
                continue;
            }
            fallback = (ArrayList)specificFallbackFonts.get(fallbackName);
            if (fallback == null) {
                fallback = new ArrayList();
                specificFallbackFonts.put(fallbackName, fallback);
            }
            fallback.add(font);
        }
        FontFamily defaultFamily = defaultFonts.isEmpty() ? null : SystemFonts.createFontFamily(defaultFonts, languageTags, variant, SystemFonts.resolveVarFamilyType(xmlFamily, null), false, cache);
        for (int i = 0; i < fallbackMap.size(); ++i) {
            String name = fallbackMap.keyAt(i);
            NativeFamilyListSet familyListSet = fallbackMap.valueAt(i);
            int identityHash = System.identityHashCode(xmlFamily);
            if (familyListSet.seenXmlFamilies.get(identityHash, -1) != -1) continue;
            familyListSet.seenXmlFamilies.append(identityHash, 1);
            fallback = (ArrayList)specificFallbackFonts.get(name);
            if (fallback == null) {
                if (defaultFamily == null) continue;
                familyListSet.familyList.add(defaultFamily);
                continue;
            }
            FontFamily family = SystemFonts.createFontFamily(fallback, languageTags, variant, SystemFonts.resolveVarFamilyType(xmlFamily, name), false, cache);
            if (family != null) {
                familyListSet.familyList.add(family);
                continue;
            }
            if (defaultFamily == null) continue;
            familyListSet.familyList.add(defaultFamily);
        }
    }

    @Nullable
    private static FontFamily createFontFamily(@NonNull List<FontConfig.Font> fonts, @NonNull String languageTags, int variant, int varFamilyType, boolean isDefaultFallback, @NonNull Map<String, ByteBuffer> cache) {
        if (fonts.size() == 0) {
            return null;
        }
        FontFamily.Builder b = null;
        for (int i = 0; i < fonts.size(); ++i) {
            Font font;
            FontConfig.Font fontConfig = fonts.get(i);
            String fullPath = fontConfig.getFile().getAbsolutePath();
            ByteBuffer buffer = cache.get(fullPath);
            if (buffer == null) {
                if (cache.containsKey(fullPath)) continue;
                buffer = SystemFonts.mmap(fullPath);
                cache.put(fullPath, buffer);
                if (buffer == null) continue;
            }
            try {
                font = new Font.Builder(buffer, new File(fullPath), languageTags).setWeight(fontConfig.getStyle().getWeight()).setSlant(fontConfig.getStyle().getSlant()).setTtcIndex(fontConfig.getTtcIndex()).setFontVariationSettings(fontConfig.getFontVariationSettings()).build();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (b == null) {
                b = new FontFamily.Builder(font);
                continue;
            }
            b.addFont(font);
        }
        if (b == null) {
            return null;
        }
        try {
            return b.build(languageTags, variant, false, isDefaultFallback, varFamilyType);
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < fonts.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(fonts.get(i));
            }
            Log.e(TAG, "Failed during creating FontFamily, possibly invalid font format: " + sb);
            return null;
        }
    }

    private static void appendNamedFamilyList(@NonNull FontConfig.NamedFamilyList namedFamilyList, @NonNull ArrayMap<String, ByteBuffer> bufferCache, @NonNull ArrayMap<String, NativeFamilyListSet> fallbackListMap) {
        String familyName = namedFamilyList.getName();
        NativeFamilyListSet familyListSet = new NativeFamilyListSet();
        List<FontConfig.FontFamily> xmlFamilies = namedFamilyList.getFamilies();
        for (int i = 0; i < xmlFamilies.size(); ++i) {
            FontConfig.FontFamily xmlFamily = xmlFamilies.get(i);
            FontFamily family = SystemFonts.createFontFamily(xmlFamily.getFontList(), xmlFamily.getLocaleList().toLanguageTags(), xmlFamily.getVariant(), SystemFonts.resolveVarFamilyType(xmlFamily, null), true, bufferCache);
            if (family == null) {
                return;
            }
            familyListSet.familyList.add(family);
            familyListSet.seenXmlFamilies.append(System.identityHashCode(xmlFamily), 1);
        }
        fallbackListMap.put(familyName, familyListSet);
    }

    @NonNull
    public static FontConfig getSystemFontConfig(@Nullable Map<String, File> updatableFontMap, long lastModifiedDate, int configVersion) {
        return SystemFonts.getSystemFontConfigInternal(FONTS_XML, SYSTEM_FONT_DIR, OEM_XML, OEM_FONT_DIR, updatableFontMap, lastModifiedDate, configVersion);
    }

    @NonNull
    public static FontConfig getSystemFontConfigForTesting(@NonNull String fontsXml, @Nullable Map<String, File> updatableFontMap, long lastModifiedDate, int configVersion) {
        return SystemFonts.getSystemFontConfigInternal(fontsXml, SYSTEM_FONT_DIR, OEM_XML, OEM_FONT_DIR, updatableFontMap, lastModifiedDate, configVersion);
    }

    @NonNull
    public static FontConfig getSystemPreinstalledFontConfig() {
        return SystemFonts.getSystemFontConfigInternal(FONTS_XML, SYSTEM_FONT_DIR, OEM_XML, OEM_FONT_DIR, null, 0L, 0);
    }

    @NonNull
    public static FontConfig getSystemPreinstalledFontConfigFromLegacyXml() {
        return SystemFonts.getSystemFontConfigInternal(LEGACY_FONTS_XML, SYSTEM_FONT_DIR, OEM_XML, OEM_FONT_DIR, null, 0L, 0);
    }

    @NonNull
    static FontConfig getSystemFontConfigInternal_Original(@NonNull String fontsXml, @NonNull String systemFontDir, @Nullable String oemXml, @Nullable String productFontDir, @Nullable Map<String, File> updatableFontMap, long lastModifiedDate, int configVersion) {
        try {
            Log.i(TAG, "Loading font config from " + fontsXml);
            return FontListParser.parse(fontsXml, systemFontDir, oemXml, productFontDir, updatableFontMap, lastModifiedDate, configVersion);
        }
        catch (IOException e) {
            Log.e(TAG, "Failed to open/read system font configurations.", e);
            return new FontConfig(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), 0L, 0);
        }
        catch (XmlPullParserException e) {
            Log.e(TAG, "Failed to parse the system font configuration.", e);
            return new FontConfig(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), 0L, 0);
        }
    }

    @LayoutlibDelegate
    static FontConfig getSystemFontConfigInternal(String string2, String string3, String string4, String string5, Map<String, File> map, long l, int n) {
        return SystemFonts_Delegate.getSystemFontConfigInternal(string2, string3, string4, string5, map, l, n);
    }

    @VisibleForTesting
    public static Map<String, FontFamily[]> buildSystemFallback(FontConfig fontConfig) {
        return SystemFonts.buildSystemFallback(fontConfig, new ArrayMap<String, ByteBuffer>());
    }

    @VisibleForTesting
    public static Map<String, FontFamily[]> buildSystemFallback(FontConfig fontConfig, ArrayMap<String, ByteBuffer> outBufferCache) {
        ArrayMap<String, NativeFamilyListSet> fallbackListMap = new ArrayMap<String, NativeFamilyListSet>();
        List<FontConfig.Customization.LocaleFallback> localeFallbacks = fontConfig.getLocaleFallbackCustomizations();
        List<FontConfig.NamedFamilyList> namedFamilies = fontConfig.getNamedFamilyLists();
        for (int i = 0; i < namedFamilies.size(); ++i) {
            FontConfig.NamedFamilyList namedFamilyList = namedFamilies.get(i);
            SystemFonts.appendNamedFamilyList(namedFamilyList, outBufferCache, fallbackListMap);
        }
        ArrayList<FontConfig.Customization.LocaleFallback> customizations = new ArrayList<FontConfig.Customization.LocaleFallback>();
        List<FontConfig.FontFamily> xmlFamilies = fontConfig.getFontFamilies();
        SparseIntArray seenCustomization = new SparseIntArray();
        for (int i = 0; i < xmlFamilies.size(); ++i) {
            FontConfig.Customization.LocaleFallback localeFallback;
            int j;
            FontConfig.Customization.LocaleFallback localeFallback2;
            int j2;
            FontConfig.FontFamily xmlFamily = xmlFamilies.get(i);
            customizations.clear();
            for (j2 = 0; j2 < localeFallbacks.size(); ++j2) {
                if (seenCustomization.get(j2, -1) != -1) continue;
                localeFallback2 = localeFallbacks.get(j2);
                if (!SystemFonts.scriptMatch(xmlFamily.getLocaleList(), localeFallback2.getScript())) continue;
                customizations.add(localeFallback2);
                seenCustomization.put(j2, 1);
            }
            if (customizations.isEmpty()) {
                SystemFonts.pushFamilyToFallback(xmlFamily, fallbackListMap, outBufferCache);
                continue;
            }
            for (j2 = 0; j2 < customizations.size(); ++j2) {
                localeFallback2 = (FontConfig.Customization.LocaleFallback)customizations.get(j2);
                if (localeFallback2.getOperation() != 0) continue;
                SystemFonts.pushFamilyToFallback(localeFallback2.getFamily(), fallbackListMap, outBufferCache);
            }
            boolean isReplaced = false;
            for (j = 0; j < customizations.size(); ++j) {
                localeFallback = (FontConfig.Customization.LocaleFallback)customizations.get(j);
                if (localeFallback.getOperation() != 2) continue;
                SystemFonts.pushFamilyToFallback(localeFallback.getFamily(), fallbackListMap, outBufferCache);
                isReplaced = true;
            }
            if (!isReplaced) {
                SystemFonts.pushFamilyToFallback(xmlFamily, fallbackListMap, outBufferCache);
            }
            for (j = 0; j < customizations.size(); ++j) {
                localeFallback = (FontConfig.Customization.LocaleFallback)customizations.get(j);
                if (localeFallback.getOperation() != 1) continue;
                SystemFonts.pushFamilyToFallback(localeFallback.getFamily(), fallbackListMap, outBufferCache);
            }
        }
        ArrayMap<String, FontFamily[]> fallbackMap = new ArrayMap<String, FontFamily[]>();
        for (int i = 0; i < fallbackListMap.size(); ++i) {
            String fallbackName = fallbackListMap.keyAt(i);
            List<FontFamily> familyList = fallbackListMap.valueAt((int)i).familyList;
            fallbackMap.put(fallbackName, familyList.toArray(new FontFamily[0]));
        }
        return fallbackMap;
    }

    @VisibleForTesting
    public static Map<String, Typeface> buildSystemTypefaces(FontConfig fontConfig, Map<String, FontFamily[]> fallbackMap) {
        ArrayMap<String, Typeface> result = new ArrayMap<String, Typeface>();
        Typeface.initSystemDefaultTypefaces(fallbackMap, fontConfig.getAliases(), result);
        return result;
    }

    private static boolean scriptMatch(LocaleList localeList, String targetScript) {
        if (localeList == null || localeList.isEmpty()) {
            return false;
        }
        for (int i = 0; i < localeList.size(); ++i) {
            Locale locale = localeList.get(i);
            if (locale == null) continue;
            String baseScript = FontConfig.resolveScript(locale);
            if (baseScript.equals(targetScript)) {
                return true;
            }
            if (targetScript.equals("Bopo") && baseScript.equals("Hanb")) {
                return true;
            }
            if (!(targetScript.equals("Hani") ? baseScript.equals("Hanb") || baseScript.equals("Hans") || baseScript.equals("Hant") || baseScript.equals("Kore") || baseScript.equals("Jpan") : !(!targetScript.equals("Hira") && !targetScript.equals("Hrkt") && !targetScript.equals("Kana") || !baseScript.equals("Jpan") && !baseScript.equals("Hrkt")))) continue;
            return true;
        }
        return false;
    }

    private static class NativeFamilyListSet {
        public List<FontFamily> familyList = new ArrayList<FontFamily>();
        public SparseIntArray seenXmlFamilies = new SparseIntArray();

        private NativeFamilyListSet() {
        }
    }
}

