/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.text;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import dalvik.system.VMRuntime;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@RavenwoodKeepWholeClass
public class LineBreakConfig
implements Parcelable {
    @FlaggedApi(value="com.android.text.flags.no_break_no_hyphenation_span")
    public static final int HYPHENATION_UNSPECIFIED = -1;
    @FlaggedApi(value="com.android.text.flags.no_break_no_hyphenation_span")
    public static final int HYPHENATION_DISABLED = 0;
    @FlaggedApi(value="com.android.text.flags.no_break_no_hyphenation_span")
    public static final int HYPHENATION_ENABLED = 1;
    @FlaggedApi(value="com.android.text.flags.no_break_no_hyphenation_span")
    public static final int LINE_BREAK_STYLE_UNSPECIFIED = -1;
    public static final int LINE_BREAK_STYLE_NONE = 0;
    public static final int LINE_BREAK_STYLE_LOOSE = 1;
    public static final int LINE_BREAK_STYLE_NORMAL = 2;
    public static final int LINE_BREAK_STYLE_STRICT = 3;
    @FlaggedApi(value="com.android.text.flags.no_break_no_hyphenation_span")
    public static final int LINE_BREAK_STYLE_NO_BREAK = 4;
    @FlaggedApi(value="com.android.text.flags.word_style_auto")
    public static final int LINE_BREAK_STYLE_AUTO = 5;
    @FlaggedApi(value="com.android.text.flags.no_break_no_hyphenation_span")
    public static final int LINE_BREAK_WORD_STYLE_UNSPECIFIED = -1;
    public static final int LINE_BREAK_WORD_STYLE_NONE = 0;
    public static final int LINE_BREAK_WORD_STYLE_PHRASE = 1;
    @FlaggedApi(value="com.android.text.flags.word_style_auto")
    public static final int LINE_BREAK_WORD_STYLE_AUTO = 2;
    public static final LineBreakConfig NONE = new Builder().setLineBreakStyle(0).setLineBreakWordStyle(0).build();
    private final int mLineBreakStyle;
    private final int mLineBreakWordStyle;
    private final int mHyphenation;
    @FlaggedApi(value="com.android.text.flags.no_break_no_hyphenation_span")
    @NonNull
    public static final Parcelable.Creator<LineBreakConfig> CREATOR = new Parcelable.Creator<LineBreakConfig>(){

        @Override
        public LineBreakConfig createFromParcel(Parcel source) {
            int lineBreakStyle = source.readInt();
            int lineBreakWordStyle = source.readInt();
            int hyphenation = source.readInt();
            return new LineBreakConfig(lineBreakStyle, lineBreakWordStyle, hyphenation);
        }

        public LineBreakConfig[] newArray(int size) {
            return new LineBreakConfig[size];
        }
    };

    @NonNull
    public static LineBreakConfig getLineBreakConfig(int lineBreakStyle, int lineBreakWordStyle) {
        Builder builder = new Builder();
        return builder.setLineBreakStyle(lineBreakStyle).setLineBreakWordStyle(lineBreakWordStyle).build();
    }

    public LineBreakConfig(int lineBreakStyle, int lineBreakWordStyle, int hyphenation) {
        this.mLineBreakStyle = lineBreakStyle;
        this.mLineBreakWordStyle = lineBreakWordStyle;
        this.mHyphenation = hyphenation;
    }

    public int getLineBreakStyle() {
        return this.mLineBreakStyle;
    }

    public static int getResolvedLineBreakStyle(@Nullable LineBreakConfig config) {
        int targetSdkVersion = VMRuntime.getRuntime().getTargetSdkVersion();
        int vicVersion = 35;
        int defaultStyle = targetSdkVersion >= 35 ? 5 : 0;
        if (config == null) {
            return defaultStyle;
        }
        return config.mLineBreakStyle == -1 ? defaultStyle : config.mLineBreakStyle;
    }

    public int getLineBreakWordStyle() {
        return this.mLineBreakWordStyle;
    }

    public static int getResolvedLineBreakWordStyle(@Nullable LineBreakConfig config) {
        int targetSdkVersion = VMRuntime.getRuntime().getTargetSdkVersion();
        int vicVersion = 35;
        int defaultWordStyle = targetSdkVersion >= 35 ? 2 : 0;
        if (config == null) {
            return defaultWordStyle;
        }
        return config.mLineBreakWordStyle == -1 ? defaultWordStyle : config.mLineBreakWordStyle;
    }

    @FlaggedApi(value="com.android.text.flags.no_break_no_hyphenation_span")
    public int getHyphenation() {
        return this.mHyphenation;
    }

    public static int getResolvedHyphenation(@Nullable LineBreakConfig config) {
        if (config == null) {
            return 1;
        }
        return config.mHyphenation == -1 ? 1 : config.mHyphenation;
    }

    @FlaggedApi(value="com.android.text.flags.no_break_no_hyphenation_span")
    @NonNull
    public LineBreakConfig merge(@NonNull LineBreakConfig config) {
        return new LineBreakConfig(config.mLineBreakStyle == -1 ? this.mLineBreakStyle : config.mLineBreakStyle, config.mLineBreakWordStyle == -1 ? this.mLineBreakWordStyle : config.mLineBreakWordStyle, config.mHyphenation == -1 ? this.mHyphenation : config.mHyphenation);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof LineBreakConfig)) {
            return false;
        }
        LineBreakConfig that = (LineBreakConfig)o;
        return this.mLineBreakStyle == that.mLineBreakStyle && this.mLineBreakWordStyle == that.mLineBreakWordStyle && this.mHyphenation == that.mHyphenation;
    }

    public int hashCode() {
        return Objects.hash(this.mLineBreakStyle, this.mLineBreakWordStyle, this.mHyphenation);
    }

    public String toString() {
        return "LineBreakConfig{mLineBreakStyle=" + this.mLineBreakStyle + ", mLineBreakWordStyle=" + this.mLineBreakWordStyle + ", mHyphenation= " + this.mHyphenation + '}';
    }

    @Override
    @FlaggedApi(value="com.android.text.flags.no_break_no_hyphenation_span")
    public int describeContents() {
        return 0;
    }

    @Override
    @FlaggedApi(value="com.android.text.flags.no_break_no_hyphenation_span")
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mLineBreakStyle);
        dest.writeInt(this.mLineBreakWordStyle);
        dest.writeInt(this.mHyphenation);
    }

    public static class Builder {
        private int mLineBreakStyle = -1;
        private int mLineBreakWordStyle = -1;
        private int mHyphenation = -1;

        public Builder() {
            this.reset(null);
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @FlaggedApi(value="com.android.text.flags.no_break_no_hyphenation_span")
        @NonNull
        public Builder merge(@NonNull LineBreakConfig config) {
            if (config.mLineBreakStyle != -1) {
                this.mLineBreakStyle = config.mLineBreakStyle;
            }
            if (config.mLineBreakWordStyle != -1) {
                this.mLineBreakWordStyle = config.mLineBreakWordStyle;
            }
            if (config.mHyphenation != -1) {
                this.mHyphenation = config.mHyphenation;
            }
            return this;
        }

        @NonNull
        public Builder reset(@Nullable LineBreakConfig config) {
            if (config == null) {
                this.mLineBreakStyle = -1;
                this.mLineBreakWordStyle = -1;
                this.mHyphenation = -1;
            } else {
                this.mLineBreakStyle = config.mLineBreakStyle;
                this.mLineBreakWordStyle = config.mLineBreakWordStyle;
                this.mHyphenation = config.mHyphenation;
            }
            return this;
        }

        @NonNull
        public Builder setLineBreakStyle(int lineBreakStyle) {
            this.mLineBreakStyle = lineBreakStyle;
            return this;
        }

        @NonNull
        public Builder setLineBreakWordStyle(int lineBreakWordStyle) {
            this.mLineBreakWordStyle = lineBreakWordStyle;
            return this;
        }

        @FlaggedApi(value="com.android.text.flags.no_break_no_hyphenation_span")
        @NonNull
        public Builder setHyphenation(int hyphenation) {
            this.mHyphenation = hyphenation;
            return this;
        }

        @NonNull
        public LineBreakConfig build() {
            return new LineBreakConfig(this.mLineBreakStyle, this.mLineBreakWordStyle, this.mHyphenation);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LineBreakWordStyle {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LineBreakStyle {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Hyphenation {
    }
}

