/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.content.AttributionSourceState;
import android.hardware.CameraExtensionSessionStats;
import android.hardware.CameraInfo;
import android.hardware.CameraStatus;
import android.hardware.ICamera;
import android.hardware.ICameraClient;
import android.hardware.ICameraServiceListener;
import android.hardware.camera2.ICameraDeviceCallbacks;
import android.hardware.camera2.ICameraDeviceUser;
import android.hardware.camera2.ICameraInjectionCallback;
import android.hardware.camera2.ICameraInjectionSession;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.params.SessionConfiguration;
import android.hardware.camera2.params.VendorTagDescriptor;
import android.hardware.camera2.params.VendorTagDescriptorCache;
import android.hardware.camera2.utils.CameraIdAndSessionConfiguration;
import android.hardware.camera2.utils.ConcurrentCameraIdCombination;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;

public interface ICameraService
extends IInterface {
    public static final int ERROR_PERMISSION_DENIED = 1;
    public static final int ERROR_ALREADY_EXISTS = 2;
    public static final int ERROR_ILLEGAL_ARGUMENT = 3;
    public static final int ERROR_DISCONNECTED = 4;
    public static final int ERROR_TIMED_OUT = 5;
    public static final int ERROR_DISABLED = 6;
    public static final int ERROR_CAMERA_IN_USE = 7;
    public static final int ERROR_MAX_CAMERAS_IN_USE = 8;
    public static final int ERROR_DEPRECATED_HAL = 9;
    public static final int ERROR_INVALID_OPERATION = 10;
    public static final int CAMERA_TYPE_BACKWARD_COMPATIBLE = 0;
    public static final int CAMERA_TYPE_ALL = 1;
    public static final int ROTATION_OVERRIDE_NONE = 0;
    public static final int ROTATION_OVERRIDE_OVERRIDE_TO_PORTRAIT = 1;
    public static final int ROTATION_OVERRIDE_ROTATION_ONLY = 2;
    public static final int ROTATION_OVERRIDE_ROTATION_ONLY_REVERSE = 3;
    public static final int USE_CALLING_UID = -1;
    public static final int USE_CALLING_PID = -1;
    public static final int EVENT_NONE = 0;
    public static final int EVENT_USER_SWITCHED = 1;
    public static final int EVENT_USB_DEVICE_ATTACHED = 2;
    public static final int EVENT_USB_DEVICE_DETACHED = 3;
    public static final int DEVICE_STATE_NORMAL = 0;
    public static final int DEVICE_STATE_BACK_COVERED = 1;
    public static final int DEVICE_STATE_FRONT_COVERED = 2;
    public static final int DEVICE_STATE_FOLDED = 4;
    public static final int DEVICE_STATE_LAST_FRAMEWORK_BIT = Integer.MIN_VALUE;

    public int getNumberOfCameras(int var1, AttributionSourceState var2, int var3) throws RemoteException;

    public CameraInfo getCameraInfo(int var1, int var2, AttributionSourceState var3, int var4) throws RemoteException;

    public ICamera connect(ICameraClient var1, int var2, int var3, int var4, boolean var5, AttributionSourceState var6, int var7) throws RemoteException;

    public ICameraDeviceUser connectDevice(ICameraDeviceCallbacks var1, String var2, int var3, int var4, int var5, AttributionSourceState var6, int var7, boolean var8) throws RemoteException;

    public CameraStatus[] addListener(ICameraServiceListener var1) throws RemoteException;

    public ConcurrentCameraIdCombination[] getConcurrentCameraIds() throws RemoteException;

    public boolean isConcurrentSessionConfigurationSupported(CameraIdAndSessionConfiguration[] var1, int var2, AttributionSourceState var3, int var4) throws RemoteException;

    public void injectSessionParams(String var1, CameraMetadataNative var2) throws RemoteException;

    public void removeListener(ICameraServiceListener var1) throws RemoteException;

    public CameraMetadataNative getCameraCharacteristics(String var1, int var2, int var3, AttributionSourceState var4, int var5) throws RemoteException;

    public VendorTagDescriptor getCameraVendorTagDescriptor() throws RemoteException;

    public VendorTagDescriptorCache getCameraVendorTagCache() throws RemoteException;

    public String getLegacyParameters(int var1) throws RemoteException;

    public boolean isHiddenPhysicalCamera(String var1) throws RemoteException;

    public ICameraInjectionSession injectCamera(String var1, String var2, String var3, ICameraInjectionCallback var4) throws RemoteException;

    public void setTorchMode(String var1, boolean var2, IBinder var3, AttributionSourceState var4, int var5) throws RemoteException;

    public void turnOnTorchWithStrengthLevel(String var1, int var2, IBinder var3, AttributionSourceState var4, int var5) throws RemoteException;

    public int getTorchStrengthLevel(String var1, AttributionSourceState var2, int var3) throws RemoteException;

    public void notifySystemEvent(int var1, int[] var2) throws RemoteException;

    public void notifyDisplayConfigurationChange() throws RemoteException;

    public void notifyDeviceStateChange(long var1) throws RemoteException;

    public String reportExtensionSessionStats(CameraExtensionSessionStats var1) throws RemoteException;

    public CameraMetadataNative createDefaultRequest(String var1, int var2, AttributionSourceState var3, int var4) throws RemoteException;

    public boolean isSessionConfigurationWithParametersSupported(String var1, int var2, SessionConfiguration var3, AttributionSourceState var4, int var5) throws RemoteException;

    public CameraMetadataNative getSessionCharacteristics(String var1, int var2, int var3, SessionConfiguration var4, AttributionSourceState var5, int var6) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICameraService {
        public static final String DESCRIPTOR = "android.hardware.ICameraService";
        static final int TRANSACTION_getNumberOfCameras = 1;
        static final int TRANSACTION_getCameraInfo = 2;
        static final int TRANSACTION_connect = 3;
        static final int TRANSACTION_connectDevice = 4;
        static final int TRANSACTION_addListener = 5;
        static final int TRANSACTION_getConcurrentCameraIds = 6;
        static final int TRANSACTION_isConcurrentSessionConfigurationSupported = 7;
        static final int TRANSACTION_injectSessionParams = 8;
        static final int TRANSACTION_removeListener = 9;
        static final int TRANSACTION_getCameraCharacteristics = 10;
        static final int TRANSACTION_getCameraVendorTagDescriptor = 11;
        static final int TRANSACTION_getCameraVendorTagCache = 12;
        static final int TRANSACTION_getLegacyParameters = 13;
        static final int TRANSACTION_isHiddenPhysicalCamera = 14;
        static final int TRANSACTION_injectCamera = 15;
        static final int TRANSACTION_setTorchMode = 16;
        static final int TRANSACTION_turnOnTorchWithStrengthLevel = 17;
        static final int TRANSACTION_getTorchStrengthLevel = 18;
        static final int TRANSACTION_notifySystemEvent = 19;
        static final int TRANSACTION_notifyDisplayConfigurationChange = 20;
        static final int TRANSACTION_notifyDeviceStateChange = 21;
        static final int TRANSACTION_reportExtensionSessionStats = 22;
        static final int TRANSACTION_createDefaultRequest = 23;
        static final int TRANSACTION_isSessionConfigurationWithParametersSupported = 24;
        static final int TRANSACTION_getSessionCharacteristics = 25;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ICameraService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ICameraService) {
                return (ICameraService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getNumberOfCameras";
                }
                case 2: {
                    return "getCameraInfo";
                }
                case 3: {
                    return "connect";
                }
                case 4: {
                    return "connectDevice";
                }
                case 5: {
                    return "addListener";
                }
                case 6: {
                    return "getConcurrentCameraIds";
                }
                case 7: {
                    return "isConcurrentSessionConfigurationSupported";
                }
                case 8: {
                    return "injectSessionParams";
                }
                case 9: {
                    return "removeListener";
                }
                case 10: {
                    return "getCameraCharacteristics";
                }
                case 11: {
                    return "getCameraVendorTagDescriptor";
                }
                case 12: {
                    return "getCameraVendorTagCache";
                }
                case 13: {
                    return "getLegacyParameters";
                }
                case 14: {
                    return "isHiddenPhysicalCamera";
                }
                case 15: {
                    return "injectCamera";
                }
                case 16: {
                    return "setTorchMode";
                }
                case 17: {
                    return "turnOnTorchWithStrengthLevel";
                }
                case 18: {
                    return "getTorchStrengthLevel";
                }
                case 19: {
                    return "notifySystemEvent";
                }
                case 20: {
                    return "notifyDisplayConfigurationChange";
                }
                case 21: {
                    return "notifyDeviceStateChange";
                }
                case 22: {
                    return "reportExtensionSessionStats";
                }
                case 23: {
                    return "createDefaultRequest";
                }
                case 24: {
                    return "isSessionConfigurationWithParametersSupported";
                }
                case 25: {
                    return "getSessionCharacteristics";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    AttributionSourceState _arg1 = data.readTypedObject(AttributionSourceState.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getNumberOfCameras(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    AttributionSourceState _arg2 = data.readTypedObject(AttributionSourceState.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    CameraInfo _result = this.getCameraInfo(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 3: {
                    ICameraClient _arg0 = ICameraClient.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    boolean _arg4 = data.readBoolean();
                    AttributionSourceState _arg5 = data.readTypedObject(AttributionSourceState.CREATOR);
                    int _arg6 = data.readInt();
                    data.enforceNoDataAvail();
                    ICamera _result = this.connect(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 4: {
                    ICameraDeviceCallbacks _arg0 = ICameraDeviceCallbacks.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    AttributionSourceState _arg5 = data.readTypedObject(AttributionSourceState.CREATOR);
                    int _arg6 = data.readInt();
                    boolean _arg7 = data.readBoolean();
                    data.enforceNoDataAvail();
                    ICameraDeviceUser _result = this.connectDevice(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 5: {
                    ICameraServiceListener _arg0 = ICameraServiceListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.addListener(_arg0);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 6: {
                    Parcelable[] _result = this.getConcurrentCameraIds();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 7: {
                    CameraIdAndSessionConfiguration[] _arg0 = data.createTypedArray(CameraIdAndSessionConfiguration.CREATOR);
                    int _arg1 = data.readInt();
                    AttributionSourceState _arg2 = data.readTypedObject(AttributionSourceState.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isConcurrentSessionConfigurationSupported(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    CameraMetadataNative _arg1 = data.readTypedObject(CameraMetadataNative.CREATOR);
                    data.enforceNoDataAvail();
                    this.injectSessionParams(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    ICameraServiceListener _arg0 = ICameraServiceListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    AttributionSourceState _arg3 = data.readTypedObject(AttributionSourceState.CREATOR);
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    CameraMetadataNative _result = this.getCameraCharacteristics(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 11: {
                    VendorTagDescriptor _result = this.getCameraVendorTagDescriptor();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 12: {
                    VendorTagDescriptorCache _result = this.getCameraVendorTagCache();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    String _result = this.getLegacyParameters(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 14: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isHiddenPhysicalCamera(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 15: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    ICameraInjectionCallback _arg3 = ICameraInjectionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    ICameraInjectionSession _result = this.injectCamera(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 16: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    IBinder _arg2 = data.readStrongBinder();
                    AttributionSourceState _arg3 = data.readTypedObject(AttributionSourceState.CREATOR);
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setTorchMode(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    IBinder _arg2 = data.readStrongBinder();
                    AttributionSourceState _arg3 = data.readTypedObject(AttributionSourceState.CREATOR);
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.turnOnTorchWithStrengthLevel(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    String _arg0 = data.readString();
                    AttributionSourceState _arg1 = data.readTypedObject(AttributionSourceState.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getTorchStrengthLevel(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 19: {
                    int _arg0 = data.readInt();
                    int[] _arg1 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.notifySystemEvent(_arg0, _arg1);
                    break;
                }
                case 20: {
                    this.notifyDisplayConfigurationChange();
                    break;
                }
                case 21: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.notifyDeviceStateChange(_arg0);
                    break;
                }
                case 22: {
                    CameraExtensionSessionStats _arg0 = data.readTypedObject(CameraExtensionSessionStats.CREATOR);
                    data.enforceNoDataAvail();
                    String _result = this.reportExtensionSessionStats(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 23: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    AttributionSourceState _arg2 = data.readTypedObject(AttributionSourceState.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    CameraMetadataNative _result = this.createDefaultRequest(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 24: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    SessionConfiguration _arg2 = data.readTypedObject(SessionConfiguration.CREATOR);
                    AttributionSourceState _arg3 = data.readTypedObject(AttributionSourceState.CREATOR);
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isSessionConfigurationWithParametersSupported(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 25: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    SessionConfiguration _arg3 = data.readTypedObject(SessionConfiguration.CREATOR);
                    AttributionSourceState _arg4 = data.readTypedObject(AttributionSourceState.CREATOR);
                    int _arg5 = data.readInt();
                    data.enforceNoDataAvail();
                    CameraMetadataNative _result = this.getSessionCharacteristics(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 24;
        }

        private static class Proxy
        implements ICameraService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getNumberOfCameras(int type, AttributionSourceState clientAttribution, int devicePolicy) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(type);
                    _data.writeTypedObject(clientAttribution, 0);
                    _data.writeInt(devicePolicy);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CameraInfo getCameraInfo(int cameraId, int rotationOverride, AttributionSourceState clientAttribution, int devicePolicy) throws RemoteException {
                CameraInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(cameraId);
                    _data.writeInt(rotationOverride);
                    _data.writeTypedObject(clientAttribution, 0);
                    _data.writeInt(devicePolicy);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(CameraInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICamera connect(ICameraClient client, int cameraId, int targetSdkVersion, int rotationOverride, boolean forceSlowJpegMode, AttributionSourceState clientAttribution, int devicePolicy) throws RemoteException {
                ICamera _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeInt(cameraId);
                    _data.writeInt(targetSdkVersion);
                    _data.writeInt(rotationOverride);
                    _data.writeBoolean(forceSlowJpegMode);
                    _data.writeTypedObject(clientAttribution, 0);
                    _data.writeInt(devicePolicy);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = ICamera.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICameraDeviceUser connectDevice(ICameraDeviceCallbacks callbacks, String cameraId, int oomScoreOffset, int targetSdkVersion, int rotationOverride, AttributionSourceState clientAttribution, int devicePolicy, boolean sharedMode) throws RemoteException {
                ICameraDeviceUser _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callbacks);
                    _data.writeString(cameraId);
                    _data.writeInt(oomScoreOffset);
                    _data.writeInt(targetSdkVersion);
                    _data.writeInt(rotationOverride);
                    _data.writeTypedObject(clientAttribution, 0);
                    _data.writeInt(devicePolicy);
                    _data.writeBoolean(sharedMode);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = ICameraDeviceUser.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CameraStatus[] addListener(ICameraServiceListener listener) throws RemoteException {
                CameraStatus[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(CameraStatus.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ConcurrentCameraIdCombination[] getConcurrentCameraIds() throws RemoteException {
                ConcurrentCameraIdCombination[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(ConcurrentCameraIdCombination.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isConcurrentSessionConfigurationSupported(CameraIdAndSessionConfiguration[] sessions, int targetSdkVersion, AttributionSourceState clientAttribution, int devicePolicy) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedArray(sessions, 0);
                    _data.writeInt(targetSdkVersion);
                    _data.writeTypedObject(clientAttribution, 0);
                    _data.writeInt(devicePolicy);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void injectSessionParams(String cameraId, CameraMetadataNative sessionParams) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(cameraId);
                    _data.writeTypedObject(sessionParams, 0);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeListener(ICameraServiceListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CameraMetadataNative getCameraCharacteristics(String cameraId, int targetSdkVersion, int rotationOverride, AttributionSourceState clientAttribution, int devicePolicy) throws RemoteException {
                CameraMetadataNative _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(cameraId);
                    _data.writeInt(targetSdkVersion);
                    _data.writeInt(rotationOverride);
                    _data.writeTypedObject(clientAttribution, 0);
                    _data.writeInt(devicePolicy);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(CameraMetadataNative.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VendorTagDescriptor getCameraVendorTagDescriptor() throws RemoteException {
                VendorTagDescriptor _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(VendorTagDescriptor.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VendorTagDescriptorCache getCameraVendorTagCache() throws RemoteException {
                VendorTagDescriptorCache _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(VendorTagDescriptorCache.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getLegacyParameters(int cameraId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(cameraId);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHiddenPhysicalCamera(String cameraId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(cameraId);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICameraInjectionSession injectCamera(String packageName, String internalCamId, String externalCamId, ICameraInjectionCallback CameraInjectionCallback2) throws RemoteException {
                ICameraInjectionSession _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(internalCamId);
                    _data.writeString(externalCamId);
                    _data.writeStrongInterface(CameraInjectionCallback2);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = ICameraInjectionSession.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTorchMode(String cameraId, boolean enabled, IBinder clientBinder, AttributionSourceState clientAttribution, int devicePolicy) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(cameraId);
                    _data.writeBoolean(enabled);
                    _data.writeStrongBinder(clientBinder);
                    _data.writeTypedObject(clientAttribution, 0);
                    _data.writeInt(devicePolicy);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void turnOnTorchWithStrengthLevel(String cameraId, int strengthLevel, IBinder clientBinder, AttributionSourceState clientAttribution, int devicePolicy) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(cameraId);
                    _data.writeInt(strengthLevel);
                    _data.writeStrongBinder(clientBinder);
                    _data.writeTypedObject(clientAttribution, 0);
                    _data.writeInt(devicePolicy);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getTorchStrengthLevel(String cameraId, AttributionSourceState clientAttribution, int devicePolicy) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(cameraId);
                    _data.writeTypedObject(clientAttribution, 0);
                    _data.writeInt(devicePolicy);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifySystemEvent(int eventId, int[] args) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(eventId);
                    _data.writeIntArray(args);
                    boolean bl = this.mRemote.transact(19, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void notifyDisplayConfigurationChange() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(20, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyDeviceStateChange(long newState) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(newState);
                    boolean bl = this.mRemote.transact(21, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String reportExtensionSessionStats(CameraExtensionSessionStats stats) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(stats, 0);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CameraMetadataNative createDefaultRequest(String cameraId, int templateId, AttributionSourceState clientAttribution, int devicePolicy) throws RemoteException {
                CameraMetadataNative _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(cameraId);
                    _data.writeInt(templateId);
                    _data.writeTypedObject(clientAttribution, 0);
                    _data.writeInt(devicePolicy);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(CameraMetadataNative.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSessionConfigurationWithParametersSupported(String cameraId, int targetSdkVersion, SessionConfiguration sessionConfiguration, AttributionSourceState clientAttribution, int devicePolicy) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(cameraId);
                    _data.writeInt(targetSdkVersion);
                    _data.writeTypedObject(sessionConfiguration, 0);
                    _data.writeTypedObject(clientAttribution, 0);
                    _data.writeInt(devicePolicy);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CameraMetadataNative getSessionCharacteristics(String cameraId, int targetSdkVersion, int rotationOverride, SessionConfiguration sessionConfiguration, AttributionSourceState clientAttribution, int devicePolicy) throws RemoteException {
                CameraMetadataNative _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(cameraId);
                    _data.writeInt(targetSdkVersion);
                    _data.writeInt(rotationOverride);
                    _data.writeTypedObject(sessionConfiguration, 0);
                    _data.writeTypedObject(clientAttribution, 0);
                    _data.writeInt(devicePolicy);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(CameraMetadataNative.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ICameraService {
        @Override
        public int getNumberOfCameras(int type, AttributionSourceState clientAttribution, int devicePolicy) throws RemoteException {
            return 0;
        }

        @Override
        public CameraInfo getCameraInfo(int cameraId, int rotationOverride, AttributionSourceState clientAttribution, int devicePolicy) throws RemoteException {
            return null;
        }

        @Override
        public ICamera connect(ICameraClient client, int cameraId, int targetSdkVersion, int rotationOverride, boolean forceSlowJpegMode, AttributionSourceState clientAttribution, int devicePolicy) throws RemoteException {
            return null;
        }

        @Override
        public ICameraDeviceUser connectDevice(ICameraDeviceCallbacks callbacks, String cameraId, int oomScoreOffset, int targetSdkVersion, int rotationOverride, AttributionSourceState clientAttribution, int devicePolicy, boolean sharedMode) throws RemoteException {
            return null;
        }

        @Override
        public CameraStatus[] addListener(ICameraServiceListener listener) throws RemoteException {
            return null;
        }

        @Override
        public ConcurrentCameraIdCombination[] getConcurrentCameraIds() throws RemoteException {
            return null;
        }

        @Override
        public boolean isConcurrentSessionConfigurationSupported(CameraIdAndSessionConfiguration[] sessions, int targetSdkVersion, AttributionSourceState clientAttribution, int devicePolicy) throws RemoteException {
            return false;
        }

        @Override
        public void injectSessionParams(String cameraId, CameraMetadataNative sessionParams) throws RemoteException {
        }

        @Override
        public void removeListener(ICameraServiceListener listener) throws RemoteException {
        }

        @Override
        public CameraMetadataNative getCameraCharacteristics(String cameraId, int targetSdkVersion, int rotationOverride, AttributionSourceState clientAttribution, int devicePolicy) throws RemoteException {
            return null;
        }

        @Override
        public VendorTagDescriptor getCameraVendorTagDescriptor() throws RemoteException {
            return null;
        }

        @Override
        public VendorTagDescriptorCache getCameraVendorTagCache() throws RemoteException {
            return null;
        }

        @Override
        public String getLegacyParameters(int cameraId) throws RemoteException {
            return null;
        }

        @Override
        public boolean isHiddenPhysicalCamera(String cameraId) throws RemoteException {
            return false;
        }

        @Override
        public ICameraInjectionSession injectCamera(String packageName, String internalCamId, String externalCamId, ICameraInjectionCallback CameraInjectionCallback2) throws RemoteException {
            return null;
        }

        @Override
        public void setTorchMode(String cameraId, boolean enabled, IBinder clientBinder, AttributionSourceState clientAttribution, int devicePolicy) throws RemoteException {
        }

        @Override
        public void turnOnTorchWithStrengthLevel(String cameraId, int strengthLevel, IBinder clientBinder, AttributionSourceState clientAttribution, int devicePolicy) throws RemoteException {
        }

        @Override
        public int getTorchStrengthLevel(String cameraId, AttributionSourceState clientAttribution, int devicePolicy) throws RemoteException {
            return 0;
        }

        @Override
        public void notifySystemEvent(int eventId, int[] args) throws RemoteException {
        }

        @Override
        public void notifyDisplayConfigurationChange() throws RemoteException {
        }

        @Override
        public void notifyDeviceStateChange(long newState) throws RemoteException {
        }

        @Override
        public String reportExtensionSessionStats(CameraExtensionSessionStats stats) throws RemoteException {
            return null;
        }

        @Override
        public CameraMetadataNative createDefaultRequest(String cameraId, int templateId, AttributionSourceState clientAttribution, int devicePolicy) throws RemoteException {
            return null;
        }

        @Override
        public boolean isSessionConfigurationWithParametersSupported(String cameraId, int targetSdkVersion, SessionConfiguration sessionConfiguration, AttributionSourceState clientAttribution, int devicePolicy) throws RemoteException {
            return false;
        }

        @Override
        public CameraMetadataNative getSessionCharacteristics(String cameraId, int targetSdkVersion, int rotationOverride, SessionConfiguration sessionConfiguration, AttributionSourceState clientAttribution, int devicePolicy) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

