/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorListener;
import android.hardware.SensorManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.view.IRotationWatcher;
import android.view.IWindowManager;
import java.util.HashMap;
import java.util.List;

class LegacySensorManager {
    private static boolean sInitialized;
    private static IWindowManager sWindowManager;
    private static int sRotation;
    private final SensorManager mSensorManager;
    private final HashMap<SensorListener, LegacyListener> mLegacyListenersMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LegacySensorManager(SensorManager sensorManager) {
        this.mSensorManager = sensorManager;
        Class<SensorManager> clazz = SensorManager.class;
        synchronized (SensorManager.class) {
            if (!sInitialized && (sWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window"))) != null) {
                try {
                    sRotation = sWindowManager.watchRotation(new IRotationWatcher.Stub(this){

                        @Override
                        public void onRotationChanged(int rotation) {
                            LegacySensorManager.onRotationChanged(rotation);
                        }
                    }, 0);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public int getSensors() {
        int result = 0;
        List<Sensor> fullList = this.mSensorManager.getFullSensorList();
        for (Sensor i : fullList) {
            switch (i.getType()) {
                case 1: {
                    result |= 2;
                    break;
                }
                case 2: {
                    result |= 8;
                    break;
                }
                case 3: {
                    result |= 0x81;
                }
            }
        }
        return result;
    }

    public boolean registerListener(SensorListener listener, int sensors, int rate) {
        if (listener == null) {
            return false;
        }
        boolean result = false;
        result = this.registerLegacyListener(2, 1, listener, sensors, rate) || result;
        result = this.registerLegacyListener(8, 2, listener, sensors, rate) || result;
        result = this.registerLegacyListener(128, 3, listener, sensors, rate) || result;
        result = this.registerLegacyListener(1, 3, listener, sensors, rate) || result;
        result = this.registerLegacyListener(4, 7, listener, sensors, rate) || result;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerLegacyListener(int legacyType, int type, SensorListener listener, int sensors, int rate) {
        Sensor sensor;
        boolean result = false;
        if ((sensors & legacyType) != 0 && (sensor = this.mSensorManager.getDefaultSensor(type)) != null) {
            HashMap<SensorListener, LegacyListener> hashMap = this.mLegacyListenersMap;
            synchronized (hashMap) {
                LegacyListener legacyListener = this.mLegacyListenersMap.get(listener);
                if (legacyListener == null) {
                    legacyListener = new LegacyListener(listener);
                    this.mLegacyListenersMap.put(listener, legacyListener);
                }
                result = legacyListener.registerSensor(legacyType) ? this.mSensorManager.registerListener(legacyListener, sensor, rate) : true;
            }
        }
        return result;
    }

    public void unregisterListener(SensorListener listener, int sensors) {
        if (listener == null) {
            return;
        }
        this.unregisterLegacyListener(2, 1, listener, sensors);
        this.unregisterLegacyListener(8, 2, listener, sensors);
        this.unregisterLegacyListener(128, 3, listener, sensors);
        this.unregisterLegacyListener(1, 3, listener, sensors);
        this.unregisterLegacyListener(4, 7, listener, sensors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterLegacyListener(int legacyType, int type, SensorListener listener, int sensors) {
        Sensor sensor;
        if ((sensors & legacyType) != 0 && (sensor = this.mSensorManager.getDefaultSensor(type)) != null) {
            HashMap<SensorListener, LegacyListener> hashMap = this.mLegacyListenersMap;
            synchronized (hashMap) {
                LegacyListener legacyListener = this.mLegacyListenersMap.get(listener);
                if (legacyListener != null && legacyListener.unregisterSensor(legacyType)) {
                    this.mSensorManager.unregisterListener(legacyListener, sensor);
                    if (!legacyListener.hasSensors()) {
                        this.mLegacyListenersMap.remove(listener);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onRotationChanged(int rotation) {
        Class<SensorManager> clazz = SensorManager.class;
        synchronized (SensorManager.class) {
            sRotation = rotation;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getRotation() {
        Class<SensorManager> clazz = SensorManager.class;
        synchronized (SensorManager.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sRotation;
        }
    }

    static {
        sRotation = 0;
    }

    private static class LegacyListener
    implements SensorEventListener {
        private float[] mValues = new float[6];
        private SensorListener mTarget;
        private int mSensors;
        private final LmsFilter mYawfilter = new LmsFilter();

        LegacyListener(SensorListener target) {
            this.mTarget = target;
            this.mSensors = 0;
        }

        boolean registerSensor(int legacyType) {
            if ((this.mSensors & legacyType) != 0) {
                return false;
            }
            boolean alreadyHasOrientationSensor = LegacyListener.hasOrientationSensor(this.mSensors);
            this.mSensors |= legacyType;
            return !alreadyHasOrientationSensor || !LegacyListener.hasOrientationSensor(legacyType);
        }

        boolean unregisterSensor(int legacyType) {
            if ((this.mSensors & legacyType) == 0) {
                return false;
            }
            this.mSensors &= ~legacyType;
            return !LegacyListener.hasOrientationSensor(legacyType) || !LegacyListener.hasOrientationSensor(this.mSensors);
        }

        boolean hasSensors() {
            return this.mSensors != 0;
        }

        private static boolean hasOrientationSensor(int sensors) {
            return (sensors & 0x81) != 0;
        }

        @Override
        public void onAccuracyChanged(Sensor sensor, int accuracy) {
            try {
                this.mTarget.onAccuracyChanged(LegacyListener.getLegacySensorType(sensor.getType()), accuracy);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }

        @Override
        public void onSensorChanged(SensorEvent event) {
            float[] v = this.mValues;
            v[0] = event.values[0];
            v[1] = event.values[1];
            v[2] = event.values[2];
            int type = event.sensor.getType();
            int legacyType = LegacyListener.getLegacySensorType(type);
            this.mapSensorDataToWindow(legacyType, v, LegacySensorManager.getRotation());
            if (type == 3) {
                if ((this.mSensors & 0x80) != 0) {
                    this.mTarget.onSensorChanged(128, v);
                }
                if ((this.mSensors & 1) != 0) {
                    v[0] = this.mYawfilter.filter(event.timestamp, v[0]);
                    this.mTarget.onSensorChanged(1, v);
                }
            } else {
                this.mTarget.onSensorChanged(legacyType, v);
            }
        }

        private void mapSensorDataToWindow(int sensor, float[] values, int orientation) {
            float x = values[0];
            float y = values[1];
            float z = values[2];
            switch (sensor) {
                case 1: 
                case 128: {
                    z = -z;
                    break;
                }
                case 2: {
                    x = -x;
                    y = -y;
                    z = -z;
                    break;
                }
                case 8: {
                    x = -x;
                    y = -y;
                }
            }
            values[0] = x;
            values[1] = y;
            values[2] = z;
            values[3] = x;
            values[4] = y;
            values[5] = z;
            if ((orientation & 1) != 0) {
                switch (sensor) {
                    case 2: 
                    case 8: {
                        values[0] = -y;
                        values[1] = x;
                        values[2] = z;
                        break;
                    }
                    case 1: 
                    case 128: {
                        values[0] = x + (float)(x < 270.0f ? 90 : -270);
                        values[1] = z;
                        values[2] = y;
                    }
                }
            }
            if ((orientation & 2) != 0) {
                x = values[0];
                y = values[1];
                z = values[2];
                switch (sensor) {
                    case 2: 
                    case 8: {
                        values[0] = -x;
                        values[1] = -y;
                        values[2] = z;
                        break;
                    }
                    case 1: 
                    case 128: {
                        values[0] = x >= 180.0f ? x - 180.0f : x + 180.0f;
                        values[1] = -y;
                        values[2] = -z;
                    }
                }
            }
        }

        private static int getLegacySensorType(int type) {
            switch (type) {
                case 1: {
                    return 2;
                }
                case 2: {
                    return 8;
                }
                case 3: {
                    return 128;
                }
                case 7: {
                    return 4;
                }
            }
            return 0;
        }
    }

    private static class LmsFilter {
        private static final int SENSORS_RATE_MS = 20;
        private static final int COUNT = 12;
        private static final float PREDICTION_RATIO = 0.33333334f;
        private static final float PREDICTION_TIME = 0.08f;
        private float[] mV = new float[24];
        private long[] mT = new long[24];
        private int mIndex = 12;

        public float filter(long time, float in) {
            float v = in;
            float ns = 1.0E-9f;
            float v1 = this.mV[this.mIndex];
            if (v - v1 > 180.0f) {
                v -= 360.0f;
            } else if (v1 - v > 180.0f) {
                v += 360.0f;
            }
            ++this.mIndex;
            if (this.mIndex >= 24) {
                this.mIndex = 12;
            }
            this.mV[this.mIndex] = v;
            this.mT[this.mIndex] = time;
            this.mV[this.mIndex - 12] = v;
            this.mT[this.mIndex - 12] = time;
            float E = 0.0f;
            float D = 0.0f;
            float C = 0.0f;
            float B = 0.0f;
            float A = 0.0f;
            for (int i = 0; i < 11; ++i) {
                int j = this.mIndex - 1 - i;
                float Z = this.mV[j];
                float T = (float)(this.mT[j] / 2L + this.mT[j + 1] / 2L - time) * 1.0E-9f;
                float dT = (float)(this.mT[j] - this.mT[j + 1]) * 1.0E-9f;
                dT *= dT;
                A += Z * dT;
                B += T * (T * dT);
                C += T * dT;
                D += Z * (T * dT);
                E += dT;
            }
            float b = (A * B + C * D) / (E * B + C * C);
            float a = (E * b - A) / C;
            float f = b + 0.08f * a;
            float f2 = (f *= 0.0027777778f) >= 0.0f ? f : -f;
            if (f2 >= 0.5f) {
                f = f - (float)Math.ceil(f + 0.5f) + 1.0f;
            }
            if (f < 0.0f) {
                f += 1.0f;
            }
            return f *= 360.0f;
        }
    }
}

