/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics;

import android.hardware.biometrics.events.AuthenticationAcquiredInfo;
import android.hardware.biometrics.events.AuthenticationErrorInfo;
import android.hardware.biometrics.events.AuthenticationFailedInfo;
import android.hardware.biometrics.events.AuthenticationHelpInfo;
import android.hardware.biometrics.events.AuthenticationStartedInfo;
import android.hardware.biometrics.events.AuthenticationStoppedInfo;
import android.hardware.biometrics.events.AuthenticationSucceededInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface AuthenticationStateListener
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.biometrics.AuthenticationStateListener";

    public void onAuthenticationAcquired(AuthenticationAcquiredInfo var1) throws RemoteException;

    public void onAuthenticationError(AuthenticationErrorInfo var1) throws RemoteException;

    public void onAuthenticationFailed(AuthenticationFailedInfo var1) throws RemoteException;

    public void onAuthenticationHelp(AuthenticationHelpInfo var1) throws RemoteException;

    public void onAuthenticationStarted(AuthenticationStartedInfo var1) throws RemoteException;

    public void onAuthenticationStopped(AuthenticationStoppedInfo var1) throws RemoteException;

    public void onAuthenticationSucceeded(AuthenticationSucceededInfo var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements AuthenticationStateListener {
        static final int TRANSACTION_onAuthenticationAcquired = 1;
        static final int TRANSACTION_onAuthenticationError = 2;
        static final int TRANSACTION_onAuthenticationFailed = 3;
        static final int TRANSACTION_onAuthenticationHelp = 4;
        static final int TRANSACTION_onAuthenticationStarted = 5;
        static final int TRANSACTION_onAuthenticationStopped = 6;
        static final int TRANSACTION_onAuthenticationSucceeded = 7;

        public Stub() {
            this.attachInterface(this, AuthenticationStateListener.DESCRIPTOR);
        }

        public static AuthenticationStateListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(AuthenticationStateListener.DESCRIPTOR);
            if (iin != null && iin instanceof AuthenticationStateListener) {
                return (AuthenticationStateListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onAuthenticationAcquired";
                }
                case 2: {
                    return "onAuthenticationError";
                }
                case 3: {
                    return "onAuthenticationFailed";
                }
                case 4: {
                    return "onAuthenticationHelp";
                }
                case 5: {
                    return "onAuthenticationStarted";
                }
                case 6: {
                    return "onAuthenticationStopped";
                }
                case 7: {
                    return "onAuthenticationSucceeded";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = AuthenticationStateListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    AuthenticationAcquiredInfo _arg0 = data.readTypedObject(AuthenticationAcquiredInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onAuthenticationAcquired(_arg0);
                    break;
                }
                case 2: {
                    AuthenticationErrorInfo _arg0 = data.readTypedObject(AuthenticationErrorInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onAuthenticationError(_arg0);
                    break;
                }
                case 3: {
                    AuthenticationFailedInfo _arg0 = data.readTypedObject(AuthenticationFailedInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onAuthenticationFailed(_arg0);
                    break;
                }
                case 4: {
                    AuthenticationHelpInfo _arg0 = data.readTypedObject(AuthenticationHelpInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onAuthenticationHelp(_arg0);
                    break;
                }
                case 5: {
                    AuthenticationStartedInfo _arg0 = data.readTypedObject(AuthenticationStartedInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onAuthenticationStarted(_arg0);
                    break;
                }
                case 6: {
                    AuthenticationStoppedInfo _arg0 = data.readTypedObject(AuthenticationStoppedInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onAuthenticationStopped(_arg0);
                    break;
                }
                case 7: {
                    AuthenticationSucceededInfo _arg0 = data.readTypedObject(AuthenticationSucceededInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onAuthenticationSucceeded(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 6;
        }

        private static class Proxy
        implements AuthenticationStateListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return AuthenticationStateListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAuthenticationAcquired(AuthenticationAcquiredInfo authInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(AuthenticationStateListener.DESCRIPTOR);
                    _data.writeTypedObject(authInfo, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAuthenticationError(AuthenticationErrorInfo authInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(AuthenticationStateListener.DESCRIPTOR);
                    _data.writeTypedObject(authInfo, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAuthenticationFailed(AuthenticationFailedInfo authInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(AuthenticationStateListener.DESCRIPTOR);
                    _data.writeTypedObject(authInfo, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAuthenticationHelp(AuthenticationHelpInfo authInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(AuthenticationStateListener.DESCRIPTOR);
                    _data.writeTypedObject(authInfo, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAuthenticationStarted(AuthenticationStartedInfo authInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(AuthenticationStateListener.DESCRIPTOR);
                    _data.writeTypedObject(authInfo, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAuthenticationStopped(AuthenticationStoppedInfo authInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(AuthenticationStateListener.DESCRIPTOR);
                    _data.writeTypedObject(authInfo, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAuthenticationSucceeded(AuthenticationSucceededInfo authInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(AuthenticationStateListener.DESCRIPTOR);
                    _data.writeTypedObject(authInfo, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements AuthenticationStateListener {
        @Override
        public void onAuthenticationAcquired(AuthenticationAcquiredInfo authInfo) throws RemoteException {
        }

        @Override
        public void onAuthenticationError(AuthenticationErrorInfo authInfo) throws RemoteException {
        }

        @Override
        public void onAuthenticationFailed(AuthenticationFailedInfo authInfo) throws RemoteException {
        }

        @Override
        public void onAuthenticationHelp(AuthenticationHelpInfo authInfo) throws RemoteException {
        }

        @Override
        public void onAuthenticationStarted(AuthenticationStartedInfo authInfo) throws RemoteException {
        }

        @Override
        public void onAuthenticationStopped(AuthenticationStoppedInfo authInfo) throws RemoteException {
        }

        @Override
        public void onAuthenticationSucceeded(AuthenticationSucceededInfo authInfo) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

