/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.hardware.biometrics.BiometricEnrollmentStatus;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@FlaggedApi(value="android.hardware.biometrics.move_fm_api_to_bm")
public class BiometricEnrollmentStatusInternal
implements Parcelable {
    private final int mModality;
    private final BiometricEnrollmentStatus mStatus;
    @NonNull
    public static final Parcelable.Creator<BiometricEnrollmentStatusInternal> CREATOR = new Parcelable.Creator<BiometricEnrollmentStatusInternal>(){

        @Override
        public BiometricEnrollmentStatusInternal createFromParcel(Parcel in) {
            return new BiometricEnrollmentStatusInternal(in);
        }

        public BiometricEnrollmentStatusInternal[] newArray(int size) {
            return new BiometricEnrollmentStatusInternal[size];
        }
    };

    public BiometricEnrollmentStatusInternal(int modality, BiometricEnrollmentStatus status) {
        this.mModality = modality;
        this.mStatus = status;
    }

    public int getModality() {
        return this.mModality;
    }

    public BiometricEnrollmentStatus getStatus() {
        return this.mStatus;
    }

    private BiometricEnrollmentStatusInternal(Parcel in) {
        this(in.readInt(), new BiometricEnrollmentStatus(in.readInt()));
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mModality);
        dest.writeInt(this.mStatus.getEnrollmentCount());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        String modality = "";
        if (this.mModality == 2) {
            modality = "Fingerprint";
        } else if (this.mModality == 8) {
            modality = "Face";
        }
        return "Modality: " + modality + ", Enrolled Count: " + this.mStatus.getEnrollmentCount();
    }

    public int hashCode() {
        return Objects.hash(this.mModality, this.mStatus.getEnrollmentCount());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BiometricEnrollmentStatusInternal other = (BiometricEnrollmentStatusInternal)obj;
        return this.mModality == other.mModality && this.mStatus.getEnrollmentCount() == other.mStatus.getEnrollmentCount();
    }
}

