/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;

public class SensorLocationInternal
implements Parcelable {
    public static final SensorLocationInternal DEFAULT = new SensorLocationInternal("", 0, 0, 0);
    @NonNull
    public final String displayId;
    public final int sensorLocationX;
    public final int sensorLocationY;
    public final int sensorRadius;
    public static final Parcelable.Creator<SensorLocationInternal> CREATOR = new Parcelable.Creator<SensorLocationInternal>(){

        @Override
        public SensorLocationInternal createFromParcel(Parcel in) {
            return new SensorLocationInternal(in);
        }

        public SensorLocationInternal[] newArray(int size) {
            return new SensorLocationInternal[size];
        }
    };

    public SensorLocationInternal(@Nullable String displayId, int sensorLocationX, int sensorLocationY, int sensorRadius) {
        this.displayId = displayId != null ? displayId : "";
        this.sensorLocationX = sensorLocationX;
        this.sensorLocationY = sensorLocationY;
        this.sensorRadius = sensorRadius;
    }

    protected SensorLocationInternal(Parcel in) {
        this.displayId = in.readString16NoHelper();
        this.sensorLocationX = in.readInt();
        this.sensorLocationY = in.readInt();
        this.sensorRadius = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.displayId);
        dest.writeInt(this.sensorLocationX);
        dest.writeInt(this.sensorLocationY);
        dest.writeInt(this.sensorRadius);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "[id: " + this.displayId + ", x: " + this.sensorLocationX + ", y: " + this.sensorLocationY + ", r: " + this.sensorRadius + "]";
    }

    public Rect getRect() {
        return new Rect(this.sensorLocationX - this.sensorRadius, this.sensorLocationY - this.sensorRadius, this.sensorLocationX + this.sensorRadius, this.sensorLocationY + this.sensorRadius);
    }
}

