/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics.events;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.hardware.biometrics.BiometricRequestConstants;
import android.hardware.biometrics.BiometricSourceType;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;
import java.util.Objects;

public class AuthenticationSucceededInfo
implements Parcelable {
    @NonNull
    private final BiometricSourceType mBiometricSourceType;
    private final int mRequestReason;
    private final boolean mIsStrongBiometric;
    private final int mUserId;
    @NonNull
    public static final Parcelable.Creator<AuthenticationSucceededInfo> CREATOR = new Parcelable.Creator<AuthenticationSucceededInfo>(){

        public AuthenticationSucceededInfo[] newArray(int size) {
            return new AuthenticationSucceededInfo[size];
        }

        @Override
        public AuthenticationSucceededInfo createFromParcel(@NonNull Parcel in) {
            return new AuthenticationSucceededInfo(in);
        }
    };

    AuthenticationSucceededInfo(@NonNull BiometricSourceType biometricSourceType, int requestReason, boolean isStrongBiometric, int userId) {
        this.mBiometricSourceType = biometricSourceType;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mBiometricSourceType);
        this.mRequestReason = requestReason;
        AnnotationValidations.validate(BiometricRequestConstants.RequestReason.class, null, this.mRequestReason);
        this.mIsStrongBiometric = isStrongBiometric;
        this.mUserId = userId;
    }

    @NonNull
    public BiometricSourceType getBiometricSourceType() {
        return this.mBiometricSourceType;
    }

    public int getRequestReason() {
        return this.mRequestReason;
    }

    public boolean isIsStrongBiometric() {
        return this.mIsStrongBiometric;
    }

    public int getUserId() {
        return this.mUserId;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationSucceededInfo that = (AuthenticationSucceededInfo)o;
        return Objects.equals(this.mBiometricSourceType, that.mBiometricSourceType) && this.mRequestReason == that.mRequestReason && this.mIsStrongBiometric == that.mIsStrongBiometric && this.mUserId == that.mUserId;
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Objects.hashCode(this.mBiometricSourceType);
        _hash = 31 * _hash + this.mRequestReason;
        _hash = 31 * _hash + Boolean.hashCode(this.mIsStrongBiometric);
        _hash = 31 * _hash + this.mUserId;
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        byte flg = 0;
        if (this.mIsStrongBiometric) {
            flg = (byte)(flg | 4);
        }
        dest.writeByte(flg);
        dest.writeTypedObject(this.mBiometricSourceType, flags);
        dest.writeInt(this.mRequestReason);
        dest.writeInt(this.mUserId);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    AuthenticationSucceededInfo(@NonNull Parcel in) {
        byte flg = in.readByte();
        boolean isStrongBiometric = (flg & 4) != 0;
        BiometricSourceType biometricSourceType = in.readTypedObject(BiometricSourceType.CREATOR);
        int requestReason = in.readInt();
        int userId = in.readInt();
        this.mBiometricSourceType = biometricSourceType;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mBiometricSourceType);
        this.mRequestReason = requestReason;
        AnnotationValidations.validate(BiometricRequestConstants.RequestReason.class, null, this.mRequestReason);
        this.mIsStrongBiometric = isStrongBiometric;
        this.mUserId = userId;
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder {
        @NonNull
        private BiometricSourceType mBiometricSourceType;
        private int mRequestReason;
        private boolean mIsStrongBiometric;
        private int mUserId;
        private long mBuilderFieldsSet = 0L;

        public Builder(@NonNull BiometricSourceType biometricSourceType, int requestReason, boolean isStrongBiometric, int userId) {
            this.mBiometricSourceType = biometricSourceType;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mBiometricSourceType);
            this.mRequestReason = requestReason;
            AnnotationValidations.validate(BiometricRequestConstants.RequestReason.class, null, this.mRequestReason);
            this.mIsStrongBiometric = isStrongBiometric;
            this.mUserId = userId;
        }

        @NonNull
        public Builder setBiometricSourceType(@NonNull BiometricSourceType value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 1L;
            this.mBiometricSourceType = value;
            return this;
        }

        @NonNull
        public Builder setRequestReason(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mRequestReason = value;
            return this;
        }

        @NonNull
        public Builder setIsStrongBiometric(boolean value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mIsStrongBiometric = value;
            return this;
        }

        @NonNull
        public Builder setUserId(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            this.mUserId = value;
            return this;
        }

        @NonNull
        public AuthenticationSucceededInfo build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x10L;
            AuthenticationSucceededInfo o = new AuthenticationSucceededInfo(this.mBiometricSourceType, this.mRequestReason, this.mIsStrongBiometric, this.mUserId);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 0x10L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }
}

