/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.hardware.camera2.CameraMetadataInfo;
import android.hardware.camera2.impl.CaptureResultExtras;
import android.hardware.camera2.impl.PhysicalCaptureResultInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ICameraDeviceCallbacks
extends IInterface {
    public static final int ERROR_CAMERA_INVALID_ERROR = -1;
    public static final int ERROR_CAMERA_DISCONNECTED = 0;
    public static final int ERROR_CAMERA_DEVICE = 1;
    public static final int ERROR_CAMERA_SERVICE = 2;
    public static final int ERROR_CAMERA_REQUEST = 3;
    public static final int ERROR_CAMERA_RESULT = 4;
    public static final int ERROR_CAMERA_BUFFER = 5;
    public static final int ERROR_CAMERA_DISABLED = 6;

    public void onDeviceError(int var1, CaptureResultExtras var2) throws RemoteException;

    public void onDeviceIdle() throws RemoteException;

    public void onCaptureStarted(CaptureResultExtras var1, long var2) throws RemoteException;

    public void onResultReceived(CameraMetadataInfo var1, CaptureResultExtras var2, PhysicalCaptureResultInfo[] var3) throws RemoteException;

    public void onPrepared(int var1) throws RemoteException;

    public void onRepeatingRequestError(long var1, int var3) throws RemoteException;

    public void onRequestQueueEmpty() throws RemoteException;

    public void onClientSharedAccessPriorityChanged(boolean var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICameraDeviceCallbacks {
        public static final String DESCRIPTOR = "android.hardware.camera2.ICameraDeviceCallbacks";
        static final int TRANSACTION_onDeviceError = 1;
        static final int TRANSACTION_onDeviceIdle = 2;
        static final int TRANSACTION_onCaptureStarted = 3;
        static final int TRANSACTION_onResultReceived = 4;
        static final int TRANSACTION_onPrepared = 5;
        static final int TRANSACTION_onRepeatingRequestError = 6;
        static final int TRANSACTION_onRequestQueueEmpty = 7;
        static final int TRANSACTION_onClientSharedAccessPriorityChanged = 8;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ICameraDeviceCallbacks asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ICameraDeviceCallbacks) {
                return (ICameraDeviceCallbacks)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onDeviceError";
                }
                case 2: {
                    return "onDeviceIdle";
                }
                case 3: {
                    return "onCaptureStarted";
                }
                case 4: {
                    return "onResultReceived";
                }
                case 5: {
                    return "onPrepared";
                }
                case 6: {
                    return "onRepeatingRequestError";
                }
                case 7: {
                    return "onRequestQueueEmpty";
                }
                case 8: {
                    return "onClientSharedAccessPriorityChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    CaptureResultExtras _arg1 = data.readTypedObject(CaptureResultExtras.CREATOR);
                    data.enforceNoDataAvail();
                    this.onDeviceError(_arg0, _arg1);
                    break;
                }
                case 2: {
                    this.onDeviceIdle();
                    break;
                }
                case 3: {
                    CaptureResultExtras _arg0 = data.readTypedObject(CaptureResultExtras.CREATOR);
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    this.onCaptureStarted(_arg0, _arg1);
                    break;
                }
                case 4: {
                    CameraMetadataInfo _arg0 = data.readTypedObject(CameraMetadataInfo.CREATOR);
                    CaptureResultExtras _arg1 = data.readTypedObject(CaptureResultExtras.CREATOR);
                    PhysicalCaptureResultInfo[] _arg2 = data.createTypedArray(PhysicalCaptureResultInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onResultReceived(_arg0, _arg1, _arg2);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onPrepared(_arg0);
                    break;
                }
                case 6: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRepeatingRequestError(_arg0, _arg1);
                    break;
                }
                case 7: {
                    this.onRequestQueueEmpty();
                    break;
                }
                case 8: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onClientSharedAccessPriorityChanged(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 7;
        }

        private static class Proxy
        implements ICameraDeviceCallbacks {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDeviceError(int errorCode, CaptureResultExtras resultExtras) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(errorCode);
                    _data.writeTypedObject(resultExtras, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onDeviceIdle() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureStarted(CaptureResultExtras resultExtras, long timestamp) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(resultExtras, 0);
                    _data.writeLong(timestamp);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResultReceived(CameraMetadataInfo resultInfo, CaptureResultExtras resultExtras, PhysicalCaptureResultInfo[] physicalCaptureResultInfos) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(resultInfo, 0);
                    _data.writeTypedObject(resultExtras, 0);
                    _data.writeTypedArray(physicalCaptureResultInfos, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPrepared(int streamId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamId);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRepeatingRequestError(long lastFrameNumber, int repeatingRequestId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(lastFrameNumber);
                    _data.writeInt(repeatingRequestId);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onRequestQueueEmpty() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onClientSharedAccessPriorityChanged(boolean primaryClient) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(primaryClient);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ICameraDeviceCallbacks {
        @Override
        public void onDeviceError(int errorCode, CaptureResultExtras resultExtras) throws RemoteException {
        }

        @Override
        public void onDeviceIdle() throws RemoteException {
        }

        @Override
        public void onCaptureStarted(CaptureResultExtras resultExtras, long timestamp) throws RemoteException {
        }

        @Override
        public void onResultReceived(CameraMetadataInfo resultInfo, CaptureResultExtras resultExtras, PhysicalCaptureResultInfo[] physicalCaptureResultInfos) throws RemoteException {
        }

        @Override
        public void onPrepared(int streamId) throws RemoteException {
        }

        @Override
        public void onRepeatingRequestError(long lastFrameNumber, int repeatingRequestId) throws RemoteException {
        }

        @Override
        public void onRequestQueueEmpty() throws RemoteException {
        }

        @Override
        public void onClientSharedAccessPriorityChanged(boolean primaryClient) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

