/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.extension;

import android.hardware.camera2.impl.CameraMetadataNative;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IProcessResultImpl
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.camera2.extension.IProcessResultImpl";

    public void onCaptureCompleted(long var1, CameraMetadataNative var3) throws RemoteException;

    public void onCaptureProcessProgressed(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IProcessResultImpl {
        static final int TRANSACTION_onCaptureCompleted = 1;
        static final int TRANSACTION_onCaptureProcessProgressed = 2;

        public Stub() {
            this.attachInterface(this, IProcessResultImpl.DESCRIPTOR);
        }

        public static IProcessResultImpl asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IProcessResultImpl.DESCRIPTOR);
            if (iin != null && iin instanceof IProcessResultImpl) {
                return (IProcessResultImpl)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onCaptureCompleted";
                }
                case 2: {
                    return "onCaptureProcessProgressed";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IProcessResultImpl.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    long _arg0 = data.readLong();
                    CameraMetadataNative _arg1 = data.readTypedObject(CameraMetadataNative.CREATOR);
                    data.enforceNoDataAvail();
                    this.onCaptureCompleted(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onCaptureProcessProgressed(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IProcessResultImpl {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IProcessResultImpl.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureCompleted(long shutterTimestamp, CameraMetadataNative results) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IProcessResultImpl.DESCRIPTOR);
                    _data.writeLong(shutterTimestamp);
                    _data.writeTypedObject(results, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureProcessProgressed(int progress) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IProcessResultImpl.DESCRIPTOR);
                    _data.writeInt(progress);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IProcessResultImpl {
        @Override
        public void onCaptureCompleted(long shutterTimestamp, CameraMetadataNative results) throws RemoteException {
        }

        @Override
        public void onCaptureProcessProgressed(int progress) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

