/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.content.Context;
import android.graphics.ColorSpace;
import android.graphics.SurfaceTexture;
import android.hardware.SyncFence;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraExtensionCharacteristics;
import android.hardware.camera2.CameraExtensionSession;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.extension.CameraOutputConfig;
import android.hardware.camera2.extension.CameraSessionConfig;
import android.hardware.camera2.extension.IAdvancedExtenderImpl;
import android.hardware.camera2.extension.ICaptureCallback;
import android.hardware.camera2.extension.IImageProcessorImpl;
import android.hardware.camera2.extension.IInitializeSessionCallback;
import android.hardware.camera2.extension.IRequestCallback;
import android.hardware.camera2.extension.IRequestProcessorImpl;
import android.hardware.camera2.extension.ISessionProcessorImpl;
import android.hardware.camera2.extension.LatencyPair;
import android.hardware.camera2.extension.OutputConfigId;
import android.hardware.camera2.extension.OutputSurface;
import android.hardware.camera2.extension.ParcelCaptureResult;
import android.hardware.camera2.extension.ParcelImage;
import android.hardware.camera2.extension.ParcelTotalCaptureResult;
import android.hardware.camera2.extension.Request;
import android.hardware.camera2.impl.CameraDeviceImpl;
import android.hardware.camera2.impl.CameraExtensionUtils;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.impl.PhysicalCaptureResultInfo;
import android.hardware.camera2.params.DynamicRangeProfiles;
import android.hardware.camera2.params.ExtensionSessionConfiguration;
import android.hardware.camera2.params.OutputConfiguration;
import android.hardware.camera2.params.SessionConfiguration;
import android.hardware.camera2.utils.ExtensionSessionStatsAggregator;
import android.hardware.camera2.utils.SurfaceUtils;
import android.media.Image;
import android.media.ImageReader;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import com.android.internal.hidden_from_bootclasspath.com.android.internal.camera.flags.Flags;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class CameraAdvancedExtensionSessionImpl
extends CameraExtensionSession {
    private static final String TAG = "CameraAdvancedExtensionSessionImpl";
    private final Executor mExecutor;
    private CameraDevice mCameraDevice;
    private final Map<String, CameraMetadataNative> mCharacteristicsMap;
    private final Handler mHandler;
    private final HandlerThread mHandlerThread;
    private final CameraExtensionSession.StateCallback mCallbacks;
    private IAdvancedExtenderImpl mAdvancedExtender;
    private final HashMap<Surface, CameraOutputConfig> mCameraConfigMap = new HashMap();
    private final HashMap<Integer, ImageReader> mReaderMap = new HashMap();
    private RequestProcessor mRequestProcessor = new RequestProcessor();
    private final int mSessionId;
    private IBinder mToken = null;
    private Surface mClientRepeatingRequestSurface;
    private Surface mClientCaptureSurface;
    private Surface mClientPostviewSurface;
    private OutputConfiguration mClientRepeatingRequestOutputConfig;
    private OutputConfiguration mClientCaptureOutputConfig;
    private OutputConfiguration mClientPostviewOutputConfig;
    private CameraCaptureSession mCaptureSession = null;
    private ISessionProcessorImpl mSessionProcessor = null;
    private final InitializeSessionHandler mInitializeHandler;
    private final ExtensionSessionStatsAggregator mStatsAggregator;
    private boolean mInitialized;
    private boolean mSessionClosed;
    private int mExtensionType;
    private final Context mContext;
    final Object mInterfaceLock;

    @RequiresPermission(value="android.permission.CAMERA")
    public static CameraAdvancedExtensionSessionImpl createCameraAdvancedExtensionSession(@NonNull CameraDeviceImpl cameraDevice, @NonNull Map<String, CameraCharacteristics> characteristicsMap, @NonNull Context ctx, @NonNull ExtensionSessionConfiguration config, int sessionId, @NonNull IBinder token) throws CameraAccessException, RemoteException {
        String cameraId = cameraDevice.getId();
        CameraExtensionCharacteristics extensionChars = new CameraExtensionCharacteristics(ctx, cameraId, characteristicsMap);
        Map<String, CameraMetadataNative> characteristicsMapNative = CameraExtensionUtils.getCharacteristicsMapNative(characteristicsMap);
        if (!CameraExtensionCharacteristics.isExtensionSupported(cameraDevice.getId(), config.getExtension(), characteristicsMapNative)) {
            throw new UnsupportedOperationException("Unsupported extension type: " + config.getExtension());
        }
        if (config.getOutputConfigurations().isEmpty() || config.getOutputConfigurations().size() > 2) {
            throw new IllegalArgumentException("Unexpected amount of output surfaces, received: " + config.getOutputConfigurations().size() + " expected <= 2");
        }
        for (OutputConfiguration c : config.getOutputConfigurations()) {
            if (c.getDynamicRangeProfile() != 1L) {
                if (Flags.cameraExtensionsCharacteristicsGet()) {
                    DynamicRangeProfiles dynamicProfiles = extensionChars.get(config.getExtension(), CameraCharacteristics.REQUEST_AVAILABLE_DYNAMIC_RANGE_PROFILES);
                    if (dynamicProfiles == null || !dynamicProfiles.getSupportedProfiles().contains(c.getDynamicRangeProfile())) {
                        throw new IllegalArgumentException("Unsupported dynamic range profile: " + c.getDynamicRangeProfile());
                    }
                } else {
                    throw new IllegalArgumentException("Unsupported dynamic range profile: " + c.getDynamicRangeProfile());
                }
            }
            if (c.getStreamUseCase() == 0L) continue;
            throw new IllegalArgumentException("Unsupported stream use case: " + c.getStreamUseCase());
        }
        int suitableSurfaceCount = 0;
        List<Size> supportedPreviewSizes = extensionChars.getExtensionSupportedSizes(config.getExtension(), SurfaceTexture.class);
        Surface repeatingRequestSurface = CameraExtensionUtils.getRepeatingRequestSurface(config.getOutputConfigurations(), supportedPreviewSizes);
        OutputConfiguration repeatingRequestOutputConfig = null;
        if (repeatingRequestSurface != null) {
            for (OutputConfiguration outputConfig : config.getOutputConfigurations()) {
                if (outputConfig.getSurface() != repeatingRequestSurface) continue;
                repeatingRequestOutputConfig = outputConfig;
            }
            ++suitableSurfaceCount;
        }
        HashMap<Integer, List<Size>> supportedCaptureSizes = new HashMap<Integer, List<Size>>();
        Integer[] supportedCaptureOutputFormats = new Integer[CameraExtensionUtils.SUPPORTED_CAPTURE_OUTPUT_FORMATS.size()];
        Integer[] integerArray = supportedCaptureOutputFormats = CameraExtensionUtils.SUPPORTED_CAPTURE_OUTPUT_FORMATS.toArray(supportedCaptureOutputFormats);
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int format = integerArray[i];
            List<Size> supportedSizes = extensionChars.getExtensionSupportedSizes(config.getExtension(), format);
            if (supportedSizes == null) continue;
            supportedCaptureSizes.put(format, supportedSizes);
        }
        int captureFormat = 0;
        Surface burstCaptureSurface = CameraExtensionUtils.getBurstCaptureSurface(config.getOutputConfigurations(), supportedCaptureSizes);
        OutputConfiguration burstCaptureOutputConfig = null;
        if (burstCaptureSurface != null) {
            for (OutputConfiguration outputConfig : config.getOutputConfigurations()) {
                if (outputConfig.getSurface() != burstCaptureSurface) continue;
                burstCaptureOutputConfig = outputConfig;
            }
            ++suitableSurfaceCount;
            if (Flags.analytics24q3()) {
                CameraExtensionUtils.SurfaceInfo burstCaptureSurfaceInfo = CameraExtensionUtils.querySurface(burstCaptureSurface);
                captureFormat = burstCaptureSurfaceInfo.mFormat;
            }
        }
        if (suitableSurfaceCount != config.getOutputConfigurations().size()) {
            throw new IllegalArgumentException("One or more unsupported output surfaces found!");
        }
        Surface postviewSurface = null;
        OutputConfiguration postviewOutputConfig = config.getPostviewOutputConfiguration();
        if (burstCaptureSurface != null && config.getPostviewOutputConfiguration() != null) {
            CameraExtensionUtils.SurfaceInfo burstCaptureSurfaceInfo = CameraExtensionUtils.querySurface(burstCaptureSurface);
            Size burstCaptureSurfaceSize = new Size(burstCaptureSurfaceInfo.mWidth, burstCaptureSurfaceInfo.mHeight);
            HashMap<Integer, List<Size>> supportedPostviewSizes = new HashMap<Integer, List<Size>>();
            Integer[] integerArray2 = supportedCaptureOutputFormats;
            int n2 = integerArray2.length;
            for (int i = 0; i < n2; ++i) {
                int format = integerArray2[i];
                List<Size> supportedSizesPostview = extensionChars.getPostviewSupportedSizes(config.getExtension(), burstCaptureSurfaceSize, format);
                if (supportedSizesPostview == null) continue;
                supportedPostviewSizes.put(format, supportedSizesPostview);
            }
            postviewSurface = CameraExtensionUtils.getPostviewSurface(config.getPostviewOutputConfiguration(), supportedPostviewSizes, burstCaptureSurfaceInfo.mFormat);
            if (postviewSurface == null) {
                throw new IllegalArgumentException("Unsupported output surface for postview!");
            }
        }
        IAdvancedExtenderImpl extender = CameraExtensionCharacteristics.initializeAdvancedExtension(config.getExtension());
        extender.init(cameraId, characteristicsMapNative);
        CameraAdvancedExtensionSessionImpl ret = new CameraAdvancedExtensionSessionImpl(ctx, extender, cameraDevice, characteristicsMapNative, repeatingRequestOutputConfig, burstCaptureOutputConfig, postviewOutputConfig, config.getStateCallback(), config.getExecutor(), sessionId, token, config.getExtension());
        if (Flags.analytics24q3()) {
            ret.mStatsAggregator.setCaptureFormat(captureFormat);
        }
        ret.mStatsAggregator.setClientName(ctx.getOpPackageName());
        ret.mStatsAggregator.setExtensionType(config.getExtension());
        ret.initialize();
        return ret;
    }

    private CameraAdvancedExtensionSessionImpl(Context ctx, @NonNull IAdvancedExtenderImpl extender, @NonNull CameraDeviceImpl cameraDevice, Map<String, CameraMetadataNative> characteristicsMap, @Nullable OutputConfiguration repeatingRequestOutputConfig, @Nullable OutputConfiguration burstCaptureOutputConfig, @Nullable OutputConfiguration postviewOutputConfig, @NonNull CameraExtensionSession.StateCallback callback, @NonNull Executor executor, int sessionId, @NonNull IBinder token, int extension) {
        this.mContext = ctx;
        this.mAdvancedExtender = extender;
        this.mCameraDevice = cameraDevice;
        this.mCharacteristicsMap = characteristicsMap;
        this.mCallbacks = callback;
        this.mExecutor = executor;
        this.mClientRepeatingRequestOutputConfig = repeatingRequestOutputConfig;
        this.mClientCaptureOutputConfig = burstCaptureOutputConfig;
        this.mClientPostviewOutputConfig = postviewOutputConfig;
        if (repeatingRequestOutputConfig != null) {
            this.mClientRepeatingRequestSurface = repeatingRequestOutputConfig.getSurface();
        }
        if (burstCaptureOutputConfig != null) {
            this.mClientCaptureSurface = burstCaptureOutputConfig.getSurface();
        }
        if (postviewOutputConfig != null) {
            this.mClientPostviewSurface = postviewOutputConfig.getSurface();
        }
        this.mHandlerThread = new HandlerThread(TAG);
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
        this.mInitialized = false;
        this.mSessionClosed = false;
        this.mInitializeHandler = new InitializeSessionHandler();
        this.mSessionId = sessionId;
        this.mToken = token;
        this.mInterfaceLock = cameraDevice.mInterfaceLock;
        this.mExtensionType = extension;
        this.mStatsAggregator = new ExtensionSessionStatsAggregator(this.mCameraDevice.getId(), true);
    }

    public synchronized void initialize() throws CameraAccessException, RemoteException {
        if (this.mInitialized) {
            Log.d(TAG, "Session already initialized");
            return;
        }
        OutputSurface previewSurface = CameraAdvancedExtensionSessionImpl.initializeParcelable(this.mClientRepeatingRequestOutputConfig);
        OutputSurface captureSurface = CameraAdvancedExtensionSessionImpl.initializeParcelable(this.mClientCaptureOutputConfig);
        OutputSurface postviewSurface = CameraAdvancedExtensionSessionImpl.initializeParcelable(this.mClientPostviewOutputConfig);
        this.mSessionProcessor = this.mAdvancedExtender.getSessionProcessor();
        CameraSessionConfig sessionConfig = this.mSessionProcessor.initSession(this.mToken, this.mCameraDevice.getId(), this.mCharacteristicsMap, previewSurface, captureSurface, postviewSurface);
        List<CameraOutputConfig> outputConfigs = sessionConfig.outputConfigs;
        ArrayList<OutputConfiguration> outputList = new ArrayList<OutputConfiguration>();
        for (CameraOutputConfig output : outputConfigs) {
            Surface outputSurface = this.initializeSurface(output);
            if (outputSurface == null) continue;
            OutputConfiguration cameraOutput = new OutputConfiguration(output.surfaceGroupId, outputSurface);
            if (output.isMultiResolutionOutput) {
                cameraOutput.setMultiResolutionOutput();
            }
            if (output.sharedSurfaceConfigs != null && !output.sharedSurfaceConfigs.isEmpty()) {
                cameraOutput.enableSurfaceSharing();
                for (CameraOutputConfig sharedOutputConfig : output.sharedSurfaceConfigs) {
                    Surface sharedSurface = this.initializeSurface(sharedOutputConfig);
                    if (sharedSurface == null) continue;
                    cameraOutput.addSurface(sharedSurface);
                    this.mCameraConfigMap.put(sharedSurface, sharedOutputConfig);
                }
            }
            cameraOutput.setTimestampBase(1);
            cameraOutput.setReadoutTimestampEnabled(false);
            cameraOutput.setPhysicalCameraId(output.physicalCameraId);
            boolean validDynamicRangeProfile = false;
            for (long profile = 1L; profile < 4096L; profile <<= 1) {
                if (output.dynamicRangeProfile != profile) continue;
                validDynamicRangeProfile = true;
                break;
            }
            if (validDynamicRangeProfile) {
                cameraOutput.setDynamicRangeProfile(output.dynamicRangeProfile);
            } else {
                Log.e(TAG, "Extension configured dynamic range profile " + output.dynamicRangeProfile + " is not valid, using default DynamicRangeProfile.STANDARD");
            }
            outputList.add(cameraOutput);
            this.mCameraConfigMap.put(cameraOutput.getSurface(), output);
        }
        int sessionType = 0;
        if (sessionConfig.sessionType != -1 && sessionConfig.sessionType != 1) {
            sessionType = sessionConfig.sessionType;
            Log.v(TAG, "Using session type: " + sessionType);
        }
        SessionConfiguration sessionConfiguration = new SessionConfiguration(sessionType, outputList, new CameraExtensionUtils.HandlerExecutor(this.mHandler), new SessionStateHandler());
        if (sessionConfig.colorSpace >= 0 && sessionConfig.colorSpace < ColorSpace.Named.values().length) {
            sessionConfiguration.setColorSpace(ColorSpace.Named.values()[sessionConfig.colorSpace]);
        } else {
            Log.e(TAG, "Extension configured color space " + sessionConfig.colorSpace + " is not valid, using default unspecified color space");
        }
        if (sessionConfig.sessionParameter != null && !sessionConfig.sessionParameter.isEmpty()) {
            CaptureRequest.Builder requestBuilder = this.mCameraDevice.createCaptureRequest(sessionConfig.sessionTemplateId);
            CaptureRequest sessionRequest = requestBuilder.build();
            CameraMetadataNative.update(sessionRequest.getNativeMetadata(), sessionConfig.sessionParameter);
            sessionConfiguration.setSessionParameters(sessionRequest);
        }
        this.mCameraDevice.createCaptureSession(sessionConfiguration);
    }

    private static ParcelCaptureResult initializeParcelable(CaptureResult result) {
        ParcelCaptureResult ret = new ParcelCaptureResult();
        ret.cameraId = result.getCameraId();
        ret.results = result.getNativeMetadata();
        ret.parent = result.getRequest();
        ret.sequenceId = result.getSequenceId();
        ret.frameNumber = result.getFrameNumber();
        return ret;
    }

    private static ParcelTotalCaptureResult initializeParcelable(TotalCaptureResult totalResult) {
        ParcelTotalCaptureResult ret = new ParcelTotalCaptureResult();
        ret.logicalCameraId = totalResult.getCameraId();
        ret.results = totalResult.getNativeMetadata();
        ret.parent = totalResult.getRequest();
        ret.sequenceId = totalResult.getSequenceId();
        ret.frameNumber = totalResult.getFrameNumber();
        ret.sessionId = totalResult.getSessionId();
        ret.partials = new ArrayList<ParcelCaptureResult>(totalResult.getPartialResults().size());
        for (CaptureResult partial : totalResult.getPartialResults()) {
            ret.partials.add(CameraAdvancedExtensionSessionImpl.initializeParcelable(partial));
        }
        Map<String, TotalCaptureResult> physicalResults = totalResult.getPhysicalCameraTotalResults();
        ret.physicalResult = new ArrayList<PhysicalCaptureResultInfo>(physicalResults.size());
        for (TotalCaptureResult physicalResult : physicalResults.values()) {
            ret.physicalResult.add(new PhysicalCaptureResultInfo(physicalResult.getCameraId(), physicalResult.getNativeMetadata()));
        }
        return ret;
    }

    private static OutputSurface initializeParcelable(OutputConfiguration o) {
        OutputSurface ret = new OutputSurface();
        if (o != null && o.getSurface() != null) {
            Surface s;
            ret.surface = s = o.getSurface();
            ret.size = new android.hardware.camera2.extension.Size();
            Size surfaceSize = SurfaceUtils.getSurfaceSize(s);
            ret.size.width = surfaceSize.getWidth();
            ret.size.height = surfaceSize.getHeight();
            ret.imageFormat = SurfaceUtils.getSurfaceFormat(s);
            ret.dynamicRangeProfile = o.getDynamicRangeProfile();
            ColorSpace colorSpace = o.getColorSpace();
            ret.colorSpace = colorSpace != null ? colorSpace.getId() : -1;
        } else {
            ret.surface = null;
            ret.size = new android.hardware.camera2.extension.Size();
            ret.size.width = -1;
            ret.size.height = -1;
            ret.imageFormat = 0;
            ret.dynamicRangeProfile = 1L;
            ret.colorSpace = -1;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public CameraDevice getDevice() {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            return this.mCameraDevice;
        }
    }

    @Override
    public CameraExtensionSession.StillCaptureLatency getRealtimeStillCaptureLatency() throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (!this.mInitialized) {
                throw new IllegalStateException("Uninitialized component");
            }
            try {
                LatencyPair latency = this.mSessionProcessor.getRealtimeCaptureLatency();
                if (latency != null) {
                    return new CameraExtensionSession.StillCaptureLatency(latency.first, latency.second);
                }
                return null;
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to query realtime latency! Extension service does not respond");
                throw new CameraAccessException(3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setRepeatingRequest(@NonNull CaptureRequest request, @NonNull Executor executor, @NonNull CameraExtensionSession.ExtensionCaptureCallback listener) throws CameraAccessException {
        int seqId = -1;
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (!this.mInitialized) {
                throw new IllegalStateException("Uninitialized component");
            }
            if (this.mClientRepeatingRequestSurface == null) {
                throw new IllegalArgumentException("No registered preview surface");
            }
            if (!request.containsTarget(this.mClientRepeatingRequestSurface) || request.getTargets().size() != 1) {
                throw new IllegalArgumentException("Invalid repeating request output target!");
            }
            try {
                this.mSessionProcessor.setParameters(request);
                seqId = this.mSessionProcessor.startRepeating(new RequestCallbackHandler(request, executor, listener, this.mCameraDevice.getId()));
            }
            catch (RemoteException e) {
                throw new CameraAccessException(3, "Failed to enable repeating request, extension service failed to respond!");
            }
        }
        return seqId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int capture(@NonNull CaptureRequest request, @NonNull Executor executor, @NonNull CameraExtensionSession.ExtensionCaptureCallback listener) throws CameraAccessException {
        int seqId = -1;
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (!this.mInitialized) {
                throw new IllegalStateException("Uninitialized component");
            }
            this.validateCaptureRequestTargets(request);
            if (this.mClientCaptureSurface != null && request.containsTarget(this.mClientCaptureSurface)) {
                try {
                    boolean isPostviewRequested = request.containsTarget(this.mClientPostviewSurface);
                    this.mSessionProcessor.setParameters(request);
                    seqId = this.mSessionProcessor.startCapture(new RequestCallbackHandler(request, executor, listener, this.mCameraDevice.getId()), isPostviewRequested);
                }
                catch (RemoteException e) {
                    throw new CameraAccessException(3, "Failed  to submit capture request, extension service failed to respond!");
                }
            } else if (this.mClientRepeatingRequestSurface != null && request.containsTarget(this.mClientRepeatingRequestSurface)) {
                try {
                    seqId = this.mSessionProcessor.startTrigger(request, new RequestCallbackHandler(request, executor, listener, this.mCameraDevice.getId()));
                }
                catch (RemoteException e) {
                    throw new CameraAccessException(3, "Failed  to submit trigger request, extension service failed to respond!");
                }
            } else {
                throw new IllegalArgumentException("Invalid single capture output target!");
            }
        }
        return seqId;
    }

    private void validateCaptureRequestTargets(@NonNull CaptureRequest request) {
        if (request.getTargets().size() == 1) {
            boolean containsRepeatingTarget;
            boolean containsCaptureTarget = this.mClientCaptureSurface != null && request.containsTarget(this.mClientCaptureSurface);
            boolean bl = containsRepeatingTarget = this.mClientRepeatingRequestSurface != null && request.containsTarget(this.mClientRepeatingRequestSurface);
            if (!containsCaptureTarget && !containsRepeatingTarget) {
                throw new IllegalArgumentException("Target output combination requested is not supported!");
            }
        }
        if (request.getTargets().size() == 2 && !request.getTargets().containsAll(Arrays.asList(this.mClientCaptureSurface, this.mClientPostviewSurface))) {
            throw new IllegalArgumentException("Target output combination requested is not supported!");
        }
        if (request.getTargets().size() > 2) {
            throw new IllegalArgumentException("Target output combination requested is not supported!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopRepeating() throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (!this.mInitialized) {
                throw new IllegalStateException("Uninitialized component");
            }
            this.mCaptureSession.stopRepeating();
            try {
                this.mSessionProcessor.stopRepeating();
            }
            catch (RemoteException e) {
                throw new CameraAccessException(3, "Failed to notify about the end of repeating request, extension service failed to respond!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (this.mInitialized) {
                try {
                    try {
                        this.mCaptureSession.stopRepeating();
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                    this.mSessionProcessor.stopRepeating();
                    this.mSessionProcessor.onCaptureSessionEnd();
                    this.mSessionClosed = true;
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Failed to stop the repeating request or end the session, , extension service does not respond!");
                }
                this.mStatsAggregator.commit(true);
                this.mCaptureSession.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitStats() {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (this.mInitialized) {
                this.mStatsAggregator.commit(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(boolean skipCloseNotification) {
        boolean notifyClose = false;
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.mHandlerThread.quitSafely();
            if (this.mSessionProcessor != null) {
                try {
                    if (!this.mSessionClosed) {
                        this.mSessionProcessor.onCaptureSessionEnd();
                    }
                    this.mSessionProcessor.deInitSession(this.mToken);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Failed to de-initialize session processor, extension service does not respond!");
                }
                this.mSessionProcessor = null;
            }
            if (this.mToken != null) {
                if (this.mInitialized || this.mCaptureSession != null) {
                    notifyClose = true;
                    CameraExtensionCharacteristics.releaseSession(this.mExtensionType);
                }
                CameraExtensionCharacteristics.unregisterClient(this.mContext, this.mToken, this.mExtensionType);
            }
            this.mInitialized = false;
            this.mToken = null;
            for (ImageReader reader : this.mReaderMap.values()) {
                reader.close();
            }
            this.mReaderMap.clear();
            this.mClientRepeatingRequestSurface = null;
            this.mClientCaptureSurface = null;
            this.mCaptureSession = null;
            this.mRequestProcessor = null;
            this.mCameraDevice = null;
            this.mAdvancedExtender = null;
        }
        if (notifyClose && !skipCloseNotification) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallbacks.onClosed(this));
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyConfigurationFailure() {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (this.mInitialized) {
                return;
            }
        }
        this.release(true);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mExecutor.execute(() -> this.mCallbacks.onConfigureFailed(this));
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private static CaptureRequest initializeCaptureRequest(CameraDevice cameraDevice, Request request, HashMap<Surface, CameraOutputConfig> surfaceIdMap) throws CameraAccessException {
        CaptureRequest.Builder builder = cameraDevice.createCaptureRequest(request.templateId);
        for (OutputConfigId configId : request.targetOutputConfigIds) {
            boolean found = false;
            for (Map.Entry<Surface, CameraOutputConfig> entry : surfaceIdMap.entrySet()) {
                if (entry.getValue().outputId.id != configId.id) continue;
                builder.addTarget(entry.getKey());
                found = true;
                break;
            }
            if (found) continue;
            Log.e(TAG, "Surface with output id: " + configId.id + " not found among registered camera outputs!");
        }
        builder.setTag(request.requestId);
        CaptureRequest ret = builder.build();
        CameraMetadataNative.update(ret.getNativeMetadata(), request.parameters);
        return ret;
    }

    private Surface initializeSurface(CameraOutputConfig output) {
        switch (output.type) {
            case 0: {
                if (output.surface == null) {
                    Log.w(TAG, "Unsupported client output id: " + output.outputId.id + ", skipping!");
                    return null;
                }
                return output.surface;
            }
            case 1: {
                if (output.imageFormat == 0 || output.size.width <= 0 || output.size.height <= 0) {
                    Log.w(TAG, "Unsupported client output id: " + output.outputId.id + ", skipping!");
                    return null;
                }
                ImageReader reader = ImageReader.newInstance(output.size.width, output.size.height, output.imageFormat, output.capacity, output.usage);
                this.mReaderMap.put(output.outputId.id, reader);
                return reader.getSurface();
            }
        }
        throw new IllegalArgumentException("Unsupported output config type: " + output.type);
    }

    private class RequestProcessor
    extends IRequestProcessorImpl.Stub {
        private RequestProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setImageProcessor(OutputConfigId outputConfigId, IImageProcessorImpl imageProcessor) {
            Object object = CameraAdvancedExtensionSessionImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraAdvancedExtensionSessionImpl.this.mReaderMap.containsKey(outputConfigId.id)) {
                    ImageReader reader = CameraAdvancedExtensionSessionImpl.this.mReaderMap.get(outputConfigId.id);
                    String physicalCameraId = null;
                    if (CameraAdvancedExtensionSessionImpl.this.mCameraConfigMap.containsKey(reader.getSurface())) {
                        physicalCameraId = CameraAdvancedExtensionSessionImpl.this.mCameraConfigMap.get((Object)reader.getSurface()).physicalCameraId;
                        reader.setOnImageAvailableListener(new ImageReaderHandler(outputConfigId.id, imageProcessor, physicalCameraId), CameraAdvancedExtensionSessionImpl.this.mHandler);
                    } else {
                        Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Camera output configuration for ImageReader with  config Id " + outputConfigId.id + " not found!");
                    }
                } else {
                    Log.e(CameraAdvancedExtensionSessionImpl.TAG, "ImageReader with output config id: " + outputConfigId.id + " not found!");
                }
            }
        }

        @Override
        public int submit(Request request, IRequestCallback callback) {
            ArrayList<Request> captureList = new ArrayList<Request>();
            captureList.add(request);
            return this.submitBurst(captureList, callback);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int submitBurst(List<Request> requests, IRequestCallback callback) {
            int seqId = -1;
            try {
                Object object = CameraAdvancedExtensionSessionImpl.this.mInterfaceLock;
                synchronized (object) {
                    if (!CameraAdvancedExtensionSessionImpl.this.mInitialized) {
                        return seqId;
                    }
                    CaptureCallbackHandler captureCallback = new CaptureCallbackHandler(callback);
                    ArrayList<CaptureRequest> captureRequests = new ArrayList<CaptureRequest>();
                    for (Request request : requests) {
                        captureRequests.add(CameraAdvancedExtensionSessionImpl.initializeCaptureRequest(CameraAdvancedExtensionSessionImpl.this.mCameraDevice, request, CameraAdvancedExtensionSessionImpl.this.mCameraConfigMap));
                    }
                    seqId = CameraAdvancedExtensionSessionImpl.this.mCaptureSession.captureBurstRequests(captureRequests, new CameraExtensionUtils.HandlerExecutor(CameraAdvancedExtensionSessionImpl.this.mHandler), captureCallback);
                }
            }
            catch (CameraAccessException e) {
                Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Failed to submit capture requests!");
            }
            catch (IllegalStateException e) {
                Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Capture session closed!");
            }
            return seqId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int setRepeating(Request request, IRequestCallback callback) {
            int seqId = -1;
            try {
                Object object = CameraAdvancedExtensionSessionImpl.this.mInterfaceLock;
                synchronized (object) {
                    if (!CameraAdvancedExtensionSessionImpl.this.mInitialized) {
                        return seqId;
                    }
                    CaptureRequest repeatingRequest = CameraAdvancedExtensionSessionImpl.initializeCaptureRequest(CameraAdvancedExtensionSessionImpl.this.mCameraDevice, request, CameraAdvancedExtensionSessionImpl.this.mCameraConfigMap);
                    CaptureCallbackHandler captureCallback = new CaptureCallbackHandler(callback);
                    seqId = CameraAdvancedExtensionSessionImpl.this.mCaptureSession.setSingleRepeatingRequest(repeatingRequest, new CameraExtensionUtils.HandlerExecutor(CameraAdvancedExtensionSessionImpl.this.mHandler), captureCallback);
                }
            }
            catch (CameraAccessException e) {
                Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Failed to enable repeating request!");
            }
            catch (IllegalStateException e) {
                Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Capture session closed!");
            }
            return seqId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void abortCaptures() {
            try {
                Object object = CameraAdvancedExtensionSessionImpl.this.mInterfaceLock;
                synchronized (object) {
                    if (!CameraAdvancedExtensionSessionImpl.this.mInitialized) {
                        return;
                    }
                    CameraAdvancedExtensionSessionImpl.this.mCaptureSession.abortCaptures();
                }
            }
            catch (CameraAccessException e) {
                Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Failed during capture abort!");
            }
            catch (IllegalStateException e) {
                Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Capture session closed!");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stopRepeating() {
            try {
                Object object = CameraAdvancedExtensionSessionImpl.this.mInterfaceLock;
                synchronized (object) {
                    if (!CameraAdvancedExtensionSessionImpl.this.mInitialized) {
                        return;
                    }
                    CameraAdvancedExtensionSessionImpl.this.mCaptureSession.stopRepeating();
                }
            }
            catch (CameraAccessException e) {
                Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Failed during repeating capture stop!");
            }
            catch (IllegalStateException e) {
                Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Capture session closed!");
            }
        }
    }

    private class InitializeSessionHandler
    extends IInitializeSessionCallback.Stub {
        private InitializeSessionHandler() {
        }

        @Override
        public void onSuccess() {
            CameraAdvancedExtensionSessionImpl.this.mHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean status = true;
                    Object object = CameraAdvancedExtensionSessionImpl.this.mInterfaceLock;
                    synchronized (object) {
                        try {
                            if (CameraAdvancedExtensionSessionImpl.this.mSessionProcessor != null) {
                                CameraAdvancedExtensionSessionImpl.this.mInitialized = true;
                                CameraAdvancedExtensionSessionImpl.this.mSessionProcessor.onCaptureSessionStart(CameraAdvancedExtensionSessionImpl.this.mRequestProcessor, CameraAdvancedExtensionSessionImpl.this.mStatsAggregator.getStatsKey());
                            } else {
                                Log.v(CameraAdvancedExtensionSessionImpl.TAG, "Failed to start capture session, session  released before extension start!");
                                status = false;
                            }
                        }
                        catch (RemoteException e) {
                            Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Failed to start capture session, extension service does not respond!");
                            status = false;
                            CameraAdvancedExtensionSessionImpl.this.mInitialized = false;
                        }
                    }
                    if (status) {
                        long ident = Binder.clearCallingIdentity();
                        try {
                            CameraAdvancedExtensionSessionImpl.this.mExecutor.execute(() -> CameraAdvancedExtensionSessionImpl.this.mCallbacks.onConfigured(CameraAdvancedExtensionSessionImpl.this));
                        }
                        finally {
                            Binder.restoreCallingIdentity(ident);
                        }
                    } else {
                        InitializeSessionHandler.this.onFailure();
                    }
                }
            });
        }

        @Override
        public void onFailure() {
            CameraAdvancedExtensionSessionImpl.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    CameraAdvancedExtensionSessionImpl.this.mCaptureSession.close();
                    Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Failed to initialize proxy service session! This can happen when trying to configure multiple concurrent extension sessions!");
                    CameraAdvancedExtensionSessionImpl.this.notifyConfigurationFailure();
                }
            });
        }
    }

    private class SessionStateHandler
    extends CameraCaptureSession.StateCallback {
        private SessionStateHandler() {
        }

        @Override
        public void onClosed(@NonNull CameraCaptureSession session) {
            CameraAdvancedExtensionSessionImpl.this.release(false);
        }

        @Override
        public void onConfigureFailed(@NonNull CameraCaptureSession session) {
            CameraAdvancedExtensionSessionImpl.this.notifyConfigurationFailure();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConfigured(@NonNull CameraCaptureSession session) {
            Object object = CameraAdvancedExtensionSessionImpl.this.mInterfaceLock;
            synchronized (object) {
                CameraAdvancedExtensionSessionImpl.this.mCaptureSession = session;
                CameraAdvancedExtensionSessionImpl.this.mStatsAggregator.commit(false);
            }
            try {
                CameraExtensionCharacteristics.initializeSession(CameraAdvancedExtensionSessionImpl.this.mInitializeHandler, CameraAdvancedExtensionSessionImpl.this.mExtensionType);
            }
            catch (RemoteException e) {
                Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Failed to initialize session! Extension service does not respond!");
                CameraAdvancedExtensionSessionImpl.this.notifyConfigurationFailure();
            }
        }
    }

    private class RequestCallbackHandler
    extends ICaptureCallback.Stub {
        private final CaptureRequest mClientRequest;
        private final Executor mClientExecutor;
        private final CameraExtensionSession.ExtensionCaptureCallback mClientCallbacks;
        private final String mCameraId;

        private RequestCallbackHandler(@NonNull CaptureRequest clientRequest, @NonNull Executor clientExecutor, @NonNull CameraExtensionSession.ExtensionCaptureCallback clientCallbacks, String cameraId) {
            this.mClientRequest = clientRequest;
            this.mClientExecutor = clientExecutor;
            this.mClientCallbacks = clientCallbacks;
            this.mCameraId = cameraId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureStarted(int captureSequenceId, long timestamp) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mClientExecutor.execute(() -> this.mClientCallbacks.onCaptureStarted(CameraAdvancedExtensionSessionImpl.this, this.mClientRequest, timestamp));
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureProcessStarted(int captureSequenceId) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mClientExecutor.execute(() -> this.mClientCallbacks.onCaptureProcessStarted(CameraAdvancedExtensionSessionImpl.this, this.mClientRequest));
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureFailed(int captureSequenceId) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mClientExecutor.execute(() -> this.mClientCallbacks.onCaptureFailed(CameraAdvancedExtensionSessionImpl.this, this.mClientRequest));
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureProcessFailed(int captureSequenceId, int captureFailureReason) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mClientExecutor.execute(() -> this.mClientCallbacks.onCaptureFailed(CameraAdvancedExtensionSessionImpl.this, this.mClientRequest, captureFailureReason));
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureSequenceCompleted(int captureSequenceId) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mClientExecutor.execute(() -> this.mClientCallbacks.onCaptureSequenceCompleted(CameraAdvancedExtensionSessionImpl.this, captureSequenceId));
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureSequenceAborted(int captureSequenceId) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mClientExecutor.execute(() -> this.mClientCallbacks.onCaptureSequenceAborted(CameraAdvancedExtensionSessionImpl.this, captureSequenceId));
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureCompleted(long timestamp, int requestId, CameraMetadataNative result) {
            if (result == null) {
                Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Invalid capture result!");
                return;
            }
            result.set(CaptureResult.SENSOR_TIMESTAMP, Long.valueOf(timestamp));
            TotalCaptureResult totalResult = new TotalCaptureResult(this.mCameraId, result, this.mClientRequest, requestId, timestamp, new ArrayList<CaptureResult>(), CameraAdvancedExtensionSessionImpl.this.mSessionId, new PhysicalCaptureResultInfo[0]);
            long ident = Binder.clearCallingIdentity();
            try {
                CameraAdvancedExtensionSessionImpl.this.mExecutor.execute(() -> this.mClientCallbacks.onCaptureResultAvailable(CameraAdvancedExtensionSessionImpl.this, this.mClientRequest, totalResult));
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureProcessProgressed(int progress) {
            long ident = Binder.clearCallingIdentity();
            try {
                CameraAdvancedExtensionSessionImpl.this.mExecutor.execute(() -> this.mClientCallbacks.onCaptureProcessProgressed(CameraAdvancedExtensionSessionImpl.this, this.mClientRequest, progress));
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    private static class ImageReaderHandler
    implements ImageReader.OnImageAvailableListener {
        private final OutputConfigId mOutputConfigId = new OutputConfigId();
        private final IImageProcessorImpl mIImageProcessor;
        private final String mPhysicalCameraId;

        private ImageReaderHandler(int outputConfigId, IImageProcessorImpl iImageProcessor, String physicalCameraId) {
            this.mOutputConfigId.id = outputConfigId;
            this.mIImageProcessor = iImageProcessor;
            this.mPhysicalCameraId = physicalCameraId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onImageAvailable(ImageReader reader) {
            Image img;
            if (this.mIImageProcessor == null) {
                return;
            }
            try {
                img = reader.acquireNextImage();
            }
            catch (IllegalStateException e) {
                Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Failed to acquire image, too many images pending!");
                return;
            }
            if (img == null) {
                Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Invalid image!");
                return;
            }
            try {
                reader.detachImage(img);
            }
            catch (Exception e) {
                Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Failed to detach image");
                img.close();
                return;
            }
            ParcelImage parcelImage = new ParcelImage();
            parcelImage.buffer = img.getHardwareBuffer();
            try {
                SyncFence fd = img.getFence();
                if (fd.isValid()) {
                    parcelImage.fence = fd.getFdDup();
                }
            }
            catch (IOException e) {
                Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Failed to parcel buffer fence!");
            }
            parcelImage.width = img.getWidth();
            parcelImage.height = img.getHeight();
            parcelImage.format = img.getFormat();
            parcelImage.timestamp = img.getTimestamp();
            parcelImage.transform = img.getTransform();
            parcelImage.scalingMode = img.getScalingMode();
            parcelImage.planeCount = img.getPlaneCount();
            parcelImage.crop = img.getCropRect();
            try {
                this.mIImageProcessor.onNextImageAvailable(this.mOutputConfigId, parcelImage, this.mPhysicalCameraId);
            }
            catch (RemoteException e) {
                Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Failed to propagate image buffer on output surface id: " + this.mOutputConfigId + " extension service does not respond!");
            }
            finally {
                parcelImage.buffer.close();
                img.close();
            }
        }
    }

    private class CaptureCallbackHandler
    extends CameraCaptureSession.CaptureCallback {
        private final IRequestCallback mCallback;

        public CaptureCallbackHandler(IRequestCallback callback) {
            this.mCallback = callback;
        }

        @Override
        public void onCaptureBufferLost(CameraCaptureSession session, CaptureRequest request, Surface target, long frameNumber) {
            try {
                if (request.getTag() instanceof Integer) {
                    Integer requestId = (Integer)request.getTag();
                    this.mCallback.onCaptureBufferLost(requestId, frameNumber, CameraAdvancedExtensionSessionImpl.this.mCameraConfigMap.get((Object)target).outputId.id);
                } else {
                    Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Invalid capture request tag!");
                }
            }
            catch (RemoteException e) {
                Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Failed to notify lost capture buffer, extension service doesn't respond!");
            }
        }

        @Override
        public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
            try {
                if (request.getTag() instanceof Integer) {
                    Integer requestId = (Integer)request.getTag();
                    this.mCallback.onCaptureCompleted(requestId, CameraAdvancedExtensionSessionImpl.initializeParcelable(result));
                } else {
                    Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Invalid capture request tag!");
                }
            }
            catch (RemoteException e) {
                Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Failed to notify capture result, extension service doesn't respond!");
            }
        }

        @Override
        public void onCaptureFailed(CameraCaptureSession session, CaptureRequest request, CaptureFailure failure) {
            try {
                if (request.getTag() instanceof Integer) {
                    Integer requestId = (Integer)request.getTag();
                    android.hardware.camera2.extension.CaptureFailure captureFailure = new android.hardware.camera2.extension.CaptureFailure();
                    captureFailure.request = request;
                    captureFailure.reason = failure.getReason();
                    captureFailure.errorPhysicalCameraId = failure.getPhysicalCameraId();
                    captureFailure.frameNumber = failure.getFrameNumber();
                    captureFailure.sequenceId = failure.getSequenceId();
                    captureFailure.dropped = !failure.wasImageCaptured();
                    this.mCallback.onCaptureFailed(requestId, captureFailure);
                } else {
                    Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Invalid capture request tag!");
                }
            }
            catch (RemoteException e) {
                Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Failed to notify capture failure, extension service doesn't respond!");
            }
        }

        @Override
        public void onCaptureProgressed(CameraCaptureSession session, CaptureRequest request, CaptureResult partialResult) {
            try {
                if (request.getTag() instanceof Integer) {
                    Integer requestId = (Integer)request.getTag();
                    this.mCallback.onCaptureProgressed(requestId, CameraAdvancedExtensionSessionImpl.initializeParcelable(partialResult));
                } else {
                    Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Invalid capture request tag!");
                }
            }
            catch (RemoteException e) {
                Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Failed to notify capture partial result, extension service doesn't respond!");
            }
        }

        @Override
        public void onCaptureSequenceAborted(CameraCaptureSession session, int sequenceId) {
            try {
                this.mCallback.onCaptureSequenceAborted(sequenceId);
            }
            catch (RemoteException e) {
                Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Failed to notify aborted sequence, extension service doesn't respond!");
            }
        }

        @Override
        public void onCaptureSequenceCompleted(CameraCaptureSession session, int sequenceId, long frameNumber) {
            try {
                this.mCallback.onCaptureSequenceCompleted(sequenceId, frameNumber);
            }
            catch (RemoteException e) {
                Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Failed to notify sequence complete, extension service doesn't respond!");
            }
        }

        @Override
        public void onCaptureStarted(CameraCaptureSession session, CaptureRequest request, long timestamp, long frameNumber) {
            try {
                if (request.getTag() instanceof Integer) {
                    Integer requestId = (Integer)request.getTag();
                    this.mCallback.onCaptureStarted(requestId, frameNumber, timestamp);
                } else {
                    Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Invalid capture request tag!");
                }
            }
            catch (RemoteException e) {
                Log.e(CameraAdvancedExtensionSessionImpl.TAG, "Failed to notify capture started, extension service doesn't respond!");
            }
        }
    }
}

