/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.contexthub;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.content.Context;
import android.hardware.contexthub.HubEndpointInfo;
import android.hardware.contexthub.HubEndpointLifecycleCallback;
import android.hardware.contexthub.HubEndpointMessageCallback;
import android.hardware.contexthub.HubEndpointSession;
import android.hardware.contexthub.HubEndpointSessionResult;
import android.hardware.contexthub.HubMessage;
import android.hardware.contexthub.HubServiceInfo;
import android.hardware.contexthub.IContextHubEndpoint;
import android.hardware.contexthub.IContextHubEndpointCallback;
import android.hardware.location.IContextHubService;
import android.hardware.location.IContextHubTransactionCallback;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import com.android.layoutlib.androidx.annotation.GuardedBy;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;

@SystemApi
@FlaggedApi(value="android.chre.flags.offload_api")
public class HubEndpoint {
    private static final String TAG = "HubEndpoint";
    public static final int REASON_FAILURE = 0;
    public static final int REASON_OPEN_ENDPOINT_SESSION_REQUEST_REJECTED = 3;
    public static final int REASON_CLOSE_ENDPOINT_SESSION_REQUESTED = 4;
    public static final int REASON_ENDPOINT_INVALID = 5;
    public static final int REASON_PERMISSION_DENIED = 9;
    public static final int REASON_ENDPOINT_STOPPED = 6;
    private final Object mLock = new Object();
    private final HubEndpointInfo mPendingHubEndpointInfo;
    @Nullable
    private final HubEndpointLifecycleCallback mLifecycleCallback;
    @Nullable
    private final HubEndpointMessageCallback mMessageCallback;
    @NonNull
    private final Executor mLifecycleCallbackExecutor;
    @NonNull
    private final Executor mMessageCallbackExecutor;
    @GuardedBy(value="mLock")
    private final SparseArray<HubEndpointSession> mActiveSessions = new SparseArray();
    private final IContextHubEndpointCallback mServiceCallback = new IContextHubEndpointCallback.Stub(){

        @Override
        public void onSessionOpenRequest(int sessionId, HubEndpointInfo initiator, @Nullable String serviceDescriptor) throws RemoteException {
            boolean sessionExists;
            boolean bl = sessionExists = this.getActiveSession(sessionId) != null;
            if (sessionExists) {
                Log.w(HubEndpoint.TAG, "onSessionOpenRequest: session already exists, id=" + sessionId);
            }
            if (HubEndpoint.this.mLifecycleCallback == null) {
                Log.w(HubEndpoint.TAG, "onSessionOpenRequest: failed to open session, no lifecycle callback attached", new Exception());
                this.rejectSession(sessionId);
            }
            if (!sessionExists && HubEndpoint.this.mLifecycleCallback != null) {
                HubEndpoint.this.mLifecycleCallbackExecutor.execute(() -> this.processSessionOpenRequestResult(sessionId, initiator, serviceDescriptor, HubEndpoint.this.mLifecycleCallback.onSessionOpenRequest(initiator, serviceDescriptor)));
            } else {
                this.invokeCallbackFinished();
            }
        }

        @Override
        public void onSessionOpenComplete(int sessionId) throws RemoteException {
            HubEndpointSession activeSession = this.getActiveSession(sessionId);
            if (activeSession == null) {
                Log.w(HubEndpoint.TAG, "onSessionOpenComplete: no pending session open request? id=" + sessionId);
            } else {
                activeSession.setOpened();
            }
            if (activeSession != null && HubEndpoint.this.mLifecycleCallback != null) {
                HubEndpoint.this.mLifecycleCallbackExecutor.execute(() -> {
                    HubEndpoint.this.mLifecycleCallback.onSessionOpened(activeSession);
                    this.invokeCallbackFinished();
                });
            } else {
                this.invokeCallbackFinished();
            }
        }

        @Override
        public void onSessionClosed(int sessionId, int reason) throws RemoteException {
            HubEndpointSession activeSession = this.getActiveSession(sessionId);
            if (activeSession == null) {
                Log.w(HubEndpoint.TAG, "onSessionClosed: session not active, id=" + sessionId);
            }
            if (activeSession != null && HubEndpoint.this.mLifecycleCallback != null) {
                HubEndpoint.this.mLifecycleCallbackExecutor.execute(() -> {
                    HubEndpoint.this.mLifecycleCallback.onSessionClosed(activeSession, reason);
                    activeSession.setClosed();
                    Object object = HubEndpoint.this.mLock;
                    synchronized (object) {
                        HubEndpoint.this.mActiveSessions.remove(sessionId);
                    }
                    this.invokeCallbackFinished();
                });
            } else {
                this.invokeCallbackFinished();
            }
        }

        @Override
        public void onMessageReceived(int sessionId, HubMessage message) throws RemoteException {
            HubEndpointSession activeSession = this.getActiveSession(sessionId);
            if (activeSession == null) {
                Log.w(HubEndpoint.TAG, "onMessageReceived: session not active, id=" + sessionId);
            }
            if (activeSession == null || HubEndpoint.this.mMessageCallback == null) {
                this.sendMessageDeliveryStatus(sessionId, message, (byte)4);
            } else {
                HubEndpoint.this.mMessageCallbackExecutor.execute(() -> {
                    HubEndpoint.this.mMessageCallback.onMessageReceived(activeSession, message);
                    this.sendMessageDeliveryStatus(sessionId, message, (byte)0);
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HubEndpointSession getActiveSession(int sessionId) {
            Object object = HubEndpoint.this.mLock;
            synchronized (object) {
                return HubEndpoint.this.mActiveSessions.get(sessionId);
            }
        }

        private void sendMessageDeliveryStatus(int sessionId, HubMessage message, byte errorCode) {
            if (message.isResponseRequired()) {
                this.invokeCallback(callback -> callback.sendMessageDeliveryStatus(sessionId, message.getMessageSequenceNumber(), errorCode));
            }
            this.invokeCallbackFinished();
        }

        private void processSessionOpenRequestResult(int sessionId, HubEndpointInfo initiator, @Nullable String serviceDescriptor, HubEndpointSessionResult result) {
            if (result == null) {
                throw new IllegalArgumentException("HubEndpointSessionResult shouldn't be null.");
            }
            if (result.isAccepted()) {
                this.acceptSession(sessionId, initiator, serviceDescriptor);
            } else {
                Log.e(HubEndpoint.TAG, "Session " + sessionId + " from " + initiator + " was rejected, reason=" + result.getReason());
                this.rejectSession(sessionId);
            }
            this.invokeCallbackFinished();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void acceptSession(int sessionId, HubEndpointInfo initiator, @Nullable String serviceDescriptor) {
            HubEndpointSession activeSession;
            Object object = HubEndpoint.this.mLock;
            synchronized (object) {
                activeSession = HubEndpoint.this.mActiveSessions.get(sessionId);
                if (activeSession != null) {
                    Log.e(HubEndpoint.TAG, "onSessionOpenRequestResult: session already exists, id=" + sessionId);
                    return;
                }
                activeSession = new HubEndpointSession(sessionId, HubEndpoint.this, HubEndpoint.this.mAssignedHubEndpointInfo, initiator, serviceDescriptor);
                this.invokeCallback(callback -> callback.openSessionRequestComplete(sessionId));
                HubEndpoint.this.mActiveSessions.put(sessionId, activeSession);
            }
            activeSession.setOpened();
            if (HubEndpoint.this.mLifecycleCallback != null) {
                HubEndpointSession finalActiveSession = activeSession;
                HubEndpoint.this.mLifecycleCallbackExecutor.execute(() -> HubEndpoint.this.mLifecycleCallback.onSessionOpened(finalActiveSession));
            }
        }

        private void rejectSession(int sessionId) {
            this.invokeCallback(callback -> callback.closeSession(sessionId, 3));
        }

        private void invokeCallbackFinished() {
            this.invokeCallback(callback -> callback.onCallbackFinished());
        }

        private void invokeCallback(EndpointConsumer consumer) {
            try {
                consumer.accept(HubEndpoint.this.mServiceToken);
            }
            catch (IllegalStateException e) {
                Log.w(HubEndpoint.TAG, "IllegalStateException while calling callback", e);
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
    };
    @Nullable
    private IContextHubEndpoint mServiceToken;
    @Nullable
    private HubEndpointInfo mAssignedHubEndpointInfo;

    private HubEndpoint(@NonNull HubEndpointInfo pendingEndpointInfo, @Nullable HubEndpointLifecycleCallback endpointLifecycleCallback, @NonNull Executor lifecycleCallbackExecutor, @Nullable HubEndpointMessageCallback endpointMessageCallback, @NonNull Executor messageCallbackExecutor) {
        this.mPendingHubEndpointInfo = pendingEndpointInfo;
        this.mLifecycleCallback = endpointLifecycleCallback;
        this.mLifecycleCallbackExecutor = lifecycleCallbackExecutor;
        this.mMessageCallback = endpointMessageCallback;
        this.mMessageCallbackExecutor = messageCallbackExecutor;
    }

    public void register(IContextHubService service) {
        try {
            IContextHubEndpoint serviceToken = service.registerEndpoint(this.mPendingHubEndpointInfo, this.mServiceCallback, this.mPendingHubEndpointInfo.getName(), this.mPendingHubEndpointInfo.getTag());
            this.mAssignedHubEndpointInfo = serviceToken.getAssignedHubEndpointInfo();
            this.mServiceToken = serviceToken;
        }
        catch (RemoteException e) {
            Log.e(TAG, "registerEndpoint: failed to register endpoint", e);
            e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        try {
            Object object = this.mLock;
            synchronized (object) {
                for (int i = 0; i < this.mActiveSessions.size(); ++i) {
                    this.mActiveSessions.get(this.mActiveSessions.keyAt(i)).setClosed();
                }
                this.mActiveSessions.clear();
            }
            this.mServiceToken.unregister();
        }
        catch (RemoteException e) {
            Log.e(TAG, "unregisterEndpoint: failed to unregister endpoint", e);
            e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openSession(HubEndpointInfo destinationInfo, @Nullable String serviceDescriptor) {
        try {
            Object object = this.mLock;
            synchronized (object) {
                int sessionId = this.mServiceToken.openSession(destinationInfo, serviceDescriptor);
                HubEndpointSession newSession = new HubEndpointSession(sessionId, this, destinationInfo, this.mAssignedHubEndpointInfo, serviceDescriptor);
                this.mActiveSessions.put(sessionId, newSession);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "openSession: failed to open session to " + destinationInfo, e);
            e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession(HubEndpointSession session) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mActiveSessions.contains(session.getId())) {
                return;
            }
            session.setClosed();
            this.mActiveSessions.remove(session.getId());
        }
        try {
            this.mServiceToken.closeSession(session.getId(), 4);
        }
        catch (RemoteException e) {
            Log.e(TAG, "closeSession: failed to close session " + session, e);
            e.rethrowFromSystemServer();
        }
    }

    void sendMessage(HubEndpointSession session, HubMessage message, @Nullable IContextHubTransactionCallback transactionCallback) {
        try {
            this.mServiceToken.sendMessage(session.getId(), message, transactionCallback);
        }
        catch (RemoteException e) {
            Log.e(TAG, "sendMessage: failed to send message session=" + session, e);
            e.rethrowFromSystemServer();
        }
    }

    public int getVersion() {
        return this.mPendingHubEndpointInfo.getVersion();
    }

    @Nullable
    public String getTag() {
        return this.mPendingHubEndpointInfo.getTag();
    }

    @NonNull
    public Collection<HubServiceInfo> getServiceInfoCollection() {
        return this.mPendingHubEndpointInfo.getServiceInfoCollection();
    }

    @Nullable
    public HubEndpointLifecycleCallback getLifecycleCallback() {
        return this.mLifecycleCallback;
    }

    @Nullable
    public HubEndpointMessageCallback getMessageCallback() {
        return this.mMessageCallback;
    }

    public static class Builder {
        private final String mPackageName;
        @Nullable
        private HubEndpointLifecycleCallback mLifecycleCallback;
        @Nullable
        private Executor mLifecycleCallbackExecutor;
        @Nullable
        private HubEndpointMessageCallback mMessageCallback;
        @Nullable
        private Executor mMessageCallbackExecutor;
        @NonNull
        private final Executor mMainExecutor;
        private int mVersion;
        @Nullable
        private String mTag;
        private List<HubServiceInfo> mServiceInfos = Collections.emptyList();

        public Builder(@NonNull Context context) {
            this.mPackageName = context.getPackageName();
            this.mTag = context.getAttributionTag();
            this.mVersion = (int)context.getApplicationInfo().longVersionCode;
            this.mMainExecutor = context.getMainExecutor();
        }

        @NonNull
        public Builder setVersion(int version) {
            this.mVersion = version;
            return this;
        }

        @NonNull
        public Builder setTag(@NonNull String tag) {
            this.mTag = tag;
            return this;
        }

        @NonNull
        public Builder setLifecycleCallback(@NonNull HubEndpointLifecycleCallback lifecycleCallback) {
            this.mLifecycleCallbackExecutor = null;
            this.mLifecycleCallback = lifecycleCallback;
            return this;
        }

        @NonNull
        public Builder setLifecycleCallback(@NonNull Executor executor, @NonNull HubEndpointLifecycleCallback lifecycleCallback) {
            this.mLifecycleCallbackExecutor = executor;
            this.mLifecycleCallback = lifecycleCallback;
            return this;
        }

        @NonNull
        public Builder setMessageCallback(@NonNull HubEndpointMessageCallback messageCallback) {
            this.mMessageCallbackExecutor = null;
            this.mMessageCallback = messageCallback;
            return this;
        }

        @NonNull
        public Builder setMessageCallback(@NonNull Executor executor, @NonNull HubEndpointMessageCallback messageCallback) {
            this.mMessageCallbackExecutor = executor;
            this.mMessageCallback = messageCallback;
            return this;
        }

        @NonNull
        public Builder setServiceInfoCollection(@NonNull Collection<HubServiceInfo> hubServiceInfos) {
            this.mServiceInfos = new ArrayList<HubServiceInfo>(hubServiceInfos);
            return this;
        }

        @NonNull
        public HubEndpoint build() {
            return new HubEndpoint(new HubEndpointInfo(this.mPackageName, this.mVersion, this.mTag, this.mServiceInfos), this.mLifecycleCallback, this.mLifecycleCallbackExecutor != null ? this.mLifecycleCallbackExecutor : this.mMainExecutor, this.mMessageCallback, this.mMessageCallbackExecutor != null ? this.mMessageCallbackExecutor : this.mMainExecutor);
        }
    }

    static interface EndpointConsumer {
        public void accept(IContextHubEndpoint var1) throws RemoteException;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Reason {
    }
}

