/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.contexthub;

import android.hardware.contexthub.HubEndpointInfo;
import android.hardware.contexthub.HubMessage;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IContextHubEndpointCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.contexthub.IContextHubEndpointCallback";

    public void onSessionOpenRequest(int var1, HubEndpointInfo var2, String var3) throws RemoteException;

    public void onSessionClosed(int var1, int var2) throws RemoteException;

    public void onSessionOpenComplete(int var1) throws RemoteException;

    public void onMessageReceived(int var1, HubMessage var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IContextHubEndpointCallback {
        static final int TRANSACTION_onSessionOpenRequest = 1;
        static final int TRANSACTION_onSessionClosed = 2;
        static final int TRANSACTION_onSessionOpenComplete = 3;
        static final int TRANSACTION_onMessageReceived = 4;

        public Stub() {
            this.attachInterface(this, IContextHubEndpointCallback.DESCRIPTOR);
        }

        public static IContextHubEndpointCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IContextHubEndpointCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IContextHubEndpointCallback) {
                return (IContextHubEndpointCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onSessionOpenRequest";
                }
                case 2: {
                    return "onSessionClosed";
                }
                case 3: {
                    return "onSessionOpenComplete";
                }
                case 4: {
                    return "onMessageReceived";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IContextHubEndpointCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    HubEndpointInfo _arg1 = data.readTypedObject(HubEndpointInfo.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.onSessionOpenRequest(_arg0, _arg1, _arg2);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSessionClosed(_arg0, _arg1);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSessionOpenComplete(_arg0);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    HubMessage _arg1 = data.readTypedObject(HubMessage.CREATOR);
                    data.enforceNoDataAvail();
                    this.onMessageReceived(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements IContextHubEndpointCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IContextHubEndpointCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionOpenRequest(int sessionId, HubEndpointInfo initiator, String serviceDescriptor) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContextHubEndpointCallback.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeTypedObject(initiator, 0);
                    _data.writeString(serviceDescriptor);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionClosed(int sessionId, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContextHubEndpointCallback.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionOpenComplete(int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContextHubEndpointCallback.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMessageReceived(int sessionId, HubMessage message) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContextHubEndpointCallback.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeTypedObject(message, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IContextHubEndpointCallback {
        @Override
        public void onSessionOpenRequest(int sessionId, HubEndpointInfo initiator, String serviceDescriptor) throws RemoteException {
        }

        @Override
        public void onSessionClosed(int sessionId, int reason) throws RemoteException {
        }

        @Override
        public void onSessionOpenComplete(int sessionId) throws RemoteException {
        }

        @Override
        public void onMessageReceived(int sessionId, HubMessage message) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

