/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.devicestate;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.hardware.devicestate.DeviceState;
import android.hardware.devicestate.DeviceStateInfo;
import android.hardware.devicestate.DeviceStateManager;
import android.hardware.devicestate.DeviceStateRequest;
import android.hardware.devicestate.IDeviceStateManager;
import android.hardware.devicestate.IDeviceStateManagerCallback;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.Trace;
import android.os._Original_Build;
import android.util.ArrayMap;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class DeviceStateManagerGlobal {
    @Nullable
    @GuardedBy(value={"DeviceStateManagerGlobal.class"})
    private static DeviceStateManagerGlobal sInstance;
    private static final String TAG = "DeviceStateManagerGlobal";
    private static final boolean DEBUG;
    private final Object mLock = new Object();
    @NonNull
    private final IDeviceStateManager mDeviceStateManager;
    @Nullable
    private DeviceStateManagerCallback mCallback;
    @GuardedBy(value={"mLock"})
    private final ArrayList<DeviceStateCallbackWrapper> mCallbacks = new ArrayList();
    @GuardedBy(value={"mLock"})
    private final ArrayMap<IBinder, DeviceStateRequestWrapper> mRequests = new ArrayMap();
    @Nullable
    @GuardedBy(value={"mLock"})
    private DeviceStateInfo mLastReceivedInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static DeviceStateManagerGlobal getInstance() {
        Class<DeviceStateManagerGlobal> clazz = DeviceStateManagerGlobal.class;
        synchronized (DeviceStateManagerGlobal.class) {
            IBinder b;
            if (sInstance == null && (b = ServiceManager.getService("device_state")) != null) {
                sInstance = new DeviceStateManagerGlobal(IDeviceStateManager.Stub.asInterface(b));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    @VisibleForTesting
    public DeviceStateManagerGlobal(@NonNull IDeviceStateManager deviceStateManager) {
        this.mDeviceStateManager = deviceStateManager;
        this.registerCallbackLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<DeviceState> getSupportedDeviceStates() {
        Object object = this.mLock;
        synchronized (object) {
            DeviceStateInfo currentInfo;
            if (this.mLastReceivedInfo != null) {
                currentInfo = this.mLastReceivedInfo;
            } else {
                try {
                    currentInfo = this.mDeviceStateManager.getDeviceStateInfo();
                }
                catch (RemoteException ex) {
                    throw ex.rethrowFromSystemServer();
                }
            }
            return List.copyOf(currentInfo.supportedStates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.CONTROL_DEVICE_STATE", conditional=true)
    public void requestState(@NonNull DeviceStateRequest request, @Nullable Executor executor, @Nullable DeviceStateRequest.Callback callback) {
        DeviceStateRequestWrapper requestWrapper = new DeviceStateRequestWrapper(request, callback, executor);
        Object object = this.mLock;
        synchronized (object) {
            if (this.findRequestTokenLocked(request) != null) {
                return;
            }
            Binder token = new Binder();
            this.mRequests.put(token, requestWrapper);
            try {
                this.mDeviceStateManager.requestState(token, request.getState(), request.getFlags());
            }
            catch (RemoteException ex) {
                this.mRequests.remove(token);
                throw ex.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.CONTROL_DEVICE_STATE", conditional=true)
    public void cancelStateRequest() {
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mDeviceStateManager.cancelStateRequest();
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.CONTROL_DEVICE_STATE")
    public void requestBaseStateOverride(@NonNull DeviceStateRequest request, @Nullable Executor executor, @Nullable DeviceStateRequest.Callback callback) {
        DeviceStateRequestWrapper requestWrapper = new DeviceStateRequestWrapper(request, callback, executor);
        Object object = this.mLock;
        synchronized (object) {
            if (this.findRequestTokenLocked(request) != null) {
                return;
            }
            Binder token = new Binder();
            this.mRequests.put(token, requestWrapper);
            try {
                this.mDeviceStateManager.requestBaseStateOverride(token, request.getState(), request.getFlags());
            }
            catch (RemoteException ex) {
                this.mRequests.remove(token);
                throw ex.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.CONTROL_DEVICE_STATE")
    public void cancelBaseStateOverride() {
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mDeviceStateManager.cancelBaseStateOverride();
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void registerDeviceStateCallback(@NonNull DeviceStateManager.DeviceStateCallback callback, @NonNull Executor executor) {
        Object object = this.mLock;
        synchronized (object) {
            int index = this.findCallbackLocked(callback);
            if (index != -1) {
                return;
            }
            DeviceStateCallbackWrapper wrapper = new DeviceStateCallbackWrapper(callback, executor);
            this.mCallbacks.add(wrapper);
            if (this.mLastReceivedInfo != null) {
                wrapper.notifySupportedDeviceStatesChanged(List.copyOf(this.mLastReceivedInfo.supportedStates));
                wrapper.notifyDeviceStateChanged(this.mLastReceivedInfo.currentState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void unregisterDeviceStateCallback(@NonNull DeviceStateManager.DeviceStateCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            int indexToRemove = this.findCallbackLocked(callback);
            if (indexToRemove != -1) {
                this.mCallbacks.remove(indexToRemove);
            }
        }
    }

    public void onStateRequestOverlayDismissed(boolean shouldCancelRequest) {
        try {
            this.mDeviceStateManager.onStateRequestOverlayDismissed(shouldCancelRequest);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"DeviceStateManagerGlobal.class"})
    private void registerCallbackLocked() {
        block6: {
            this.mCallback = new DeviceStateManagerCallback();
            try {
                if (Flags.wlinfoOncreate()) {
                    Object object = this.mLock;
                    synchronized (object) {
                        this.mLastReceivedInfo = this.mDeviceStateManager.registerCallback(this.mCallback);
                        break block6;
                    }
                }
                this.mDeviceStateManager.registerCallback(this.mCallback);
            }
            catch (RemoteException ex) {
                this.mCallback = null;
                throw ex.rethrowFromSystemServer();
            }
        }
    }

    private int findCallbackLocked(DeviceStateManager.DeviceStateCallback callback) {
        for (int i = 0; i < this.mCallbacks.size(); ++i) {
            if (!this.mCallbacks.get((int)i).mDeviceStateCallback.equals(callback)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    @GuardedBy(value={"mLock"})
    private IBinder findRequestTokenLocked(@NonNull DeviceStateRequest request) {
        for (int i = 0; i < this.mRequests.size(); ++i) {
            if (!this.mRequests.valueAt((int)i).mRequest.equals(request)) continue;
            return this.mRequests.keyAt(i);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDeviceStateInfoChanged(@NonNull DeviceStateInfo info) {
        int i;
        int diff;
        ArrayList<DeviceStateCallbackWrapper> callbacks;
        DeviceStateInfo oldInfo;
        Object object = this.mLock;
        synchronized (object) {
            oldInfo = this.mLastReceivedInfo;
            this.mLastReceivedInfo = info;
            callbacks = new ArrayList<DeviceStateCallbackWrapper>(this.mCallbacks);
        }
        int n = diff = oldInfo == null ? -1 : info.diff(oldInfo);
        if ((diff & 1) > 0) {
            for (i = 0; i < callbacks.size(); ++i) {
                callbacks.get(i).notifySupportedDeviceStatesChanged(List.copyOf(info.supportedStates));
            }
        }
        if ((diff & 4) > 0) {
            for (i = 0; i < callbacks.size(); ++i) {
                callbacks.get(i).notifyDeviceStateChanged(info.currentState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequestActive(@NonNull IBinder token) {
        DeviceStateRequestWrapper request;
        Object object = this.mLock;
        synchronized (object) {
            request = this.mRequests.get(token);
        }
        if (request != null) {
            request.notifyRequestActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequestCanceled(@NonNull IBinder token) {
        DeviceStateRequestWrapper request;
        Object object = this.mLock;
        synchronized (object) {
            request = this.mRequests.remove(token);
        }
        if (request != null) {
            request.notifyRequestCanceled();
        }
    }

    static {
        DEBUG = _Original_Build.IS_DEBUGGABLE;
    }

    private static class DeviceStateRequestWrapper {
        @NonNull
        private final DeviceStateRequest mRequest;
        @Nullable
        private final DeviceStateRequest.Callback mCallback;
        @Nullable
        private final Executor mExecutor;

        DeviceStateRequestWrapper(@NonNull DeviceStateRequest request, @Nullable DeviceStateRequest.Callback callback, @Nullable Executor executor) {
            this.validateRequestWrapperParameters(callback, executor);
            this.mRequest = request;
            this.mCallback = callback;
            this.mExecutor = executor;
        }

        void notifyRequestActive() {
            if (this.mCallback == null) {
                return;
            }
            this.mExecutor.execute(() -> this.mCallback.onRequestActivated(this.mRequest));
        }

        void notifyRequestCanceled() {
            if (this.mCallback == null) {
                return;
            }
            this.mExecutor.execute(() -> this.mCallback.onRequestCanceled(this.mRequest));
        }

        private void validateRequestWrapperParameters(@Nullable DeviceStateRequest.Callback callback, @Nullable Executor executor) {
            if (callback == null && executor != null) {
                throw new IllegalArgumentException("Callback must be supplied with executor.");
            }
            if (executor == null && callback != null) {
                throw new IllegalArgumentException("Executor must be supplied with callback.");
            }
        }
    }

    private static class DeviceStateCallbackWrapper {
        @NonNull
        private final DeviceStateManager.DeviceStateCallback mDeviceStateCallback;
        @NonNull
        private final Executor mExecutor;

        DeviceStateCallbackWrapper(@NonNull DeviceStateManager.DeviceStateCallback callback, @NonNull Executor executor) {
            this.mDeviceStateCallback = callback;
            this.mExecutor = executor;
        }

        void notifySupportedDeviceStatesChanged(@NonNull List<DeviceState> newSupportedDeviceStates) {
            this.mExecutor.execute(() -> this.mDeviceStateCallback.onSupportedStatesChanged(newSupportedDeviceStates));
        }

        void notifyDeviceStateChanged(DeviceState newDeviceState) {
            this.execute("notifyDeviceStateChanged", () -> this.mDeviceStateCallback.onDeviceStateChanged(newDeviceState));
        }

        private void execute(@NonNull String traceName, @NonNull Runnable r) {
            this.mExecutor.execute(() -> {
                if (DEBUG) {
                    Trace.beginSection(this.mDeviceStateCallback.getClass().getSimpleName() + "#" + traceName);
                }
                try {
                    r.run();
                }
                finally {
                    if (DEBUG) {
                        Trace.endSection();
                    }
                }
            });
        }
    }

    private class DeviceStateManagerCallback
    extends IDeviceStateManagerCallback.Stub {
        private DeviceStateManagerCallback() {
        }

        @Override
        public void onDeviceStateInfoChanged(@NonNull DeviceStateInfo info) {
            DeviceStateManagerGlobal.this.handleDeviceStateInfoChanged(info);
        }

        @Override
        public void onRequestActive(@NonNull IBinder token) {
            DeviceStateManagerGlobal.this.handleRequestActive(token);
        }

        @Override
        public void onRequestCanceled(@NonNull IBinder token) {
            DeviceStateManagerGlobal.this.handleRequestCanceled(token);
        }
    }
}

