/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.hardware.display.IBrightnessListener;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import android.view.DisplayCutout;
import android.view.Surface;
import com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;

public class VirtualDisplayConfig
implements Parcelable {
    private final String mName;
    private final int mWidth;
    private final int mHeight;
    private final int mDensityDpi;
    private final int mFlags;
    private final Surface mSurface;
    private final String mUniqueId;
    private final int mDisplayIdToMirror;
    private final boolean mWindowManagerMirroringEnabled;
    private final ArraySet<String> mDisplayCategories;
    private final float mRequestedRefreshRate;
    private final boolean mIsHomeSupported;
    private final DisplayCutout mDisplayCutout;
    private final boolean mIgnoreActivitySizeRestrictions;
    private final float mDefaultBrightness;
    private final float mDimBrightness;
    private final IBrightnessListener mBrightnessListener;
    @NonNull
    public static final Parcelable.Creator<VirtualDisplayConfig> CREATOR = new Parcelable.Creator<VirtualDisplayConfig>(){

        public VirtualDisplayConfig[] newArray(int size) {
            return new VirtualDisplayConfig[size];
        }

        @Override
        public VirtualDisplayConfig createFromParcel(@NonNull Parcel in) {
            return new VirtualDisplayConfig(in);
        }
    };

    private VirtualDisplayConfig(@NonNull String name, int width, int height, int densityDpi, int flags, @Nullable Surface surface, @Nullable String uniqueId, int displayIdToMirror, boolean windowManagerMirroringEnabled, @NonNull ArraySet<String> displayCategories, float requestedRefreshRate, boolean isHomeSupported, @Nullable DisplayCutout displayCutout, boolean ignoreActivitySizeRestrictions, float defaultBrightness, float dimBrightness, IBrightnessListener brightnessListener) {
        this.mName = name;
        this.mWidth = width;
        this.mHeight = height;
        this.mDensityDpi = densityDpi;
        this.mFlags = flags;
        this.mSurface = surface;
        this.mUniqueId = uniqueId;
        this.mDisplayIdToMirror = displayIdToMirror;
        this.mWindowManagerMirroringEnabled = windowManagerMirroringEnabled;
        this.mDisplayCategories = displayCategories;
        this.mRequestedRefreshRate = requestedRefreshRate;
        this.mIsHomeSupported = isHomeSupported;
        this.mDisplayCutout = displayCutout;
        this.mIgnoreActivitySizeRestrictions = ignoreActivitySizeRestrictions;
        this.mDefaultBrightness = defaultBrightness;
        this.mDimBrightness = dimBrightness;
        this.mBrightnessListener = brightnessListener;
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getDensityDpi() {
        return this.mDensityDpi;
    }

    public int getFlags() {
        return this.mFlags;
    }

    @Nullable
    public Surface getSurface() {
        return this.mSurface;
    }

    @SystemApi
    @FlaggedApi(value="android.companion.virtualdevice.flags.virtual_display_insets")
    @Nullable
    public DisplayCutout getDisplayCutout() {
        return this.mDisplayCutout;
    }

    @FlaggedApi(value="android.companion.virtualdevice.flags.device_aware_display_power")
    public float getDefaultBrightness() {
        return this.mDefaultBrightness;
    }

    @FlaggedApi(value="android.companion.virtualdevice.flags.device_aware_display_power")
    public float getDimBrightness() {
        return this.mDimBrightness;
    }

    @Nullable
    public IBrightnessListener getBrightnessListener() {
        return this.mBrightnessListener;
    }

    @Nullable
    public String getUniqueId() {
        return this.mUniqueId;
    }

    public int getDisplayIdToMirror() {
        return this.mDisplayIdToMirror;
    }

    public boolean isWindowManagerMirroringEnabled() {
        return this.mWindowManagerMirroringEnabled;
    }

    @SystemApi
    public boolean isHomeSupported() {
        return this.mIsHomeSupported;
    }

    @SystemApi
    @FlaggedApi(value="com.android.window.flags.vdm_force_app_universal_resizable_api")
    public boolean isIgnoreActivitySizeRestrictions() {
        return this.mIgnoreActivitySizeRestrictions && Flags.vdmForceAppUniversalResizableApi();
    }

    @NonNull
    public Set<String> getDisplayCategories() {
        return Collections.unmodifiableSet(this.mDisplayCategories);
    }

    public float getRequestedRefreshRate() {
        return this.mRequestedRefreshRate;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString8(this.mName);
        dest.writeInt(this.mWidth);
        dest.writeInt(this.mHeight);
        dest.writeInt(this.mDensityDpi);
        dest.writeInt(this.mFlags);
        dest.writeTypedObject(this.mSurface, flags);
        dest.writeString8(this.mUniqueId);
        dest.writeInt(this.mDisplayIdToMirror);
        dest.writeBoolean(this.mWindowManagerMirroringEnabled);
        dest.writeArraySet(this.mDisplayCategories);
        dest.writeFloat(this.mRequestedRefreshRate);
        dest.writeBoolean(this.mIsHomeSupported);
        DisplayCutout.ParcelableWrapper.writeCutoutToParcel(this.mDisplayCutout, dest, flags);
        dest.writeBoolean(this.mIgnoreActivitySizeRestrictions);
        dest.writeFloat(this.mDefaultBrightness);
        dest.writeFloat(this.mDimBrightness);
        dest.writeStrongBinder(this.mBrightnessListener != null ? this.mBrightnessListener.asBinder() : null);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VirtualDisplayConfig)) {
            return false;
        }
        VirtualDisplayConfig that = (VirtualDisplayConfig)o;
        return Objects.equals(this.mName, that.mName) && this.mWidth == that.mWidth && this.mHeight == that.mHeight && this.mDensityDpi == that.mDensityDpi && this.mFlags == that.mFlags && Objects.equals(this.mSurface, that.mSurface) && Objects.equals(this.mUniqueId, that.mUniqueId) && this.mDisplayIdToMirror == that.mDisplayIdToMirror && this.mWindowManagerMirroringEnabled == that.mWindowManagerMirroringEnabled && Objects.equals(this.mDisplayCategories, that.mDisplayCategories) && this.mRequestedRefreshRate == that.mRequestedRefreshRate && this.mIsHomeSupported == that.mIsHomeSupported && this.mIgnoreActivitySizeRestrictions == that.mIgnoreActivitySizeRestrictions && Objects.equals(this.mDisplayCutout, that.mDisplayCutout) && this.mDefaultBrightness == that.mDefaultBrightness && this.mDimBrightness == that.mDimBrightness && Objects.equals(this.mBrightnessListener, that.mBrightnessListener);
    }

    public int hashCode() {
        int hashCode = Objects.hash(this.mName, this.mWidth, this.mHeight, this.mDensityDpi, this.mFlags, this.mSurface, this.mUniqueId, this.mDisplayIdToMirror, this.mWindowManagerMirroringEnabled, this.mDisplayCategories, Float.valueOf(this.mRequestedRefreshRate), this.mIsHomeSupported, this.mDisplayCutout, this.mIgnoreActivitySizeRestrictions, Float.valueOf(this.mDefaultBrightness), Float.valueOf(this.mDimBrightness), this.mBrightnessListener);
        return hashCode;
    }

    @NonNull
    public String toString() {
        return "VirtualDisplayConfig( mName=" + this.mName + " mHeight=" + this.mHeight + " mWidth=" + this.mWidth + " mDensityDpi=" + this.mDensityDpi + " mFlags=" + this.mFlags + " mSurface=" + this.mSurface + " mUniqueId=" + this.mUniqueId + " mDisplayIdToMirror=" + this.mDisplayIdToMirror + " mWindowManagerMirroringEnabled=" + this.mWindowManagerMirroringEnabled + " mDisplayCategories=" + this.mDisplayCategories + " mRequestedRefreshRate=" + this.mRequestedRefreshRate + " mIsHomeSupported=" + this.mIsHomeSupported + " mDisplayCutout=" + this.mDisplayCutout + " mIgnoreActivitySizeRestrictions=" + this.mIgnoreActivitySizeRestrictions + " mDefaultBrightness=" + this.mDefaultBrightness + " mDimBrightness=" + this.mDimBrightness + ")";
    }

    private VirtualDisplayConfig(@NonNull Parcel in) {
        this.mName = in.readString8();
        this.mWidth = in.readInt();
        this.mHeight = in.readInt();
        this.mDensityDpi = in.readInt();
        this.mFlags = in.readInt();
        this.mSurface = in.readTypedObject(Surface.CREATOR);
        this.mUniqueId = in.readString8();
        this.mDisplayIdToMirror = in.readInt();
        this.mWindowManagerMirroringEnabled = in.readBoolean();
        this.mDisplayCategories = in.readArraySet(null);
        this.mRequestedRefreshRate = in.readFloat();
        this.mIsHomeSupported = in.readBoolean();
        this.mDisplayCutout = DisplayCutout.ParcelableWrapper.readCutoutFromParcel(in);
        this.mIgnoreActivitySizeRestrictions = in.readBoolean();
        this.mDefaultBrightness = in.readFloat();
        this.mDimBrightness = in.readFloat();
        this.mBrightnessListener = IBrightnessListener.Stub.asInterface(in.readStrongBinder());
    }

    public static class Builder {
        private final String mName;
        private final int mWidth;
        private final int mHeight;
        private final int mDensityDpi;
        private int mFlags = 0;
        private Surface mSurface = null;
        private String mUniqueId = null;
        private int mDisplayIdToMirror = 0;
        private boolean mWindowManagerMirroringEnabled = false;
        private ArraySet<String> mDisplayCategories = new ArraySet();
        private float mRequestedRefreshRate = 0.0f;
        private boolean mIsHomeSupported = false;
        private DisplayCutout mDisplayCutout = null;
        private boolean mIgnoreActivitySizeRestrictions = false;
        private float mDefaultBrightness = 0.0f;
        private float mDimBrightness = -1.0f;
        private IBrightnessListener mBrightnessListener = null;

        public Builder(@NonNull String name, int width, int height, int densityDpi) {
            if (name == null) {
                throw new IllegalArgumentException("Virtual display name is required");
            }
            if (width <= 0) {
                throw new IllegalArgumentException("Virtual display width must be positive");
            }
            if (height <= 0) {
                throw new IllegalArgumentException("Virtual display height must be positive");
            }
            if (densityDpi <= 0) {
                throw new IllegalArgumentException("Virtual display density must be positive");
            }
            this.mName = name;
            this.mWidth = width;
            this.mHeight = height;
            this.mDensityDpi = densityDpi;
        }

        @NonNull
        public Builder setFlags(int flags) {
            this.mFlags = flags;
            return this;
        }

        @NonNull
        public Builder setSurface(@Nullable Surface surface) {
            this.mSurface = surface;
            return this;
        }

        @NonNull
        public Builder setUniqueId(@Nullable String uniqueId) {
            this.mUniqueId = uniqueId;
            return this;
        }

        @NonNull
        public Builder setDisplayIdToMirror(int displayIdToMirror) {
            this.mDisplayIdToMirror = displayIdToMirror;
            return this;
        }

        @NonNull
        public Builder setWindowManagerMirroringEnabled(boolean windowManagerMirroringEnabled) {
            this.mWindowManagerMirroringEnabled = windowManagerMirroringEnabled;
            return this;
        }

        @NonNull
        public Builder setDisplayCategories(@NonNull Set<String> displayCategories) {
            this.mDisplayCategories.clear();
            this.mDisplayCategories.addAll((Collection<String>)Objects.requireNonNull(displayCategories));
            return this;
        }

        @NonNull
        public Builder addDisplayCategory(@NonNull String displayCategory) {
            this.mDisplayCategories.add(Objects.requireNonNull(displayCategory));
            return this;
        }

        @NonNull
        public Builder setRequestedRefreshRate(float requestedRefreshRate) {
            if (requestedRefreshRate < 0.0f) {
                throw new IllegalArgumentException("Virtual display requested refresh rate must be non-negative");
            }
            this.mRequestedRefreshRate = requestedRefreshRate;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setHomeSupported(boolean isHomeSupported) {
            this.mIsHomeSupported = isHomeSupported;
            return this;
        }

        @SystemApi
        @FlaggedApi(value="android.companion.virtualdevice.flags.virtual_display_insets")
        @NonNull
        public Builder setDisplayCutout(@Nullable DisplayCutout displayCutout) {
            this.mDisplayCutout = displayCutout;
            return this;
        }

        @SystemApi
        @FlaggedApi(value="com.android.window.flags.vdm_force_app_universal_resizable_api")
        @NonNull
        public Builder setIgnoreActivitySizeRestrictions(boolean enabled) {
            this.mIgnoreActivitySizeRestrictions = enabled;
            return this;
        }

        @FlaggedApi(value="android.companion.virtualdevice.flags.device_aware_display_power")
        @NonNull
        public Builder setDefaultBrightness(float brightness) {
            if (!this.isValidBrightness(brightness)) {
                throw new IllegalArgumentException("Virtual display default brightness must be in range [0.0, 1.0]");
            }
            this.mDefaultBrightness = brightness;
            return this;
        }

        @FlaggedApi(value="android.companion.virtualdevice.flags.device_aware_display_power")
        @NonNull
        public Builder setDimBrightness(float brightness) {
            if (!this.isValidBrightness(brightness)) {
                throw new IllegalArgumentException("Virtual display dim brightness must be in range [0.0, 1.0]");
            }
            this.mDimBrightness = brightness;
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @FlaggedApi(value="android.companion.virtualdevice.flags.device_aware_display_power")
        @NonNull
        public Builder setBrightnessListener(@NonNull Executor executor, @NonNull BrightnessListener listener) {
            this.mBrightnessListener = new BrightnessListenerDelegate(Objects.requireNonNull(executor), Objects.requireNonNull(listener));
            return this;
        }

        private boolean isValidBrightness(float brightness) {
            return !Float.isNaN(brightness) && 0.0f <= brightness && brightness <= 1.0f;
        }

        @NonNull
        public VirtualDisplayConfig build() {
            if (this.isValidBrightness(this.mDimBrightness) && this.mDimBrightness > this.mDefaultBrightness) {
                throw new IllegalArgumentException("The dim brightness must not be greater than the default brightness");
            }
            return new VirtualDisplayConfig(this.mName, this.mWidth, this.mHeight, this.mDensityDpi, this.mFlags, this.mSurface, this.mUniqueId, this.mDisplayIdToMirror, this.mWindowManagerMirroringEnabled, this.mDisplayCategories, this.mRequestedRefreshRate, this.mIsHomeSupported, this.mDisplayCutout, this.mIgnoreActivitySizeRestrictions, this.mDefaultBrightness, this.mDimBrightness, this.mBrightnessListener);
        }
    }

    private static class BrightnessListenerDelegate
    extends IBrightnessListener.Stub {
        @NonNull
        private final Executor mExecutor;
        @NonNull
        private final BrightnessListener mListener;

        BrightnessListenerDelegate(@NonNull Executor executor, @NonNull BrightnessListener listener) {
            this.mExecutor = executor;
            this.mListener = listener;
        }

        @Override
        public void onBrightnessChanged(float brightness) {
            this.mExecutor.execute(() -> this.mListener.onBrightnessChanged(brightness));
        }
    }

    @FlaggedApi(value="android.companion.virtualdevice.flags.device_aware_display_power")
    public static interface BrightnessListener {
        public void onBrightnessChanged(float var1);
    }
}

