/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.fingerprint;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.Context;
import android.hardware.biometrics.fingerprint.IFingerprint;
import android.hardware.biometrics.fingerprint.SensorProps;
import android.hardware.biometrics.fingerprint.virtualhal.IVirtualHal;
import android.hardware.fingerprint.HidlFingerprintSensorConfig;
import android.os.Binder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import android.util.Slog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class FingerprintSensorConfigurations
implements Parcelable {
    private static final String TAG = "FingerprintSensorConfigurations";
    private final Map<String, SensorProps[]> mSensorPropsMap;
    private final boolean mResetLockoutRequiresHardwareAuthToken;
    public static final Parcelable.Creator<FingerprintSensorConfigurations> CREATOR = new Parcelable.Creator<FingerprintSensorConfigurations>(){

        @Override
        public FingerprintSensorConfigurations createFromParcel(Parcel in) {
            return new FingerprintSensorConfigurations(in);
        }

        public FingerprintSensorConfigurations[] newArray(int size) {
            return new FingerprintSensorConfigurations[size];
        }
    };

    public FingerprintSensorConfigurations(boolean resetLockoutRequiresHardwareAuthToken) {
        this.mResetLockoutRequiresHardwareAuthToken = resetLockoutRequiresHardwareAuthToken;
        this.mSensorPropsMap = new HashMap<String, SensorProps[]>();
    }

    public void addAidlSensors(@NonNull String[] aidlInstances) {
        for (String aidlInstance : aidlInstances) {
            this.mSensorPropsMap.put(aidlInstance, null);
        }
    }

    public void addHidlSensors(@NonNull String[] hidlConfigStrings, @NonNull Context context) {
        ArrayList<HidlFingerprintSensorConfig> hidlFingerprintSensorConfigs = new ArrayList<HidlFingerprintSensorConfig>();
        for (String hidlConfigString : hidlConfigStrings) {
            HidlFingerprintSensorConfig hidlFingerprintSensorConfig = new HidlFingerprintSensorConfig();
            try {
                hidlFingerprintSensorConfig.parse(hidlConfigString, context);
            }
            catch (Exception e) {
                Log.e(TAG, "HIDL sensor configuration format is incorrect.");
                continue;
            }
            if (hidlFingerprintSensorConfig.getModality() != 2) continue;
            hidlFingerprintSensorConfigs.add(hidlFingerprintSensorConfig);
        }
        String hidlHalInstanceName = "defaultHIDL";
        this.mSensorPropsMap.put("defaultHIDL", hidlFingerprintSensorConfigs.toArray(new HidlFingerprintSensorConfig[hidlFingerprintSensorConfigs.size()]));
    }

    protected FingerprintSensorConfigurations(Parcel in) {
        this.mResetLockoutRequiresHardwareAuthToken = in.readByte() != 0;
        this.mSensorPropsMap = in.readHashMap(null, String.class, SensorProps[].class);
    }

    public boolean hasSensorConfigurations() {
        return this.mSensorPropsMap.size() > 0;
    }

    public boolean isSingleSensorConfigurationPresent() {
        return this.mSensorPropsMap.size() == 1;
    }

    @Nullable
    public boolean doesInstanceExist(String instance) {
        return this.mSensorPropsMap.containsKey(instance);
    }

    @Nullable
    public String getSensorNameNotForInstance(String instance) {
        Optional<String> notAVirtualInstance = this.mSensorPropsMap.keySet().stream().filter(instanceName -> !instanceName.equals(instance)).findFirst();
        return notAVirtualInstance.orElse(null);
    }

    @Nullable
    public String getSensorInstance() {
        Optional optionalInstance = this.mSensorPropsMap.keySet().stream().findFirst();
        return optionalInstance.orElse(null);
    }

    public boolean getResetLockoutRequiresHardwareAuthToken() {
        return this.mResetLockoutRequiresHardwareAuthToken;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeByte((byte)(this.mResetLockoutRequiresHardwareAuthToken ? 1 : 0));
        dest.writeMap(this.mSensorPropsMap);
    }

    public static String remapFqName(String fqName) {
        if (!fqName.contains(IFingerprint.DESCRIPTOR + "/virtual")) {
            return fqName;
        }
        return fqName.replace("IFingerprint", "virtualhal.IVirtualHal");
    }

    public static IFingerprint getIFingerprint(String fqName) {
        if (fqName.contains("virtual")) {
            String fqNameMapped = FingerprintSensorConfigurations.remapFqName(fqName);
            Slog.i(TAG, "getIFingerprint fqName is mapped: " + fqName + "->" + fqNameMapped);
            try {
                IVirtualHal vhal = IVirtualHal.Stub.asInterface(Binder.allowBlocking(ServiceManager.waitForService((String)fqNameMapped)));
                return vhal.getFingerprintHal();
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Remote exception in vhal.getFingerprintHal() call" + fqNameMapped);
            }
        }
        return IFingerprint.Stub.asInterface(Binder.allowBlocking(ServiceManager.waitForDeclaredService((String)fqName)));
    }

    @Nullable
    public SensorProps[] getSensorPropForInstance(String instance) {
        SensorProps[] props = this.mSensorPropsMap.get(instance);
        if (props != null) {
            return props;
        }
        try {
            String fqName = IFingerprint.DESCRIPTOR + "/" + instance;
            IFingerprint fp = FingerprintSensorConfigurations.getIFingerprint(fqName);
            if (fp != null) {
                props = fp.getSensorProps();
            } else {
                Log.d(TAG, "IFingerprint null for instance " + instance);
            }
        }
        catch (RemoteException e) {
            Log.d(TAG, "Unable to get sensor properties!");
        }
        if (props == null) {
            props = new SensorProps[]{};
        }
        return props;
    }
}

