/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.fingerprint;

import android.annotation.NonNull;
import android.content.Context;
import android.hardware.biometrics.common.CommonProps;
import android.hardware.biometrics.fingerprint.SensorLocation;
import android.hardware.biometrics.fingerprint.SensorProps;
import com.android.internal.util.ArrayUtils;

public class HidlFingerprintSensorConfig
extends SensorProps {
    private int mSensorId;
    private int mModality;
    private int mStrength;

    public void parse(@NonNull String config, @NonNull Context context) throws IllegalArgumentException {
        String[] elems = config.split(":");
        if (elems.length < 3) {
            throw new IllegalArgumentException();
        }
        this.mSensorId = Integer.parseInt(elems[0]);
        this.mModality = Integer.parseInt(elems[1]);
        this.mStrength = Integer.parseInt(elems[2]);
        this.mapHidlToAidlSensorConfiguration(context);
    }

    public int getModality() {
        return this.mModality;
    }

    private void mapHidlToAidlSensorConfiguration(@NonNull Context context) {
        this.commonProps = new CommonProps();
        this.commonProps.componentInfo = null;
        this.commonProps.sensorId = this.mSensorId;
        this.commonProps.sensorStrength = this.authenticatorStrengthToPropertyStrength(this.mStrength);
        this.commonProps.maxEnrollmentsPerUser = context.getResources().getInteger(17694884);
        this.halControlsIllumination = false;
        this.sensorLocations = new SensorLocation[1];
        int[] udfpsProps = context.getResources().getIntArray(17236196);
        boolean isUdfps = !ArrayUtils.isEmpty(udfpsProps);
        boolean isPowerbuttonFps = context.getResources().getBoolean(17891799);
        this.sensorType = isUdfps ? (byte)0 : (isPowerbuttonFps ? (byte)4 : (byte)1);
        if (isUdfps && udfpsProps.length == 3) {
            this.setSensorLocation(udfpsProps[0], udfpsProps[1], udfpsProps[2]);
        } else {
            this.setSensorLocation(540, 1636, 130);
        }
    }

    private void setSensorLocation(int sensorLocationX, int sensorLocationY, int sensorRadius) {
        this.sensorLocations[0] = new SensorLocation();
        this.sensorLocations[0].display = "";
        this.sensorLocations[0].sensorLocationX = sensorLocationX;
        this.sensorLocations[0].sensorLocationY = sensorLocationY;
        this.sensorLocations[0].sensorRadius = sensorRadius;
    }

    private byte authenticatorStrengthToPropertyStrength(int strength) {
        switch (strength) {
            case 4095: {
                return 0;
            }
            case 255: {
                return 1;
            }
            case 15: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Unknown strength: " + strength);
    }
}

