/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.fingerprint;

import android.annotation.EnforcePermission;
import android.app.ActivityThread;
import android.hardware.biometrics.AuthenticationStateListener;
import android.hardware.biometrics.IBiometricSensorReceiver;
import android.hardware.biometrics.IBiometricServiceLockoutResetCallback;
import android.hardware.biometrics.IBiometricStateListener;
import android.hardware.biometrics.IInvalidationCallback;
import android.hardware.biometrics.ITestSession;
import android.hardware.biometrics.ITestSessionCallback;
import android.hardware.biometrics.fingerprint.PointerContext;
import android.hardware.fingerprint.Fingerprint;
import android.hardware.fingerprint.FingerprintAuthenticateOptions;
import android.hardware.fingerprint.FingerprintEnrollOptions;
import android.hardware.fingerprint.FingerprintSensorConfigurations;
import android.hardware.fingerprint.FingerprintSensorPropertiesInternal;
import android.hardware.fingerprint.IFingerprintAuthenticatorsRegisteredCallback;
import android.hardware.fingerprint.IFingerprintClientActiveCallback;
import android.hardware.fingerprint.IFingerprintServiceReceiver;
import android.hardware.fingerprint.IUdfpsOverlayController;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IFingerprintService
extends IInterface {
    @EnforcePermission(value="android.permission.TEST_BIOMETRIC")
    public ITestSession createTestSession(int var1, ITestSessionCallback var2, String var3) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public byte[] dumpSensorServiceStateProto(int var1, boolean var2) throws RemoteException;

    public List<FingerprintSensorPropertiesInternal> getSensorPropertiesInternal(String var1) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public FingerprintSensorPropertiesInternal getSensorProperties(int var1, String var2) throws RemoteException;

    public long authenticate(IBinder var1, long var2, IFingerprintServiceReceiver var4, FingerprintAuthenticateOptions var5) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public long detectFingerprint(IBinder var1, IFingerprintServiceReceiver var2, FingerprintAuthenticateOptions var3) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_BIOMETRIC")
    public void prepareForAuthentication(IBinder var1, long var2, IBiometricSensorReceiver var4, FingerprintAuthenticateOptions var5, long var6, int var8, boolean var9, boolean var10) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_BIOMETRIC")
    public void startPreparedClient(int var1, int var2) throws RemoteException;

    public void cancelAuthentication(IBinder var1, String var2, String var3, long var4) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void cancelFingerprintDetect(IBinder var1, String var2, long var3) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_BIOMETRIC")
    public void cancelAuthenticationFromService(int var1, IBinder var2, String var3, long var4) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_FINGERPRINT")
    public long enroll(IBinder var1, byte[] var2, int var3, IFingerprintServiceReceiver var4, String var5, int var6, FingerprintEnrollOptions var7) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_FINGERPRINT")
    public void cancelEnrollment(IBinder var1, long var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_FINGERPRINT")
    public void remove(IBinder var1, int var2, int var3, IFingerprintServiceReceiver var4, String var5) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void removeAll(IBinder var1, int var2, IFingerprintServiceReceiver var3, String var4) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_FINGERPRINT")
    public void rename(int var1, int var2, String var3) throws RemoteException;

    public List<Fingerprint> getEnrolledFingerprints(int var1, String var2, String var3) throws RemoteException;

    public boolean isHardwareDetectedDeprecated(String var1, String var2) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public boolean isHardwareDetected(int var1, String var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_FINGERPRINT")
    public void generateChallenge(IBinder var1, int var2, int var3, IFingerprintServiceReceiver var4, String var5) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_FINGERPRINT")
    public void revokeChallenge(IBinder var1, int var2, int var3, String var4, long var5) throws RemoteException;

    public boolean hasEnrolledFingerprintsDeprecated(int var1, String var2, String var3) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public boolean hasEnrolledFingerprints(int var1, int var2, String var3) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public int getLockoutModeForUser(int var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void invalidateAuthenticatorId(int var1, int var2, IInvalidationCallback var3) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public long getAuthenticatorId(int var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.RESET_FINGERPRINT_LOCKOUT")
    public void resetLockout(IBinder var1, int var2, int var3, byte[] var4, String var5) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void addLockoutResetCallback(IBiometricServiceLockoutResetCallback var1, String var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_FINGERPRINT")
    public boolean isClientActive() throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_FINGERPRINT")
    public void addClientActiveCallback(IFingerprintClientActiveCallback var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_FINGERPRINT")
    public void removeClientActiveCallback(IFingerprintClientActiveCallback var1) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void registerAuthenticators(FingerprintSensorConfigurations var1) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void addAuthenticatorsRegisteredCallback(IFingerprintAuthenticatorsRegisteredCallback var1) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void onPointerDown(long var1, int var3, PointerContext var4) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void onPointerUp(long var1, int var3, PointerContext var4) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void onUdfpsUiEvent(int var1, long var2, int var4) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void setIgnoreDisplayTouches(long var1, int var3, boolean var4) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void setUdfpsOverlayController(IUdfpsOverlayController var1) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void registerAuthenticationStateListener(AuthenticationStateListener var1) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void unregisterAuthenticationStateListener(AuthenticationStateListener var1) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void registerBiometricStateListener(IBiometricStateListener var1) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void onPowerPressed() throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void scheduleWatchdog() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IFingerprintService {
        private final PermissionEnforcer mEnforcer;
        public static final String DESCRIPTOR = "android.hardware.fingerprint.IFingerprintService";
        static final int TRANSACTION_createTestSession = 1;
        static final int TRANSACTION_dumpSensorServiceStateProto = 2;
        static final int TRANSACTION_getSensorPropertiesInternal = 3;
        static final int TRANSACTION_getSensorProperties = 4;
        static final int TRANSACTION_authenticate = 5;
        static final int TRANSACTION_detectFingerprint = 6;
        static final int TRANSACTION_prepareForAuthentication = 7;
        static final int TRANSACTION_startPreparedClient = 8;
        static final int TRANSACTION_cancelAuthentication = 9;
        static final int TRANSACTION_cancelFingerprintDetect = 10;
        static final int TRANSACTION_cancelAuthenticationFromService = 11;
        static final int TRANSACTION_enroll = 12;
        static final int TRANSACTION_cancelEnrollment = 13;
        static final int TRANSACTION_remove = 14;
        static final int TRANSACTION_removeAll = 15;
        static final int TRANSACTION_rename = 16;
        static final int TRANSACTION_getEnrolledFingerprints = 17;
        static final int TRANSACTION_isHardwareDetectedDeprecated = 18;
        static final int TRANSACTION_isHardwareDetected = 19;
        static final int TRANSACTION_generateChallenge = 20;
        static final int TRANSACTION_revokeChallenge = 21;
        static final int TRANSACTION_hasEnrolledFingerprintsDeprecated = 22;
        static final int TRANSACTION_hasEnrolledFingerprints = 23;
        static final int TRANSACTION_getLockoutModeForUser = 24;
        static final int TRANSACTION_invalidateAuthenticatorId = 25;
        static final int TRANSACTION_getAuthenticatorId = 26;
        static final int TRANSACTION_resetLockout = 27;
        static final int TRANSACTION_addLockoutResetCallback = 28;
        static final int TRANSACTION_isClientActive = 29;
        static final int TRANSACTION_addClientActiveCallback = 30;
        static final int TRANSACTION_removeClientActiveCallback = 31;
        static final int TRANSACTION_registerAuthenticators = 32;
        static final int TRANSACTION_addAuthenticatorsRegisteredCallback = 33;
        static final int TRANSACTION_onPointerDown = 34;
        static final int TRANSACTION_onPointerUp = 35;
        static final int TRANSACTION_onUdfpsUiEvent = 36;
        static final int TRANSACTION_setIgnoreDisplayTouches = 37;
        static final int TRANSACTION_setUdfpsOverlayController = 38;
        static final int TRANSACTION_registerAuthenticationStateListener = 39;
        static final int TRANSACTION_unregisterAuthenticationStateListener = 40;
        static final int TRANSACTION_registerBiometricStateListener = 41;
        static final int TRANSACTION_onPowerPressed = 42;
        static final int TRANSACTION_scheduleWatchdog = 43;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentSystemContext()));
        }

        public static IFingerprintService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IFingerprintService) {
                return (IFingerprintService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "createTestSession";
                }
                case 2: {
                    return "dumpSensorServiceStateProto";
                }
                case 3: {
                    return "getSensorPropertiesInternal";
                }
                case 4: {
                    return "getSensorProperties";
                }
                case 5: {
                    return "authenticate";
                }
                case 6: {
                    return "detectFingerprint";
                }
                case 7: {
                    return "prepareForAuthentication";
                }
                case 8: {
                    return "startPreparedClient";
                }
                case 9: {
                    return "cancelAuthentication";
                }
                case 10: {
                    return "cancelFingerprintDetect";
                }
                case 11: {
                    return "cancelAuthenticationFromService";
                }
                case 12: {
                    return "enroll";
                }
                case 13: {
                    return "cancelEnrollment";
                }
                case 14: {
                    return "remove";
                }
                case 15: {
                    return "removeAll";
                }
                case 16: {
                    return "rename";
                }
                case 17: {
                    return "getEnrolledFingerprints";
                }
                case 18: {
                    return "isHardwareDetectedDeprecated";
                }
                case 19: {
                    return "isHardwareDetected";
                }
                case 20: {
                    return "generateChallenge";
                }
                case 21: {
                    return "revokeChallenge";
                }
                case 22: {
                    return "hasEnrolledFingerprintsDeprecated";
                }
                case 23: {
                    return "hasEnrolledFingerprints";
                }
                case 24: {
                    return "getLockoutModeForUser";
                }
                case 25: {
                    return "invalidateAuthenticatorId";
                }
                case 26: {
                    return "getAuthenticatorId";
                }
                case 27: {
                    return "resetLockout";
                }
                case 28: {
                    return "addLockoutResetCallback";
                }
                case 29: {
                    return "isClientActive";
                }
                case 30: {
                    return "addClientActiveCallback";
                }
                case 31: {
                    return "removeClientActiveCallback";
                }
                case 32: {
                    return "registerAuthenticators";
                }
                case 33: {
                    return "addAuthenticatorsRegisteredCallback";
                }
                case 34: {
                    return "onPointerDown";
                }
                case 35: {
                    return "onPointerUp";
                }
                case 36: {
                    return "onUdfpsUiEvent";
                }
                case 37: {
                    return "setIgnoreDisplayTouches";
                }
                case 38: {
                    return "setUdfpsOverlayController";
                }
                case 39: {
                    return "registerAuthenticationStateListener";
                }
                case 40: {
                    return "unregisterAuthenticationStateListener";
                }
                case 41: {
                    return "registerBiometricStateListener";
                }
                case 42: {
                    return "onPowerPressed";
                }
                case 43: {
                    return "scheduleWatchdog";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    ITestSessionCallback _arg1 = ITestSessionCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    ITestSession _result = this.createTestSession(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    byte[] _result = this.dumpSensorServiceStateProto(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    List<FingerprintSensorPropertiesInternal> _result = this.getSensorPropertiesInternal(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    FingerprintSensorPropertiesInternal _result = this.getSensorProperties(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 5: {
                    IBinder _arg0 = data.readStrongBinder();
                    long _arg1 = data.readLong();
                    IFingerprintServiceReceiver _arg2 = IFingerprintServiceReceiver.Stub.asInterface(data.readStrongBinder());
                    FingerprintAuthenticateOptions _arg3 = data.readTypedObject(FingerprintAuthenticateOptions.CREATOR);
                    data.enforceNoDataAvail();
                    long _result = this.authenticate(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 6: {
                    IBinder _arg0 = data.readStrongBinder();
                    IFingerprintServiceReceiver _arg1 = IFingerprintServiceReceiver.Stub.asInterface(data.readStrongBinder());
                    FingerprintAuthenticateOptions _arg2 = data.readTypedObject(FingerprintAuthenticateOptions.CREATOR);
                    data.enforceNoDataAvail();
                    long _result = this.detectFingerprint(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 7: {
                    IBinder _arg0 = data.readStrongBinder();
                    long _arg1 = data.readLong();
                    IBiometricSensorReceiver _arg2 = IBiometricSensorReceiver.Stub.asInterface(data.readStrongBinder());
                    FingerprintAuthenticateOptions _arg3 = data.readTypedObject(FingerprintAuthenticateOptions.CREATOR);
                    long _arg4 = data.readLong();
                    int _arg5 = data.readInt();
                    boolean _arg6 = data.readBoolean();
                    boolean _arg7 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.prepareForAuthentication(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.startPreparedClient(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    long _arg3 = data.readLong();
                    data.enforceNoDataAvail();
                    this.cancelAuthentication(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    long _arg2 = data.readLong();
                    data.enforceNoDataAvail();
                    this.cancelFingerprintDetect(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    String _arg2 = data.readString();
                    long _arg3 = data.readLong();
                    data.enforceNoDataAvail();
                    this.cancelAuthenticationFromService(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    IBinder _arg0 = data.readStrongBinder();
                    byte[] _arg1 = data.createByteArray();
                    int _arg2 = data.readInt();
                    IFingerprintServiceReceiver _arg3 = IFingerprintServiceReceiver.Stub.asInterface(data.readStrongBinder());
                    String _arg4 = data.readString();
                    int _arg5 = data.readInt();
                    FingerprintEnrollOptions _arg6 = data.readTypedObject(FingerprintEnrollOptions.CREATOR);
                    data.enforceNoDataAvail();
                    long _result = this.enroll(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 13: {
                    IBinder _arg0 = data.readStrongBinder();
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    this.cancelEnrollment(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    IFingerprintServiceReceiver _arg3 = IFingerprintServiceReceiver.Stub.asInterface(data.readStrongBinder());
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.remove(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    IFingerprintServiceReceiver _arg2 = IFingerprintServiceReceiver.Stub.asInterface(data.readStrongBinder());
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.removeAll(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.rename(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    List<Fingerprint> _result = this.getEnrolledFingerprints(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 18: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isHardwareDetectedDeprecated(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 19: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isHardwareDetected(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 20: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    IFingerprintServiceReceiver _arg3 = IFingerprintServiceReceiver.Stub.asInterface(data.readStrongBinder());
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.generateChallenge(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    long _arg4 = data.readLong();
                    data.enforceNoDataAvail();
                    this.revokeChallenge(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasEnrolledFingerprintsDeprecated(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 23: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasEnrolledFingerprints(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 24: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getLockoutModeForUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 25: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    IInvalidationCallback _arg2 = IInvalidationCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.invalidateAuthenticatorId(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    long _result = this.getAuthenticatorId(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 27: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    byte[] _arg3 = data.createByteArray();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.resetLockout(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    IBiometricServiceLockoutResetCallback _arg0 = IBiometricServiceLockoutResetCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.addLockoutResetCallback(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    boolean _result = this.isClientActive();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 30: {
                    IFingerprintClientActiveCallback _arg0 = IFingerprintClientActiveCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addClientActiveCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    IFingerprintClientActiveCallback _arg0 = IFingerprintClientActiveCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeClientActiveCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 32: {
                    FingerprintSensorConfigurations _arg0 = data.readTypedObject(FingerprintSensorConfigurations.CREATOR);
                    data.enforceNoDataAvail();
                    this.registerAuthenticators(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 33: {
                    IFingerprintAuthenticatorsRegisteredCallback _arg0 = IFingerprintAuthenticatorsRegisteredCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addAuthenticatorsRegisteredCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    PointerContext _arg2 = data.readTypedObject(PointerContext.CREATOR);
                    data.enforceNoDataAvail();
                    this.onPointerDown(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 35: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    PointerContext _arg2 = data.readTypedObject(PointerContext.CREATOR);
                    data.enforceNoDataAvail();
                    this.onPointerUp(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 36: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onUdfpsUiEvent(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 37: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setIgnoreDisplayTouches(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 38: {
                    IUdfpsOverlayController _arg0 = IUdfpsOverlayController.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setUdfpsOverlayController(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 39: {
                    AuthenticationStateListener _arg0 = AuthenticationStateListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerAuthenticationStateListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 40: {
                    AuthenticationStateListener _arg0 = AuthenticationStateListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterAuthenticationStateListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 41: {
                    IBiometricStateListener _arg0 = IBiometricStateListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerBiometricStateListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 42: {
                    this.onPowerPressed();
                    break;
                }
                case 43: {
                    this.scheduleWatchdog();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void createTestSession_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.TEST_BIOMETRIC", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void dumpSensorServiceStateProto_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getSensorProperties_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void detectFingerprint_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void prepareForAuthentication_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_BIOMETRIC", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void startPreparedClient_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_BIOMETRIC", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void cancelFingerprintDetect_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void cancelAuthenticationFromService_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_BIOMETRIC", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void enroll_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_FINGERPRINT", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void cancelEnrollment_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_FINGERPRINT", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void remove_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_FINGERPRINT", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void removeAll_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void rename_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_FINGERPRINT", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isHardwareDetected_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void generateChallenge_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_FINGERPRINT", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void revokeChallenge_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_FINGERPRINT", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void hasEnrolledFingerprints_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getLockoutModeForUser_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void invalidateAuthenticatorId_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getAuthenticatorId_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void resetLockout_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.RESET_FINGERPRINT_LOCKOUT", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void addLockoutResetCallback_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isClientActive_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_FINGERPRINT", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void addClientActiveCallback_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_FINGERPRINT", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void removeClientActiveCallback_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_FINGERPRINT", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void registerAuthenticators_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void addAuthenticatorsRegisteredCallback_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void onPointerDown_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void onPointerUp_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void onUdfpsUiEvent_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setIgnoreDisplayTouches_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setUdfpsOverlayController_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void registerAuthenticationStateListener_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void unregisterAuthenticationStateListener_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void registerBiometricStateListener_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void onPowerPressed_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void scheduleWatchdog_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 42;
        }

        private static class Proxy
        implements IFingerprintService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ITestSession createTestSession(int sensorId, ITestSessionCallback callback, String opPackageName) throws RemoteException {
                ITestSession _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeStrongInterface(callback);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = ITestSession.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] dumpSensorServiceStateProto(int sensorId, boolean clearSchedulerBuffer) throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeBoolean(clearSchedulerBuffer);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<FingerprintSensorPropertiesInternal> getSensorPropertiesInternal(String opPackageName) throws RemoteException {
                ArrayList<FingerprintSensorPropertiesInternal> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(FingerprintSensorPropertiesInternal.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public FingerprintSensorPropertiesInternal getSensorProperties(int sensorId, String opPackageName) throws RemoteException {
                FingerprintSensorPropertiesInternal _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(FingerprintSensorPropertiesInternal.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long authenticate(IBinder token, long operationId, IFingerprintServiceReceiver receiver, FingerprintAuthenticateOptions options) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeLong(operationId);
                    _data.writeStrongInterface(receiver);
                    _data.writeTypedObject(options, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long detectFingerprint(IBinder token, IFingerprintServiceReceiver receiver, FingerprintAuthenticateOptions options) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeStrongInterface(receiver);
                    _data.writeTypedObject(options, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void prepareForAuthentication(IBinder token, long operationId, IBiometricSensorReceiver sensorReceiver, FingerprintAuthenticateOptions options, long requestId, int cookie, boolean allowBackgroundAuthentication, boolean isForLegacyFingerprintManager) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeLong(operationId);
                    _data.writeStrongInterface(sensorReceiver);
                    _data.writeTypedObject(options, 0);
                    _data.writeLong(requestId);
                    _data.writeInt(cookie);
                    _data.writeBoolean(allowBackgroundAuthentication);
                    _data.writeBoolean(isForLegacyFingerprintManager);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startPreparedClient(int sensorId, int cookie) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeInt(cookie);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelAuthentication(IBinder token, String opPackageName, String attributionTag, long requestId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeString(opPackageName);
                    _data.writeString(attributionTag);
                    _data.writeLong(requestId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelFingerprintDetect(IBinder token, String opPackageName, long requestId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeString(opPackageName);
                    _data.writeLong(requestId);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelAuthenticationFromService(int sensorId, IBinder token, String opPackageName, long requestId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeStrongBinder(token);
                    _data.writeString(opPackageName);
                    _data.writeLong(requestId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long enroll(IBinder token, byte[] hardwareAuthToken, int userId, IFingerprintServiceReceiver receiver, String opPackageName, int enrollReason, FingerprintEnrollOptions options) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeByteArray(hardwareAuthToken);
                    _data.writeInt(userId);
                    _data.writeStrongInterface(receiver);
                    _data.writeString(opPackageName);
                    _data.writeInt(enrollReason);
                    _data.writeTypedObject(options, 0);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelEnrollment(IBinder token, long requestId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeLong(requestId);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove(IBinder token, int fingerId, int userId, IFingerprintServiceReceiver receiver, String opPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(fingerId);
                    _data.writeInt(userId);
                    _data.writeStrongInterface(receiver);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeAll(IBinder token, int userId, IFingerprintServiceReceiver receiver, String opPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(userId);
                    _data.writeStrongInterface(receiver);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void rename(int fingerId, int userId, String name) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(fingerId);
                    _data.writeInt(userId);
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Fingerprint> getEnrolledFingerprints(int userId, String opPackageName, String attributionTag) throws RemoteException {
                ArrayList<Fingerprint> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(opPackageName);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(Fingerprint.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHardwareDetectedDeprecated(String opPackageName, String attributionTag) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(opPackageName);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHardwareDetected(int sensorId, String opPackageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void generateChallenge(IBinder token, int sensorId, int userId, IFingerprintServiceReceiver receiver, String opPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(sensorId);
                    _data.writeInt(userId);
                    _data.writeStrongInterface(receiver);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void revokeChallenge(IBinder token, int sensorId, int userId, String opPackageName, long challenge) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(sensorId);
                    _data.writeInt(userId);
                    _data.writeString(opPackageName);
                    _data.writeLong(challenge);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasEnrolledFingerprintsDeprecated(int userId, String opPackageName, String attributionTag) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(opPackageName);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasEnrolledFingerprints(int sensorId, int userId, String opPackageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeInt(userId);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getLockoutModeForUser(int sensorId, int userId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invalidateAuthenticatorId(int sensorId, int userId, IInvalidationCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeInt(userId);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getAuthenticatorId(int sensorId, int callingUserId) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeInt(callingUserId);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetLockout(IBinder token, int sensorId, int userId, byte[] hardwareAuthToken, String opPackageNAame) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(sensorId);
                    _data.writeInt(userId);
                    _data.writeByteArray(hardwareAuthToken);
                    _data.writeString(opPackageNAame);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addLockoutResetCallback(IBiometricServiceLockoutResetCallback callback, String opPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isClientActive() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addClientActiveCallback(IFingerprintClientActiveCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeClientActiveCallback(IFingerprintClientActiveCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerAuthenticators(FingerprintSensorConfigurations fingerprintSensorConfigurations) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(fingerprintSensorConfigurations, 0);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addAuthenticatorsRegisteredCallback(IFingerprintAuthenticatorsRegisteredCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPointerDown(long requestId, int sensorId, PointerContext pc) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(requestId);
                    _data.writeInt(sensorId);
                    _data.writeTypedObject(pc, 0);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPointerUp(long requestId, int sensorId, PointerContext pc) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(requestId);
                    _data.writeInt(sensorId);
                    _data.writeTypedObject(pc, 0);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUdfpsUiEvent(int event, long requestId, int sensorId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(event);
                    _data.writeLong(requestId);
                    _data.writeInt(sensorId);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setIgnoreDisplayTouches(long requestId, int sensorId, boolean ignoreTouches) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(requestId);
                    _data.writeInt(sensorId);
                    _data.writeBoolean(ignoreTouches);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUdfpsOverlayController(IUdfpsOverlayController controller) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(controller);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerAuthenticationStateListener(AuthenticationStateListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterAuthenticationStateListener(AuthenticationStateListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerBiometricStateListener(IBiometricStateListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void onPowerPressed() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(42, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void scheduleWatchdog() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(43, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IFingerprintService {
        @Override
        public ITestSession createTestSession(int sensorId, ITestSessionCallback callback, String opPackageName) throws RemoteException {
            return null;
        }

        @Override
        public byte[] dumpSensorServiceStateProto(int sensorId, boolean clearSchedulerBuffer) throws RemoteException {
            return null;
        }

        @Override
        public List<FingerprintSensorPropertiesInternal> getSensorPropertiesInternal(String opPackageName) throws RemoteException {
            return null;
        }

        @Override
        public FingerprintSensorPropertiesInternal getSensorProperties(int sensorId, String opPackageName) throws RemoteException {
            return null;
        }

        @Override
        public long authenticate(IBinder token, long operationId, IFingerprintServiceReceiver receiver, FingerprintAuthenticateOptions options) throws RemoteException {
            return 0L;
        }

        @Override
        public long detectFingerprint(IBinder token, IFingerprintServiceReceiver receiver, FingerprintAuthenticateOptions options) throws RemoteException {
            return 0L;
        }

        @Override
        public void prepareForAuthentication(IBinder token, long operationId, IBiometricSensorReceiver sensorReceiver, FingerprintAuthenticateOptions options, long requestId, int cookie, boolean allowBackgroundAuthentication, boolean isForLegacyFingerprintManager) throws RemoteException {
        }

        @Override
        public void startPreparedClient(int sensorId, int cookie) throws RemoteException {
        }

        @Override
        public void cancelAuthentication(IBinder token, String opPackageName, String attributionTag, long requestId) throws RemoteException {
        }

        @Override
        public void cancelFingerprintDetect(IBinder token, String opPackageName, long requestId) throws RemoteException {
        }

        @Override
        public void cancelAuthenticationFromService(int sensorId, IBinder token, String opPackageName, long requestId) throws RemoteException {
        }

        @Override
        public long enroll(IBinder token, byte[] hardwareAuthToken, int userId, IFingerprintServiceReceiver receiver, String opPackageName, int enrollReason, FingerprintEnrollOptions options) throws RemoteException {
            return 0L;
        }

        @Override
        public void cancelEnrollment(IBinder token, long requestId) throws RemoteException {
        }

        @Override
        public void remove(IBinder token, int fingerId, int userId, IFingerprintServiceReceiver receiver, String opPackageName) throws RemoteException {
        }

        @Override
        public void removeAll(IBinder token, int userId, IFingerprintServiceReceiver receiver, String opPackageName) throws RemoteException {
        }

        @Override
        public void rename(int fingerId, int userId, String name) throws RemoteException {
        }

        @Override
        public List<Fingerprint> getEnrolledFingerprints(int userId, String opPackageName, String attributionTag) throws RemoteException {
            return null;
        }

        @Override
        public boolean isHardwareDetectedDeprecated(String opPackageName, String attributionTag) throws RemoteException {
            return false;
        }

        @Override
        public boolean isHardwareDetected(int sensorId, String opPackageName) throws RemoteException {
            return false;
        }

        @Override
        public void generateChallenge(IBinder token, int sensorId, int userId, IFingerprintServiceReceiver receiver, String opPackageName) throws RemoteException {
        }

        @Override
        public void revokeChallenge(IBinder token, int sensorId, int userId, String opPackageName, long challenge) throws RemoteException {
        }

        @Override
        public boolean hasEnrolledFingerprintsDeprecated(int userId, String opPackageName, String attributionTag) throws RemoteException {
            return false;
        }

        @Override
        public boolean hasEnrolledFingerprints(int sensorId, int userId, String opPackageName) throws RemoteException {
            return false;
        }

        @Override
        public int getLockoutModeForUser(int sensorId, int userId) throws RemoteException {
            return 0;
        }

        @Override
        public void invalidateAuthenticatorId(int sensorId, int userId, IInvalidationCallback callback) throws RemoteException {
        }

        @Override
        public long getAuthenticatorId(int sensorId, int callingUserId) throws RemoteException {
            return 0L;
        }

        @Override
        public void resetLockout(IBinder token, int sensorId, int userId, byte[] hardwareAuthToken, String opPackageNAame) throws RemoteException {
        }

        @Override
        public void addLockoutResetCallback(IBiometricServiceLockoutResetCallback callback, String opPackageName) throws RemoteException {
        }

        @Override
        public boolean isClientActive() throws RemoteException {
            return false;
        }

        @Override
        public void addClientActiveCallback(IFingerprintClientActiveCallback callback) throws RemoteException {
        }

        @Override
        public void removeClientActiveCallback(IFingerprintClientActiveCallback callback) throws RemoteException {
        }

        @Override
        public void registerAuthenticators(FingerprintSensorConfigurations fingerprintSensorConfigurations) throws RemoteException {
        }

        @Override
        public void addAuthenticatorsRegisteredCallback(IFingerprintAuthenticatorsRegisteredCallback callback) throws RemoteException {
        }

        @Override
        public void onPointerDown(long requestId, int sensorId, PointerContext pc) throws RemoteException {
        }

        @Override
        public void onPointerUp(long requestId, int sensorId, PointerContext pc) throws RemoteException {
        }

        @Override
        public void onUdfpsUiEvent(int event, long requestId, int sensorId) throws RemoteException {
        }

        @Override
        public void setIgnoreDisplayTouches(long requestId, int sensorId, boolean ignoreTouches) throws RemoteException {
        }

        @Override
        public void setUdfpsOverlayController(IUdfpsOverlayController controller) throws RemoteException {
        }

        @Override
        public void registerAuthenticationStateListener(AuthenticationStateListener listener) throws RemoteException {
        }

        @Override
        public void unregisterAuthenticationStateListener(AuthenticationStateListener listener) throws RemoteException {
        }

        @Override
        public void registerBiometricStateListener(IBiometricStateListener listener) throws RemoteException {
        }

        @Override
        public void onPowerPressed() throws RemoteException {
        }

        @Override
        public void scheduleWatchdog() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

