/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.Objects;

public class InputDeviceIdentifier
implements Parcelable {
    private final String mDescriptor;
    private final int mVendorId;
    private final int mProductId;
    @NonNull
    public static final Parcelable.Creator<InputDeviceIdentifier> CREATOR = new Parcelable.Creator<InputDeviceIdentifier>(){

        @Override
        public InputDeviceIdentifier createFromParcel(Parcel source) {
            return new InputDeviceIdentifier(source);
        }

        public InputDeviceIdentifier[] newArray(int size) {
            return new InputDeviceIdentifier[size];
        }
    };

    public InputDeviceIdentifier(@NonNull String descriptor, int vendorId, int productId) {
        this.mDescriptor = descriptor;
        this.mVendorId = vendorId;
        this.mProductId = productId;
    }

    private InputDeviceIdentifier(Parcel src) {
        this.mDescriptor = src.readString();
        this.mVendorId = src.readInt();
        this.mProductId = src.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mDescriptor);
        dest.writeInt(this.mVendorId);
        dest.writeInt(this.mProductId);
    }

    @NonNull
    public String getDescriptor() {
        return this.mDescriptor;
    }

    public int getVendorId() {
        return this.mVendorId;
    }

    public int getProductId() {
        return this.mProductId;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof InputDeviceIdentifier)) {
            return false;
        }
        InputDeviceIdentifier that = (InputDeviceIdentifier)o;
        return this.mVendorId == that.mVendorId && this.mProductId == that.mProductId && TextUtils.equals(this.mDescriptor, that.mDescriptor);
    }

    public int hashCode() {
        return Objects.hash(this.mDescriptor, this.mVendorId, this.mProductId);
    }

    public String toString() {
        return "InputDeviceIdentifier: vendorId: " + this.mVendorId + ", productId: " + this.mProductId + ", descriptor: " + this.mDescriptor;
    }
}

