/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.hardware.HardwareBuffer;
import android.hardware.Sensor;
import android.hardware.SensorAdditionalInfo;
import android.hardware.SensorDirectChannel;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.hardware.TriggerEventListener;
import android.hardware.input.IInputSensorEventListener;
import android.hardware.input.InputManagerGlobal;
import android.hardware.input.InputSensorInfo;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.MemoryFile;
import android.os.Message;
import android.os.RemoteException;
import android.os._Original_Build;
import android.util.Slog;
import android.util.SparseArray;
import android.view.InputDevice;
import com.android.internal.annotations.GuardedBy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InputDeviceSensorManager {
    private static final String TAG = "InputDeviceSensorManager";
    private static final boolean DEBUG = false;
    private static final int MSG_SENSOR_ACCURACY_CHANGED = 1;
    private static final int MSG_SENSOR_CHANGED = 2;
    private final InputManagerGlobal mGlobal;
    @GuardedBy(value={"mInputSensorLock"})
    private final Map<Integer, List<Sensor>> mSensors = new HashMap<Integer, List<Sensor>>();
    private final Object mInputSensorLock = new Object();
    private InputSensorEventListener mInputServiceSensorListener;
    @GuardedBy(value={"mInputSensorLock"})
    private final ArrayList<InputSensorEventListenerDelegate> mInputSensorEventListeners = new ArrayList();
    @GuardedBy(value={"mInputSensorLock"})
    @Nullable
    private HandlerThread mSensorThread;

    public InputDeviceSensorManager(InputManagerGlobal inputManagerGlobal) {
        this.mGlobal = inputManagerGlobal;
        this.initializeSensors();
    }

    SensorManager getSensorManager(int deviceId) {
        return new InputSensorManager(deviceId);
    }

    private void updateInputDeviceSensorInfoLocked(int deviceId) {
        InputDevice inputDevice = InputDevice.getDevice(deviceId);
        if (inputDevice != null && inputDevice.hasSensor()) {
            InputSensorInfo[] sensorInfos = this.mGlobal.getSensorList(deviceId);
            this.populateSensorsForInputDeviceLocked(deviceId, sensorInfos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInputDeviceAdded(int deviceId) {
        Object object = this.mInputSensorLock;
        synchronized (object) {
            if (!this.mSensors.containsKey(deviceId)) {
                this.updateInputDeviceSensorInfoLocked(deviceId);
            } else {
                Slog.e(TAG, "Received 'device added' notification for device " + deviceId + ", but it is already in the list");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInputDeviceRemoved(int deviceId) {
        Object object = this.mInputSensorLock;
        synchronized (object) {
            this.mSensors.remove(deviceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInputDeviceChanged(int deviceId) {
        Object object = this.mInputSensorLock;
        synchronized (object) {
            this.mSensors.remove(deviceId);
            this.updateInputDeviceSensorInfoLocked(deviceId);
        }
    }

    private static boolean sensorEquals(@NonNull Sensor lhs, @NonNull Sensor rhs) {
        return lhs.getType() == rhs.getType() && lhs.getId() == rhs.getId();
    }

    private void populateSensorsForInputDeviceLocked(int deviceId, InputSensorInfo[] sensorInfos) {
        ArrayList<Sensor> sensors = new ArrayList<Sensor>();
        for (int i = 0; i < sensorInfos.length; ++i) {
            Sensor sensor = new Sensor(sensorInfos[i]);
            sensors.add(sensor);
        }
        this.mSensors.put(deviceId, sensors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSensors() {
        Object object = this.mInputSensorLock;
        synchronized (object) {
            this.mSensors.clear();
            int[] deviceIds = this.mGlobal.getInputDeviceIds();
            for (int i = 0; i < deviceIds.length; ++i) {
                int deviceId = deviceIds[i];
                this.updateInputDeviceSensorInfoLocked(deviceId);
            }
        }
    }

    @GuardedBy(value={"mInputSensorLock"})
    private Sensor getInputDeviceSensorLocked(int deviceId, int sensorType) {
        List<Sensor> sensors = this.mSensors.get(deviceId);
        for (Sensor sensor : sensors) {
            if (sensor.getType() != sensorType) continue;
            return sensor;
        }
        return null;
    }

    @GuardedBy(value={"mInputSensorLock"})
    private int findSensorEventListenerLocked(SensorEventListener listener) {
        for (int i = 0; i < this.mInputSensorEventListeners.size(); ++i) {
            if (this.mInputSensorEventListeners.get(i).getListener() != listener) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onInputSensorChanged(int deviceId, int sensorType, int accuracy, long timestamp, float[] values) {
        Object object = this.mInputSensorLock;
        synchronized (object) {
            Sensor sensor = this.getInputDeviceSensorLocked(deviceId, sensorType);
            if (sensor == null) {
                Slog.wtf(TAG, "onInputSensorChanged: Got sensor update for device " + deviceId + " but the sensor was not found.");
                return;
            }
            for (int i = 0; i < this.mInputSensorEventListeners.size(); ++i) {
                InputSensorEventListenerDelegate listener = this.mInputSensorEventListeners.get(i);
                if (!listener.hasSensorRegistered(deviceId, sensorType)) continue;
                SensorEvent event = listener.getSensorEvent(sensor);
                if (event == null) {
                    Slog.wtf(TAG, "Failed to get SensorEvent.");
                    return;
                }
                event.sensor = sensor;
                event.accuracy = accuracy;
                event.timestamp = timestamp;
                System.arraycopy(values, 0, event.values, 0, event.values.length);
                listener.sendSensorChanged(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onInputSensorAccuracyChanged(int deviceId, int sensorType, int accuracy) {
        Object object = this.mInputSensorLock;
        synchronized (object) {
            for (int i = 0; i < this.mInputSensorEventListeners.size(); ++i) {
                InputSensorEventListenerDelegate listener = this.mInputSensorEventListeners.get(i);
                if (!listener.hasSensorRegistered(deviceId, sensorType)) continue;
                listener.sendSensorAccuracyChanged(deviceId, sensorType, accuracy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sensor getSensorForInputDevice(int deviceId, int type) {
        Object object = this.mInputSensorLock;
        synchronized (object) {
            for (Map.Entry<Integer, List<Sensor>> entry : this.mSensors.entrySet()) {
                for (Sensor sensor : entry.getValue()) {
                    if (sensor.getId() != deviceId || sensor.getType() != type) continue;
                    return sensor;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Sensor> getFullSensorListForDevice(int deviceId) {
        ArrayList<Sensor> sensors = new ArrayList<Sensor>();
        Object object = this.mInputSensorLock;
        synchronized (object) {
            for (Map.Entry<Integer, List<Sensor>> entry : this.mSensors.entrySet()) {
                for (Sensor sensor : entry.getValue()) {
                    if (sensor.getId() != deviceId) continue;
                    sensors.add(sensor);
                }
            }
        }
        return sensors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerListenerInternal(SensorEventListener listener, Sensor sensor, int delayUs, int maxBatchReportLatencyUs, Handler handler) {
        if (listener == null) {
            Slog.e(TAG, "listener is null");
            return false;
        }
        if (sensor == null) {
            Slog.e(TAG, "sensor is null");
            return false;
        }
        if (sensor.getReportingMode() == 2) {
            Slog.e(TAG, "Trigger Sensors should use the requestTriggerSensor.");
            return false;
        }
        if (maxBatchReportLatencyUs < 0 || delayUs < 0) {
            Slog.e(TAG, "maxBatchReportLatencyUs and delayUs should be non-negative");
            return false;
        }
        Object object = this.mInputSensorLock;
        synchronized (object) {
            int idx;
            if (this.getSensorForInputDevice(sensor.getId(), sensor.getType()) != null) {
                int deviceId = sensor.getId();
                InputDevice inputDevice = this.mGlobal.getInputDevice(deviceId);
                if (inputDevice == null) {
                    Slog.e(TAG, "input device not found for sensor " + sensor.getId());
                    return false;
                }
                if (!inputDevice.hasSensor()) {
                    Slog.e(TAG, "The device doesn't have the sensor:" + sensor);
                    return false;
                }
                if (!this.mGlobal.enableSensor(deviceId, sensor.getType(), delayUs, maxBatchReportLatencyUs)) {
                    Slog.e(TAG, "Can't enable the sensor:" + sensor);
                    return false;
                }
            }
            if (this.mInputServiceSensorListener == null) {
                this.mInputServiceSensorListener = new InputSensorEventListener();
                if (!this.mGlobal.registerSensorListener(this.mInputServiceSensorListener)) {
                    Slog.e(TAG, "Failed registering the sensor listener");
                    return false;
                }
            }
            if ((idx = this.findSensorEventListenerLocked(listener)) < 0) {
                InputSensorEventListenerDelegate d = new InputSensorEventListenerDelegate(listener, sensor, this.getLooperForListenerLocked(handler));
                this.mInputSensorEventListeners.add(d);
            } else {
                this.mInputSensorEventListeners.get(idx).addSensor(sensor);
            }
        }
        return true;
    }

    @GuardedBy(value={"mInputSensorLock"})
    @NonNull
    private Looper getLooperForListenerLocked(@Nullable Handler requestedHandler) {
        if (requestedHandler != null) {
            return requestedHandler.getLooper();
        }
        if (this.mSensorThread == null) {
            this.mSensorThread = new HandlerThread("SensorThread");
            this.mSensorThread.start();
        }
        return this.mSensorThread.getLooper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterListenerInternal(SensorEventListener listener, Sensor sensor) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        Object object = this.mInputSensorLock;
        synchronized (object) {
            ArrayList<Sensor> sensorsRegistered;
            int idx = this.findSensorEventListenerLocked(listener);
            if (idx >= 0) {
                InputSensorEventListenerDelegate delegate = this.mInputSensorEventListeners.get(idx);
                sensorsRegistered = new ArrayList<Sensor>(delegate.getSensors());
                delegate.removeSensor(sensor);
                if (delegate.isEmpty()) {
                    this.mInputSensorEventListeners.remove(idx);
                }
            } else {
                Slog.e(TAG, "Listener is not registered");
                return;
            }
            if (this.mInputServiceSensorListener != null && this.mInputSensorEventListeners.isEmpty()) {
                this.mGlobal.unregisterSensorListener(this.mInputServiceSensorListener);
                this.mInputServiceSensorListener = null;
            }
            for (Sensor s : sensorsRegistered) {
                int deviceId = s.getId();
                int sensorType = s.getType();
                boolean enableSensor = false;
                for (int i = 0; i < this.mInputSensorEventListeners.size(); ++i) {
                    InputSensorEventListenerDelegate delegate = this.mInputSensorEventListeners.get(i);
                    if (!delegate.hasSensorRegistered(deviceId, sensorType)) continue;
                    enableSensor = true;
                    Slog.w(TAG, "device " + deviceId + " still uses sensor " + sensorType);
                    break;
                }
                if (enableSensor) continue;
                this.mGlobal.disableSensor(deviceId, sensorType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flushInternal(SensorEventListener listener) {
        Object object = this.mInputSensorLock;
        synchronized (object) {
            int idx = this.findSensorEventListenerLocked(listener);
            if (idx < 0) {
                return false;
            }
            for (Sensor sensor : this.mInputSensorEventListeners.get(idx).getSensors()) {
                int deviceId = sensor.getId();
                if (this.mGlobal.flushSensor(deviceId, sensor.getType())) continue;
                return false;
            }
            return true;
        }
    }

    public class InputSensorManager
    extends SensorManager {
        final int mId;

        InputSensorManager(int deviceId) {
            this.mId = deviceId;
        }

        @Override
        public Sensor getDefaultSensor(int type) {
            return InputDeviceSensorManager.this.getSensorForInputDevice(this.mId, type);
        }

        @Override
        protected List<Sensor> getFullSensorList() {
            return InputDeviceSensorManager.this.getFullSensorListForDevice(this.mId);
        }

        @Override
        protected List<Sensor> getFullDynamicSensorList() {
            return new ArrayList<Sensor>();
        }

        @Override
        protected boolean registerListenerImpl(SensorEventListener listener, Sensor sensor, int delayUs, Handler handler, int maxBatchReportLatencyUs, int reservedFlags) {
            return InputDeviceSensorManager.this.registerListenerInternal(listener, sensor, delayUs, maxBatchReportLatencyUs, handler);
        }

        @Override
        protected void unregisterListenerImpl(SensorEventListener listener, Sensor sensor) {
            InputDeviceSensorManager.this.unregisterListenerInternal(listener, sensor);
        }

        @Override
        protected boolean flushImpl(SensorEventListener listener) {
            return InputDeviceSensorManager.this.flushInternal(listener);
        }

        @Override
        protected SensorDirectChannel createDirectChannelImpl(MemoryFile memoryFile, HardwareBuffer hardwareBuffer) {
            return null;
        }

        @Override
        protected void destroyDirectChannelImpl(SensorDirectChannel channel) {
        }

        @Override
        protected int configureDirectChannelImpl(SensorDirectChannel channel, Sensor s, int rate) {
            return 0;
        }

        @Override
        protected void registerDynamicSensorCallbackImpl(SensorManager.DynamicSensorCallback callback, Handler handler) {
        }

        @Override
        protected void unregisterDynamicSensorCallbackImpl(SensorManager.DynamicSensorCallback callback) {
        }

        @Override
        protected boolean requestTriggerSensorImpl(TriggerEventListener listener, Sensor sensor) {
            return true;
        }

        @Override
        protected boolean cancelTriggerSensorImpl(TriggerEventListener listener, Sensor sensor, boolean disable) {
            return true;
        }

        @Override
        protected boolean initDataInjectionImpl(boolean enable, int mode) {
            return false;
        }

        @Override
        protected boolean injectSensorDataImpl(Sensor sensor, float[] values, int accuracy, long timestamp) {
            return false;
        }

        @Override
        protected boolean setOperationParameterImpl(SensorAdditionalInfo parameter) {
            return false;
        }
    }

    private static class InputSensorEventListenerDelegate
    extends Handler {
        private final SensorEventListener mListener;
        private final List<Sensor> mSensors = new ArrayList<Sensor>();
        private final SparseArray<SensorEvent> mSensorEvents = new SparseArray();

        InputSensorEventListenerDelegate(SensorEventListener listener, Sensor sensor, Looper looper) {
            super(looper);
            this.mListener = listener;
            this.addSensor(sensor);
        }

        public List<Sensor> getSensors() {
            return this.mSensors;
        }

        public boolean isEmpty() {
            return this.mSensors.isEmpty();
        }

        public void removeSensor(@Nullable Sensor sensor) {
            if (sensor == null) {
                this.mSensors.clear();
                this.mSensorEvents.clear();
                return;
            }
            for (Sensor s : this.mSensors) {
                if (!InputDeviceSensorManager.sensorEquals(s, sensor)) continue;
                this.mSensors.remove(sensor);
                this.mSensorEvents.remove(sensor.getType());
            }
        }

        public void addSensor(@NonNull Sensor sensor) {
            for (Sensor s : this.mSensors) {
                if (!InputDeviceSensorManager.sensorEquals(s, sensor)) continue;
                Slog.w(InputDeviceSensorManager.TAG, "Adding sensor " + sensor + " already exist!");
                return;
            }
            this.mSensors.add(sensor);
            int vecLength = Sensor.getMaxLengthValuesArray(sensor, _Original_Build.VERSION.SDK_INT);
            SensorEvent event = new SensorEvent(sensor, -1, 0L, new float[vecLength]);
            this.mSensorEvents.put(sensor.getType(), event);
        }

        public boolean hasSensorRegistered(int deviceId, int sensorType) {
            for (Sensor sensor : this.mSensors) {
                if (sensor.getType() != sensorType || sensor.getId() != deviceId) continue;
                return true;
            }
            return false;
        }

        public SensorEventListener getListener() {
            return this.mListener;
        }

        private SensorEvent getSensorEvent(@NonNull Sensor sensor) {
            return this.mSensorEvents.get(sensor.getType());
        }

        public void sendSensorChanged(SensorEvent event) {
            this.obtainMessage(2, event).sendToTarget();
        }

        public void sendSensorAccuracyChanged(int deviceId, int sensorType, int accuracy) {
            this.obtainMessage(1, deviceId, sensorType, accuracy).sendToTarget();
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    int deviceId = msg.arg1;
                    int sensorType = msg.arg2;
                    int accuracy = (Integer)msg.obj;
                    for (Sensor sensor : this.mSensors) {
                        if (sensor.getId() != deviceId || sensor.getType() != sensorType) continue;
                        this.mListener.onAccuracyChanged(sensor, accuracy);
                    }
                    break;
                }
                case 2: {
                    SensorEvent event = (SensorEvent)msg.obj;
                    this.mListener.onSensorChanged(event);
                    break;
                }
            }
        }
    }

    private class InputSensorEventListener
    extends IInputSensorEventListener.Stub {
        private InputSensorEventListener() {
        }

        @Override
        public void onInputSensorChanged(int deviceId, int sensorType, int accuracy, long timestamp, float[] values) throws RemoteException {
            InputDeviceSensorManager.this.onInputSensorChanged(deviceId, sensorType, accuracy, timestamp, values);
        }

        @Override
        public void onInputSensorAccuracyChanged(int deviceId, int sensorType, int accuracy) throws RemoteException {
            InputDeviceSensorManager.this.onInputSensorAccuracyChanged(deviceId, sensorType, accuracy);
        }
    }
}

