/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.hardware.input.PhysicalKeyLayout;
import android.util.Slog;
import android.util.TypedValue;
import com.android.layoutlib.androidx.annotation.NonNull;
import com.android.layoutlib.androidx.annotation.Nullable;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;

class KeyboardLayoutPreviewDrawable
extends Drawable {
    private static final String TAG = "KeyboardLayoutPreview";
    private static final int GRAVITY_LEFT = 1;
    private static final int GRAVITY_RIGHT = 2;
    private static final int GRAVITY_TOP = 4;
    private static final int GRAVITY_BOTTOM = 8;
    private static final int TEXT_PADDING_IN_DP = 1;
    private static final int KEY_PADDING_IN_DP = 3;
    private static final int KEYBOARD_PADDING_IN_DP = 10;
    private static final int KEY_RADIUS_IN_DP = 5;
    private static final int KEYBOARD_RADIUS_IN_DP = 10;
    private static final int MIN_GLYPH_TEXT_SIZE_IN_SP = 10;
    private static final int MAX_GLYPH_TEXT_SIZE_IN_SP = 20;
    private final List<KeyDrawable> mKeyDrawables = new ArrayList<KeyDrawable>();
    private final int mWidth;
    private final int mHeight;
    private final RectF mKeyboardBackground = new RectF();
    private final ResourceProvider mResourceProvider;
    private final PhysicalKeyLayout mKeyLayout;

    public KeyboardLayoutPreviewDrawable(Context context, PhysicalKeyLayout keyLayout, int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        this.mResourceProvider = new ResourceProvider(context);
        this.mKeyLayout = keyLayout;
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mWidth;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mHeight;
    }

    @Override
    protected void onBoundsChange(@NonNull Rect bounds) {
        super.onBoundsChange(bounds);
        this.mKeyDrawables.clear();
        PhysicalKeyLayout.LayoutKey[][] keys = this.mKeyLayout.getKeys();
        if (keys == null) {
            return;
        }
        PhysicalKeyLayout.EnterKey enterKey = this.mKeyLayout.getEnterKey();
        int width = bounds.width();
        int height = bounds.height();
        int keyboardPadding = this.mResourceProvider.getKeyboardPadding();
        int keyPadding = this.mResourceProvider.getKeyPadding();
        float keyRadius = this.mResourceProvider.getKeyRadius();
        this.mKeyboardBackground.set(0.0f, 0.0f, width, height);
        if ((width -= keyboardPadding * 2) <= 0 || (height -= keyboardPadding * 2) <= 0) {
            Slog.e(TAG, "Invalid width and height to draw layout preview, width = " + width + ", height = " + height);
            return;
        }
        int rowCount = keys.length;
        float keyHeight = (float)(height - rowCount * 2 * keyPadding) / (float)rowCount;
        this.mResourceProvider.calculateBestTextSizeForKey(keyHeight);
        float isoEnterKeyLeft = 0.0f;
        float isoEnterKeyTop = 0.0f;
        float isoEnterWidthUnit = 0.0f;
        for (int i = 0; i < rowCount; ++i) {
            PhysicalKeyLayout.LayoutKey[] row = keys[i];
            float totalRowWeight = 0.0f;
            int keysInRow = row.length;
            for (PhysicalKeyLayout.LayoutKey layoutKey : row) {
                totalRowWeight += layoutKey.keyWeight();
            }
            float keyWidthInPx = (float)(width - keysInRow * 2 * keyPadding) / totalRowWeight;
            float rowWeightOnLeft = 0.0f;
            float top = (float)(keyboardPadding + keyPadding * (2 * i + 1)) + (float)i * keyHeight;
            for (int j = 0; j < keysInRow; ++j) {
                float left = (float)(keyboardPadding + keyPadding * (2 * j + 1)) + rowWeightOnLeft * keyWidthInPx;
                rowWeightOnLeft += row[j].keyWeight();
                RectF keyRect = new RectF(left, top, left + keyWidthInPx * row[j].keyWeight(), top + keyHeight);
                if (enterKey != null && row[j].keyCode() == 66) {
                    if (enterKey.row() != i || enterKey.column() != j) continue;
                    isoEnterKeyLeft = keyRect.left;
                    isoEnterKeyTop = keyRect.top;
                    isoEnterWidthUnit = keyWidthInPx;
                    continue;
                }
                if (PhysicalKeyLayout.isSpecialKey(row[j])) {
                    this.mKeyDrawables.add(new TypingKey(null, keyRect, keyRadius, this.mResourceProvider.getTextPadding(), this.mResourceProvider.getSpecialKeyPaint(), this.mResourceProvider.getSpecialKeyPaint(), this.mResourceProvider.getSpecialKeyPaint()));
                    continue;
                }
                if (PhysicalKeyLayout.isKeyPositionUnsure(row[j])) {
                    this.mKeyDrawables.add(new UnsureTypingKey(row[j].glyph(), keyRect, keyRadius, this.mResourceProvider.getTextPadding(), this.mResourceProvider.getTypingKeyPaint(), this.mResourceProvider.getPrimaryGlyphPaint(), this.mResourceProvider.getSecondaryGlyphPaint()));
                    continue;
                }
                this.mKeyDrawables.add(new TypingKey(row[j].glyph(), keyRect, keyRadius, this.mResourceProvider.getTextPadding(), this.mResourceProvider.getTypingKeyPaint(), this.mResourceProvider.getPrimaryGlyphPaint(), this.mResourceProvider.getSecondaryGlyphPaint()));
            }
        }
        if (enterKey != null) {
            IsoEnterKey.Builder isoEnterKeyBuilder = new IsoEnterKey.Builder(keyRadius, this.mResourceProvider.getSpecialKeyPaint());
            isoEnterKeyBuilder.setTopWidth(enterKey.topKeyWeight() * isoEnterWidthUnit).setStartPoint(isoEnterKeyLeft, isoEnterKeyTop).setVerticalEdges(keyHeight, 2.0f * (keyHeight + (float)keyPadding)).setBottomWidth(enterKey.bottomKeyWeight() * isoEnterWidthUnit);
            this.mKeyDrawables.add(isoEnterKeyBuilder.build());
        }
    }

    @Override
    public void draw(Canvas canvas) {
        float keyboardRadius = this.mResourceProvider.getBackgroundRadius();
        canvas.drawRoundRect(this.mKeyboardBackground, keyboardRadius, keyboardRadius, this.mResourceProvider.getBackgroundPaint());
        for (KeyDrawable key : this.mKeyDrawables) {
            key.draw(canvas);
        }
    }

    @Override
    public void setAlpha(int alpha) {
    }

    @Override
    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    @Override
    public int getOpacity() {
        return -1;
    }

    private static Paint createTextPaint(int textColor, float textSize, Typeface typeface) {
        Paint paint = new Paint();
        paint.setColor(textColor);
        paint.setStyle(Paint.Style.FILL);
        paint.setTextSize(textSize);
        paint.setTypeface(typeface);
        return paint;
    }

    private static Paint createFillPaint(int color2) {
        Paint paint = new Paint();
        paint.setColor(color2);
        paint.setStyle(Paint.Style.FILL);
        return paint;
    }

    private static Paint createGreyedOutPaint(Paint paint) {
        Paint result = new Paint(paint);
        result.setAlpha(100);
        return result;
    }

    private static class ResourceProvider {
        private final Paint mBackgroundPaint;
        private final Paint mTypingKeyPaint;
        private final Paint mSpecialKeyPaint;
        private final Paint mPrimaryGlyphPaint;
        private final Paint mSecondaryGlyphPaint;
        private final int mKeyPadding;
        private final int mKeyboardPadding;
        private final float mTextPadding;
        private final float mKeyRadius;
        private final float mBackgroundRadius;
        private final float mSpToPxMultiplier;
        private final Paint.FontMetrics mFontMetrics;

        private ResourceProvider(Context context) {
            this.mKeyPadding = (int)TypedValue.applyDimension(1, 3.0f, context.getResources().getDisplayMetrics());
            this.mKeyboardPadding = (int)TypedValue.applyDimension(1, 10.0f, context.getResources().getDisplayMetrics());
            this.mKeyRadius = (int)TypedValue.applyDimension(1, 5.0f, context.getResources().getDisplayMetrics());
            this.mBackgroundRadius = (int)TypedValue.applyDimension(1, 10.0f, context.getResources().getDisplayMetrics());
            this.mSpToPxMultiplier = TypedValue.applyDimension(2, 1.0f, context.getResources().getDisplayMetrics());
            this.mTextPadding = TypedValue.applyDimension(1, 1.0f, context.getResources().getDisplayMetrics());
            boolean isDark = (context.getResources().getConfiguration().uiMode & 0x30) == 32;
            int typingKeyColor = context.getColor(isDark ? 17170625 : 17170543);
            int specialKeyColor = context.getColor(isDark ? 17170471 : 17170530);
            int primaryGlyphColor = context.getColor(isDark ? 17170584 : 17170541);
            int secondaryGlyphColor = context.getColor(isDark ? 17170594 : 17170551);
            int backgroundColor = context.getColor(isDark ? 17170587 : 17170544);
            this.mPrimaryGlyphPaint = KeyboardLayoutPreviewDrawable.createTextPaint(primaryGlyphColor, 10.0f * this.mSpToPxMultiplier, Typeface.create(Typeface.SANS_SERIF, 1));
            this.mSecondaryGlyphPaint = KeyboardLayoutPreviewDrawable.createTextPaint(secondaryGlyphColor, 10.0f * this.mSpToPxMultiplier, Typeface.create(Typeface.SANS_SERIF, 0));
            this.mFontMetrics = this.mPrimaryGlyphPaint.getFontMetrics();
            this.mTypingKeyPaint = KeyboardLayoutPreviewDrawable.createFillPaint(typingKeyColor);
            this.mSpecialKeyPaint = KeyboardLayoutPreviewDrawable.createFillPaint(specialKeyColor);
            this.mBackgroundPaint = KeyboardLayoutPreviewDrawable.createFillPaint(backgroundColor);
        }

        private void calculateBestTextSizeForKey(float keyHeight) {
            int textSize = (int)(this.mSpToPxMultiplier * 10.0f) + 1;
            while ((float)textSize < this.mSpToPxMultiplier * 20.0f) {
                this.updateTextSize(textSize);
                if (this.mFontMetrics.bottom - this.mFontMetrics.top + 3.0f * this.mTextPadding > keyHeight / 2.0f) {
                    --textSize;
                    break;
                }
                ++textSize;
            }
            this.updateTextSize(textSize);
        }

        private void updateTextSize(float textSize) {
            this.mPrimaryGlyphPaint.setTextSize(textSize);
            this.mSecondaryGlyphPaint.setTextSize(textSize);
            this.mPrimaryGlyphPaint.getFontMetrics(this.mFontMetrics);
        }

        private Paint getBackgroundPaint() {
            return this.mBackgroundPaint;
        }

        private Paint getTypingKeyPaint() {
            return this.mTypingKeyPaint;
        }

        private Paint getSpecialKeyPaint() {
            return this.mSpecialKeyPaint;
        }

        private Paint getPrimaryGlyphPaint() {
            return this.mPrimaryGlyphPaint;
        }

        private Paint getSecondaryGlyphPaint() {
            return this.mSecondaryGlyphPaint;
        }

        private int getKeyPadding() {
            return this.mKeyPadding;
        }

        private int getKeyboardPadding() {
            return this.mKeyboardPadding;
        }

        private float getTextPadding() {
            return this.mTextPadding;
        }

        private float getKeyRadius() {
            return this.mKeyRadius;
        }

        private float getBackgroundRadius() {
            return this.mBackgroundRadius;
        }
    }

    private static class TypingKey
    implements KeyDrawable {
        private final RectF mKeyRect;
        private final float mKeyRadius;
        private final float mTextPadding;
        private final Paint mKeyPaint;
        private final Paint mBaseTextPaint;
        private final Paint mModifierTextPaint;
        private final List<GlyphDrawable> mGlyphDrawables = new ArrayList<GlyphDrawable>();

        private TypingKey(@Nullable PhysicalKeyLayout.KeyGlyph glyphData, RectF keyRect, float keyRadius, float textPadding, Paint keyPaint, Paint baseTextPaint, Paint modifierTextPaint) {
            this.mKeyRect = keyRect;
            this.mKeyRadius = keyRadius;
            this.mTextPadding = textPadding;
            this.mKeyPaint = keyPaint;
            this.mBaseTextPaint = baseTextPaint;
            this.mModifierTextPaint = modifierTextPaint;
            this.initGlyphs(glyphData);
        }

        private void initGlyphs(@Nullable PhysicalKeyLayout.KeyGlyph glyphData) {
            this.createGlyphs(glyphData);
            this.measureGlyphs();
        }

        private void createGlyphs(@Nullable PhysicalKeyLayout.KeyGlyph glyphData) {
            if (glyphData == null) {
                return;
            }
            if (!glyphData.hasBaseText()) {
                return;
            }
            this.mGlyphDrawables.add(new GlyphDrawable(glyphData.getBaseText(), new RectF(), 9, this.mBaseTextPaint));
            if (glyphData.hasValidShiftText()) {
                this.mGlyphDrawables.add(new GlyphDrawable(glyphData.getShiftText(), new RectF(), 5, this.mModifierTextPaint));
            }
            if (glyphData.hasValidAltGrText()) {
                this.mGlyphDrawables.add(new GlyphDrawable(glyphData.getAltGrText(), new RectF(), 10, this.mModifierTextPaint));
            }
            if (glyphData.hasValidAltGrShiftText()) {
                this.mGlyphDrawables.add(new GlyphDrawable(glyphData.getAltGrShiftText(), new RectF(), 6, this.mModifierTextPaint));
            }
        }

        private void measureGlyphs() {
            float keyWidth = this.mKeyRect.width();
            float keyHeight = this.mKeyRect.height();
            for (GlyphDrawable glyph : this.mGlyphDrawables) {
                float centerX = keyWidth / 2.0f;
                float centerY = keyHeight / 2.0f;
                if ((glyph.gravity & 1) != 0) {
                    centerX -= keyWidth / 4.0f;
                    centerX += this.mTextPadding / 2.0f;
                }
                if ((glyph.gravity & 2) != 0) {
                    centerX += keyWidth / 4.0f;
                    centerX -= this.mTextPadding / 2.0f;
                }
                if ((glyph.gravity & 4) != 0) {
                    centerY -= keyHeight / 4.0f;
                    centerY += this.mTextPadding / 2.0f;
                }
                if ((glyph.gravity & 8) != 0) {
                    centerY += keyHeight / 4.0f;
                    centerY -= this.mTextPadding / 2.0f;
                }
                Rect textBounds = new Rect();
                glyph.paint.getTextBounds(glyph.text, 0, glyph.text.length(), textBounds);
                float textWidth = textBounds.width();
                float textHeight = textBounds.height();
                glyph.rect.set(centerX - textWidth / 2.0f, centerY - textHeight / 2.0f - (float)textBounds.top, centerX + textWidth / 2.0f, centerY + textHeight / 2.0f - (float)textBounds.top);
            }
        }

        @Override
        public void draw(Canvas canvas) {
            canvas.drawRoundRect(this.mKeyRect, this.mKeyRadius, this.mKeyRadius, this.mKeyPaint);
            for (GlyphDrawable glyph : this.mGlyphDrawables) {
                float textWidth = glyph.rect.width();
                float textHeight = glyph.rect.height();
                float keyWidth = this.mKeyRect.width();
                float keyHeight = this.mKeyRect.height();
                if (textWidth == 0.0f || textHeight == 0.0f || keyWidth == 0.0f || keyHeight == 0.0f) {
                    return;
                }
                canvas.drawText(glyph.text, 0, glyph.text.length(), this.mKeyRect.left + glyph.rect.left, this.mKeyRect.top + glyph.rect.top, glyph.paint);
            }
        }
    }

    private static class UnsureTypingKey
    extends TypingKey {
        private UnsureTypingKey(@Nullable PhysicalKeyLayout.KeyGlyph glyphData, RectF keyRect, float keyRadius, float textPadding, Paint keyPaint, Paint baseTextPaint, Paint modifierTextPaint) {
            super(glyphData, keyRect, keyRadius, textPadding, KeyboardLayoutPreviewDrawable.createGreyedOutPaint(keyPaint), KeyboardLayoutPreviewDrawable.createGreyedOutPaint(baseTextPaint), KeyboardLayoutPreviewDrawable.createGreyedOutPaint(modifierTextPaint));
        }
    }

    private static class IsoEnterKey
    implements KeyDrawable {
        private final Paint mKeyPaint;
        private final Path mPath;

        private IsoEnterKey(Paint keyPaint, @NonNull Path path) {
            this.mKeyPaint = keyPaint;
            this.mPath = path;
        }

        @Override
        public void draw(Canvas canvas) {
            canvas.drawPath(this.mPath, this.mKeyPaint);
        }

        private static class Builder {
            private final float mKeyRadius;
            private final Paint mKeyPaint;
            private float mLeft;
            private float mTop;
            private float mTopWidth;
            private float mBottomWidth;
            private float mLeftHeight;
            private float mRightHeight;

            private Builder(float keyRadius, Paint keyPaint) {
                this.mKeyRadius = keyRadius;
                this.mKeyPaint = keyPaint;
            }

            private Builder setStartPoint(float left, float top) {
                this.mLeft = left;
                this.mTop = top;
                return this;
            }

            private Builder setTopWidth(float width) {
                this.mTopWidth = width;
                return this;
            }

            private Builder setBottomWidth(float width) {
                this.mBottomWidth = width;
                return this;
            }

            private Builder setVerticalEdges(float leftHeight, float rightHeight) {
                this.mLeftHeight = leftHeight;
                this.mRightHeight = rightHeight;
                return this;
            }

            private IsoEnterKey build() {
                Path enterKey = new Path();
                RectF oval = new RectF(-this.mKeyRadius, -this.mKeyRadius, this.mKeyRadius, this.mKeyRadius);
                enterKey.moveTo(this.mLeft + this.mKeyRadius, this.mTop);
                enterKey.lineTo(this.mLeft + this.mTopWidth - this.mKeyRadius, this.mTop);
                oval.offsetTo(this.mLeft + this.mTopWidth - 2.0f * this.mKeyRadius, this.mTop);
                enterKey.arcTo(oval, 270.0f, 90.0f);
                enterKey.lineTo(this.mLeft + this.mTopWidth, this.mTop + this.mRightHeight - this.mKeyRadius);
                oval.offsetTo(this.mLeft + this.mTopWidth - 2.0f * this.mKeyRadius, this.mTop + this.mRightHeight - 2.0f * this.mKeyRadius);
                enterKey.arcTo(oval, 0.0f, 90.0f);
                enterKey.lineTo(this.mLeft + this.mTopWidth - this.mBottomWidth + this.mKeyRadius, this.mTop + this.mRightHeight);
                oval.offsetTo(this.mLeft + this.mTopWidth - this.mBottomWidth, this.mTop + this.mRightHeight - 2.0f * this.mKeyRadius);
                enterKey.arcTo(oval, 90.0f, 90.0f);
                enterKey.lineTo(this.mLeft + this.mTopWidth - this.mBottomWidth, this.mTop + this.mLeftHeight - this.mKeyRadius);
                oval.offsetTo(this.mLeft + this.mTopWidth - this.mBottomWidth - 2.0f * this.mKeyRadius, this.mTop + this.mLeftHeight);
                enterKey.arcTo(oval, 0.0f, -90.0f);
                enterKey.lineTo(this.mLeft + this.mKeyRadius, this.mTop + this.mLeftHeight);
                oval.offsetTo(this.mLeft, this.mTop + this.mLeftHeight - 2.0f * this.mKeyRadius);
                enterKey.arcTo(oval, 90.0f, 90.0f);
                enterKey.lineTo(this.mLeft, this.mTop + this.mKeyRadius);
                oval.offsetTo(this.mLeft, this.mTop);
                enterKey.arcTo(oval, 180.0f, 90.0f);
                enterKey.close();
                return new IsoEnterKey(this.mKeyPaint, enterKey);
            }
        }
    }

    private static interface KeyDrawable {
        public void draw(Canvas var1);
    }

    private static class GlyphDrawable
    extends Record {
        private final String text;
        private final RectF rect;
        private final int gravity;
        private final Paint paint;

        private GlyphDrawable(String text, RectF rect, int gravity, Paint paint) {
            this.text = text;
            this.rect = rect;
            this.gravity = gravity;
            this.paint = paint;
        }

        @Override
        public String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{GlyphDrawable.class, "text;rect;gravity;paint", "text", "rect", "gravity", "paint"}, this);
        }

        @Override
        public int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{GlyphDrawable.class, "text;rect;gravity;paint", "text", "rect", "gravity", "paint"}, this);
        }

        @Override
        public boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{GlyphDrawable.class, "text;rect;gravity;paint", "text", "rect", "gravity", "paint"}, this, o);
        }

        public String text() {
            return this.text;
        }

        public RectF rect() {
            return this.rect;
        }

        public int gravity() {
            return this.gravity;
        }

        public Paint paint() {
            return this.paint;
        }
    }
}

