/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.hardware.input.IVirtualInputDevice;
import android.hardware.input.VirtualDpadConfig;
import android.hardware.input.VirtualInputDevice;
import android.hardware.input.VirtualKeyEvent;
import android.os.RemoteException;
import android.util.Log;
import java.util.Set;

@SystemApi
public class VirtualDpad
extends VirtualInputDevice {
    private static final Set<Integer> SUPPORTED_KEY_CODES = Set.of(Integer.valueOf(4), Integer.valueOf(19), Integer.valueOf(20), Integer.valueOf(21), Integer.valueOf(22), Integer.valueOf(23));

    public VirtualDpad(VirtualDpadConfig config, IVirtualInputDevice virtualInputDevice) {
        super(config, virtualInputDevice);
    }

    public void sendKeyEvent(@NonNull VirtualKeyEvent event) {
        try {
            if (!SUPPORTED_KEY_CODES.contains(event.getKeyCode())) {
                throw new IllegalArgumentException("Unsupported key code " + event.getKeyCode() + " sent to a VirtualDpad input device.");
            }
            if (!this.mVirtualInputDevice.sendDpadKeyEvent(event)) {
                Log.w("VirtualInputDevice", "Failed to send key event to virtual dpad " + this.mConfig.getInputDeviceName());
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isKeyCodeSupported(int keyCode) {
        return SUPPORTED_KEY_CODES.contains(keyCode);
    }
}

