/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

@SystemApi
public abstract class VirtualInputDeviceConfig {
    private static final int DEVICE_NAME_MAX_LENGTH = 80;
    private final int mVendorId;
    private final int mProductId;
    private final int mAssociatedDisplayId;
    @NonNull
    private final String mInputDeviceName;

    protected VirtualInputDeviceConfig(@NonNull Builder<? extends Builder<?>> builder) {
        this.mVendorId = builder.mVendorId;
        this.mProductId = builder.mProductId;
        this.mAssociatedDisplayId = builder.mAssociatedDisplayId;
        this.mInputDeviceName = Objects.requireNonNull(builder.mInputDeviceName, "Missing device name");
        if (this.mAssociatedDisplayId == -1) {
            throw new IllegalArgumentException("Display association is required for virtual input devices.");
        }
        if (this.mInputDeviceName.getBytes(StandardCharsets.UTF_8).length >= 80) {
            throw new IllegalArgumentException("Input device name exceeds maximum length of 80bytes: " + this.mInputDeviceName);
        }
    }

    protected VirtualInputDeviceConfig(@NonNull Parcel in) {
        this.mVendorId = in.readInt();
        this.mProductId = in.readInt();
        this.mAssociatedDisplayId = in.readInt();
        this.mInputDeviceName = Objects.requireNonNull(in.readString8(), "Missing device name");
    }

    public int getVendorId() {
        return this.mVendorId;
    }

    public int getProductId() {
        return this.mProductId;
    }

    public int getAssociatedDisplayId() {
        return this.mAssociatedDisplayId;
    }

    @NonNull
    public String getInputDeviceName() {
        return this.mInputDeviceName;
    }

    void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mVendorId);
        dest.writeInt(this.mProductId);
        dest.writeInt(this.mAssociatedDisplayId);
        dest.writeString8(this.mInputDeviceName);
    }

    public String toString() {
        return this.getClass().getName() + "(  name=" + this.mInputDeviceName + " vendorId=" + this.mVendorId + " productId=" + this.mProductId + " associatedDisplayId=" + this.mAssociatedDisplayId + this.additionalFieldsToString() + ")";
    }

    @NonNull
    String additionalFieldsToString() {
        return "";
    }

    public static abstract class Builder<T extends Builder<T>> {
        private int mVendorId;
        private int mProductId;
        private int mAssociatedDisplayId = -1;
        private String mInputDeviceName;

        @NonNull
        public T setVendorId(int vendorId) {
            this.mVendorId = vendorId;
            return this.self();
        }

        @NonNull
        public T setProductId(int productId) {
            this.mProductId = productId;
            return this.self();
        }

        @NonNull
        public T setAssociatedDisplayId(int displayId) {
            this.mAssociatedDisplayId = displayId;
            return this.self();
        }

        @NonNull
        public T setInputDeviceName(@NonNull String deviceName) {
            this.mInputDeviceName = Objects.requireNonNull(deviceName);
            return this.self();
        }

        T self() {
            return (T)this;
        }
    }
}

