/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.graphics.PointF;
import android.hardware.input.IVirtualInputDevice;
import android.hardware.input.VirtualInputDevice;
import android.hardware.input.VirtualMouseButtonEvent;
import android.hardware.input.VirtualMouseConfig;
import android.hardware.input.VirtualMouseRelativeEvent;
import android.hardware.input.VirtualMouseScrollEvent;
import android.os.RemoteException;
import android.util.Log;

@SystemApi
public class VirtualMouse
extends VirtualInputDevice {
    public VirtualMouse(VirtualMouseConfig config, IVirtualInputDevice virtualInputDevice) {
        super(config, virtualInputDevice);
    }

    public void sendButtonEvent(@NonNull VirtualMouseButtonEvent event) {
        try {
            if (!this.mVirtualInputDevice.sendMouseButtonEvent(event)) {
                Log.w("VirtualInputDevice", "Failed to send button event to virtual mouse " + this.mConfig.getInputDeviceName());
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void sendScrollEvent(@NonNull VirtualMouseScrollEvent event) {
        try {
            if (!this.mVirtualInputDevice.sendMouseScrollEvent(event)) {
                Log.w("VirtualInputDevice", "Failed to send scroll event to virtual mouse " + this.mConfig.getInputDeviceName());
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void sendRelativeEvent(@NonNull VirtualMouseRelativeEvent event) {
        try {
            if (!this.mVirtualInputDevice.sendMouseRelativeEvent(event)) {
                Log.w("VirtualInputDevice", "Failed to send relative event to virtual mouse " + this.mConfig.getInputDeviceName());
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public PointF getCursorPosition() {
        try {
            PointF cursorPosition = this.mVirtualInputDevice.getCursorPosition();
            return cursorPosition != null ? cursorPosition : new PointF(Float.NaN, Float.NaN);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

