/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.lights;

import android.annotation.NonNull;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;

public class LightState
implements Parcelable {
    private final int mColor;
    private final int mPlayerId;
    @NonNull
    public static final Parcelable.Creator<LightState> CREATOR = new Parcelable.Creator<LightState>(){

        @Override
        public LightState createFromParcel(Parcel in) {
            return new LightState(in);
        }

        public LightState[] newArray(int size) {
            return new LightState[size];
        }
    };

    @Deprecated
    @SystemApi
    public LightState(int color2) {
        this(color2, 0);
    }

    public LightState(int color2, int playerId) {
        this.mColor = color2;
        this.mPlayerId = playerId;
    }

    private LightState(@NonNull Parcel in) {
        this.mColor = in.readInt();
        this.mPlayerId = in.readInt();
    }

    public int getColor() {
        return this.mColor;
    }

    public int getPlayerId() {
        return this.mPlayerId;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mColor);
        dest.writeInt(this.mPlayerId);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "LightState{Color=0x" + Integer.toHexString(this.mColor) + ", PlayerId=" + this.mPlayerId + "}";
    }

    public static class Builder {
        private int mValue = 0;
        private boolean mIsForPlayerId = false;

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @NonNull
        public Builder setColor(int color2) {
            this.mIsForPlayerId = false;
            this.mValue = color2;
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @NonNull
        public Builder setPlayerId(int playerId) {
            this.mIsForPlayerId = true;
            this.mValue = playerId;
            return this;
        }

        @NonNull
        public LightState build() {
            if (!this.mIsForPlayerId) {
                return new LightState(this.mValue, 0);
            }
            return new LightState(0, this.mValue);
        }
    }
}

