/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.lights;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.hardware.lights.Light;
import android.hardware.lights.LightState;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LightsRequest {
    final Map<Light, LightState> mRequests = new HashMap<Light, LightState>();
    final List<Integer> mLightIds = new ArrayList<Integer>();
    final List<LightState> mLightStates = new ArrayList<LightState>();

    private LightsRequest(Map<Light, LightState> requests) {
        this.mRequests.putAll(requests);
        ArrayList<Light> lights = new ArrayList<Light>(this.mRequests.keySet());
        for (int i = 0; i < lights.size(); ++i) {
            Light light = (Light)lights.get(i);
            this.mLightIds.add(i, light.getId());
            this.mLightStates.add(i, this.mRequests.get(light));
        }
    }

    @NonNull
    public List<Integer> getLights() {
        return this.mLightIds;
    }

    @NonNull
    public List<LightState> getLightStates() {
        return this.mLightStates;
    }

    @NonNull
    public Map<Light, LightState> getLightsAndStates() {
        return this.mRequests;
    }

    public static class Builder {
        final Map<Light, LightState> mChanges = new HashMap<Light, LightState>();

        @NonNull
        public Builder addLight(@NonNull Light light, @NonNull LightState state) {
            Preconditions.checkNotNull(light);
            Preconditions.checkNotNull(state);
            this.mChanges.put(light, state);
            return this;
        }

        @SystemApi
        @Deprecated
        @NonNull
        public Builder setLight(@NonNull Light light, @NonNull LightState state) {
            return this.addLight(light, state);
        }

        @NonNull
        public Builder clearLight(@NonNull Light light) {
            Preconditions.checkNotNull(light);
            this.mChanges.put(light, null);
            return this;
        }

        @NonNull
        public LightsRequest build() {
            return new LightsRequest(this.mChanges);
        }
    }
}

