/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.hardware.location.ContextHubInfo;
import android.hardware.location.VendorHubInfo;
import android.os.BadParcelableException;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@FlaggedApi(value="android.chre.flags.offload_api")
public class HubInfo
implements Parcelable {
    public static final int TYPE_CONTEXT_HUB = 0;
    public static final int TYPE_VENDOR_HUB = 1;
    private final long mId;
    private final int mType;
    @Nullable
    private final ContextHubInfo mContextHubInfo;
    @Nullable
    private final VendorHubInfo mVendorHubInfo;
    @NonNull
    public static final Parcelable.Creator<HubInfo> CREATOR = new Parcelable.Creator<HubInfo>(){

        @Override
        public HubInfo createFromParcel(Parcel in) {
            return new HubInfo(in);
        }

        public HubInfo[] newArray(int size) {
            return new HubInfo[size];
        }
    };

    public HubInfo(long id2, @NonNull ContextHubInfo contextHubInfo) {
        this.mId = id2;
        this.mType = 0;
        this.mContextHubInfo = contextHubInfo;
        this.mVendorHubInfo = null;
    }

    public HubInfo(long id2, @NonNull VendorHubInfo vendorHubInfo) {
        this.mId = id2;
        this.mType = 1;
        this.mContextHubInfo = null;
        this.mVendorHubInfo = vendorHubInfo;
    }

    private HubInfo(Parcel in) {
        this.mId = in.readLong();
        this.mType = in.readInt();
        switch (this.mType) {
            case 0: {
                this.mContextHubInfo = ContextHubInfo.CREATOR.createFromParcel(in);
                this.mVendorHubInfo = null;
                break;
            }
            case 1: {
                this.mVendorHubInfo = VendorHubInfo.CREATOR.createFromParcel(in);
                this.mContextHubInfo = null;
                break;
            }
            default: {
                throw new BadParcelableException("Parcelable has invalid type");
            }
        }
    }

    public long getId() {
        return this.mId;
    }

    public int getType() {
        return this.mType;
    }

    @Nullable
    public ContextHubInfo getContextHubInfo() {
        return this.mContextHubInfo;
    }

    @Override
    public int describeContents() {
        if (this.mType == 0 && this.mContextHubInfo != null) {
            return this.mContextHubInfo.describeContents();
        }
        if (this.mType == 1 && this.mVendorHubInfo != null) {
            return this.mVendorHubInfo.describeContents();
        }
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeLong(this.mId);
        out.writeInt(this.mType);
        if (this.mType == 0 && this.mContextHubInfo != null) {
            this.mContextHubInfo.writeToParcel(out, flags);
        }
        if (this.mType == 1 && this.mVendorHubInfo != null) {
            this.mVendorHubInfo.writeToParcel(out, flags);
        }
    }

    @NonNull
    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("HubInfo ID: 0x");
        out.append(Long.toHexString(this.mId));
        out.append("\n");
        if (this.mType == 0 && this.mContextHubInfo != null) {
            out.append(" ContextHubDetails: ");
            out.append(this.mContextHubInfo);
        }
        if (this.mType == 1 && this.mVendorHubInfo != null) {
            out.append(" VendorHubDetails: ");
            out.append(this.mVendorHubInfo);
        }
        return out.toString();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface HubType {
    }
}

