/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.hidden_from_bootclasspath.android.chre.flags.Flags;
import java.util.Arrays;
import java.util.Objects;
import libcore.util.HexEncoding;

@SystemApi
public class NanoAppMessage
implements Parcelable {
    private static final int DEBUG_LOG_NUM_BYTES = 16;
    private long mNanoAppId;
    private int mMessageType;
    private byte[] mMessageBody;
    private boolean mIsBroadcasted;
    private boolean mIsReliable;
    private int mMessageSequenceNumber;
    @NonNull
    public static final Parcelable.Creator<NanoAppMessage> CREATOR = new Parcelable.Creator<NanoAppMessage>(){

        @Override
        public NanoAppMessage createFromParcel(Parcel in) {
            return new NanoAppMessage(in);
        }

        public NanoAppMessage[] newArray(int size) {
            return new NanoAppMessage[size];
        }
    };

    private NanoAppMessage(long nanoAppId, int messageType, byte[] messageBody, boolean broadcasted, boolean isReliable, int messageSequenceNumber) {
        this.mNanoAppId = nanoAppId;
        this.mMessageType = messageType;
        this.mMessageBody = messageBody;
        this.mIsBroadcasted = broadcasted;
        this.mIsReliable = isReliable;
        this.mMessageSequenceNumber = messageSequenceNumber;
    }

    public static NanoAppMessage createMessageToNanoApp(long targetNanoAppId, int messageType, byte[] messageBody) {
        return new NanoAppMessage(targetNanoAppId, messageType, messageBody, false, false, 0);
    }

    public static NanoAppMessage createMessageFromNanoApp(long sourceNanoAppId, int messageType, byte[] messageBody, boolean broadcasted) {
        return new NanoAppMessage(sourceNanoAppId, messageType, messageBody, broadcasted, false, 0);
    }

    @NonNull
    public static NanoAppMessage createMessageFromNanoApp(long sourceNanoAppId, int messageType, @NonNull byte[] messageBody, boolean broadcasted, boolean isReliable, int messageSequenceNumber) {
        return new NanoAppMessage(sourceNanoAppId, messageType, messageBody, broadcasted, isReliable, messageSequenceNumber);
    }

    public long getNanoAppId() {
        return this.mNanoAppId;
    }

    public int getMessageType() {
        return this.mMessageType;
    }

    public byte[] getMessageBody() {
        return this.mMessageBody;
    }

    public boolean isBroadcastMessage() {
        return this.mIsBroadcasted;
    }

    public boolean isReliable() {
        return this.mIsReliable;
    }

    public int getMessageSequenceNumber() {
        return this.mMessageSequenceNumber;
    }

    public void setIsReliable(boolean isReliable) {
        this.mIsReliable = isReliable;
    }

    public void setMessageSequenceNumber(int messageSequenceNumber) {
        this.mMessageSequenceNumber = messageSequenceNumber;
    }

    private NanoAppMessage(Parcel in) {
        this.mNanoAppId = in.readLong();
        this.mIsBroadcasted = in.readInt() == 1;
        this.mMessageType = in.readInt();
        int msgSize = in.readInt();
        this.mMessageBody = new byte[msgSize];
        in.readByteArray(this.mMessageBody);
        this.mIsReliable = in.readInt() == 1;
        this.mMessageSequenceNumber = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeLong(this.mNanoAppId);
        out.writeInt(this.mIsBroadcasted ? 1 : 0);
        out.writeInt(this.mMessageType);
        out.writeInt(this.mMessageBody.length);
        out.writeByteArray(this.mMessageBody);
        out.writeInt(this.mIsReliable ? 1 : 0);
        out.writeInt(this.mMessageSequenceNumber);
    }

    @NonNull
    public String toString() {
        int length = this.mMessageBody.length;
        StringBuilder out = new StringBuilder();
        out.append("NanoAppMessage[type = ");
        out.append(this.mMessageType);
        out.append(", length = ");
        out.append(this.mMessageBody.length);
        out.append(" bytes, ");
        out.append(this.mIsBroadcasted ? "broadcast" : "unicast");
        out.append(", nanoapp = 0x");
        out.append(Long.toHexString(this.mNanoAppId));
        out.append(", isReliable = ");
        out.append(this.mIsReliable ? "true" : "false");
        out.append(", messageSequenceNumber = ");
        out.append(this.mMessageSequenceNumber);
        out.append("](");
        if (length > 0) {
            out.append("data = 0x");
        }
        for (int i = 0; i < Math.min(length, 16); ++i) {
            out.append(HexEncoding.encodeToString(this.mMessageBody[i], true));
            if ((i + 1) % 4 != 0) continue;
            out.append(" ");
        }
        if (length > 16) {
            out.append("...");
        }
        out.append(")");
        return out.toString();
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        boolean isEqual = false;
        if (object instanceof NanoAppMessage) {
            NanoAppMessage other = (NanoAppMessage)object;
            isEqual = !(other.getNanoAppId() != this.mNanoAppId || other.getMessageType() != this.mMessageType || other.isBroadcastMessage() != this.mIsBroadcasted || !Arrays.equals(other.getMessageBody(), this.mMessageBody) || Flags.reliableMessage() && other.isReliable() != this.mIsReliable || Flags.reliableMessage() && other.getMessageSequenceNumber() != this.mMessageSequenceNumber);
        }
        return isEqual;
    }

    public int hashCode() {
        return Objects.hash(this.mNanoAppId, this.mMessageType, this.mIsBroadcasted, Arrays.hashCode(this.mMessageBody), this.mIsReliable, this.mMessageSequenceNumber);
    }
}

