/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio;

import android.annotation.Nullable;
import android.hardware.radio.ITunerCallback;
import android.hardware.radio.ProgramList;
import android.hardware.radio.ProgramSelector;
import android.hardware.radio.RadioManager;
import android.hardware.radio.RadioMetadata;
import android.hardware.radio.RadioTuner;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class TunerCallbackAdapter
extends ITunerCallback.Stub {
    private static final String TAG = "BroadcastRadio.TunerCallbackAdapter";
    private final Object mLock = new Object();
    private final RadioTuner.Callback mCallback;
    private final Handler mHandler;
    @GuardedBy(value={"mLock"})
    @Nullable
    ProgramList mProgramList;
    @GuardedBy(value={"mLock"})
    boolean mIsAntennaConnected = true;
    @GuardedBy(value={"mLock"})
    @Nullable
    List<RadioManager.ProgramInfo> mLastCompleteList;
    @GuardedBy(value={"mLock"})
    private boolean mDelayedCompleteCallback;
    @GuardedBy(value={"mLock"})
    @Nullable
    RadioManager.ProgramInfo mCurrentProgramInfo;

    TunerCallbackAdapter(RadioTuner.Callback callback, @Nullable Handler handler) {
        this.mCallback = Objects.requireNonNull(callback, "Callback cannot be null");
        this.mHandler = handler == null ? new Handler(Looper.getMainLooper()) : handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        ProgramList programList;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mProgramList == null) {
                return;
            }
            programList = this.mProgramList;
        }
        programList.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setProgramListObserver(@Nullable ProgramList programList, ProgramList.OnCloseListener closeListener) {
        ProgramList prevProgramList;
        Objects.requireNonNull(closeListener, "CloseListener cannot be null");
        Object object = this.mLock;
        synchronized (object) {
            prevProgramList = this.mProgramList;
            this.mProgramList = programList;
        }
        if (prevProgramList != null) {
            Log.w(TAG, "Previous program list observer wasn't properly closed, closing it...");
            prevProgramList.close();
        }
        if (programList == null) {
            return;
        }
        programList.setOnCloseListener(() -> {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mProgramList != programList) {
                    return;
                }
                this.mProgramList = null;
                this.mLastCompleteList = null;
            }
            closeListener.onClose();
        });
        programList.addOnCompleteListener(() -> {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mProgramList != programList) {
                    return;
                }
                this.mLastCompleteList = programList.toList();
                if (this.mDelayedCompleteCallback) {
                    Log.d(TAG, "Sending delayed onBackgroundScanComplete callback");
                    this.sendBackgroundScanCompleteLocked();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    List<RadioManager.ProgramInfo> getLastCompleteList() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mLastCompleteList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearLastCompleteList() {
        Object object = this.mLock;
        synchronized (object) {
            this.mLastCompleteList = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    RadioManager.ProgramInfo getCurrentProgramInformation() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCurrentProgramInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isAntennaConnected() {
        boolean isConnected;
        Object object = this.mLock;
        synchronized (object) {
            isConnected = this.mIsAntennaConnected;
        }
        return isConnected;
    }

    @Override
    public void onError(int status) {
        this.mHandler.post(() -> this.mCallback.onError(status));
    }

    @Override
    public void onTuneFailed(int status, @Nullable ProgramSelector selector) {
        int errorCode;
        this.mHandler.post(() -> this.mCallback.onTuneFailed(status, selector));
        switch (status) {
            case 6: {
                errorCode = 2;
                break;
            }
            case -32: 
            case -1: {
                errorCode = 1;
                break;
            }
            case -2147483648: 
            case -38: 
            case -22: 
            case -19: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                Log.i(TAG, "Got an error with no mapping to the legacy API (" + status + "), doing a best-effort conversion to ERROR_SCAN_TIMEOUT");
            }
            default: {
                errorCode = 3;
            }
        }
        this.mHandler.post(() -> this.mCallback.onError(errorCode));
    }

    @Override
    public void onConfigurationChanged(RadioManager.BandConfig config) {
        this.mHandler.post(() -> this.mCallback.onConfigurationChanged(config));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCurrentProgramInfoChanged(RadioManager.ProgramInfo info) {
        if (info == null) {
            Log.e(TAG, "ProgramInfo must not be null");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mCurrentProgramInfo = info;
        }
        this.mHandler.post(() -> {
            this.mCallback.onProgramInfoChanged(info);
            RadioMetadata metadata = info.getMetadata();
            if (metadata != null) {
                this.mCallback.onMetadataChanged(metadata);
            }
        });
    }

    @Override
    public void onTrafficAnnouncement(boolean active) {
        this.mHandler.post(() -> this.mCallback.onTrafficAnnouncement(active));
    }

    @Override
    public void onEmergencyAnnouncement(boolean active) {
        this.mHandler.post(() -> this.mCallback.onEmergencyAnnouncement(active));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAntennaState(boolean connected) {
        Object object = this.mLock;
        synchronized (object) {
            this.mIsAntennaConnected = connected;
        }
        this.mHandler.post(() -> this.mCallback.onAntennaState(connected));
    }

    @Override
    public void onBackgroundScanAvailabilityChange(boolean isAvailable) {
        this.mHandler.post(() -> this.mCallback.onBackgroundScanAvailabilityChange(isAvailable));
    }

    @GuardedBy(value={"mLock"})
    private void sendBackgroundScanCompleteLocked() {
        this.mDelayedCompleteCallback = false;
        this.mHandler.post(() -> this.mCallback.onBackgroundScanComplete());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBackgroundScanComplete() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLastCompleteList == null) {
                Log.i(TAG, "Got onBackgroundScanComplete callback, but the program list didn't get through yet. Delaying it...");
                this.mDelayedCompleteCallback = true;
                return;
            }
            this.sendBackgroundScanCompleteLocked();
        }
    }

    @Override
    public void onProgramListChanged() {
        this.mHandler.post(() -> this.mCallback.onProgramListChanged());
    }

    @Override
    public void onProgramListUpdated(ProgramList.Chunk chunk) {
        this.mHandler.post(() -> {
            ProgramList programList;
            Object object = this.mLock;
            synchronized (object) {
                if (this.mProgramList == null) {
                    return;
                }
                programList = this.mProgramList;
            }
            programList.apply(Objects.requireNonNull(chunk, "Chunk cannot be null"));
        });
    }

    @Override
    public void onConfigFlagUpdated(int flag, boolean value) {
        this.mHandler.post(() -> this.mCallback.onConfigFlagUpdated(flag, value));
    }

    @Override
    public void onParametersUpdated(Map<String, String> parameters) {
        this.mHandler.post(() -> this.mCallback.onParametersUpdated(parameters));
    }
}

