/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.hardware.usb.UsbEndpoint;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;

public class UsbInterface
implements Parcelable {
    private final int mId;
    private final int mAlternateSetting;
    @Nullable
    private final String mName;
    private final int mClass;
    private final int mSubclass;
    private final int mProtocol;
    private Parcelable[] mEndpoints;
    @NonNull
    public static final Parcelable.Creator<UsbInterface> CREATOR = new Parcelable.Creator<UsbInterface>(){

        @Override
        public UsbInterface createFromParcel(Parcel in) {
            int id2 = in.readInt();
            int alternateSetting = in.readInt();
            String name = in.readString();
            int Class2 = in.readInt();
            int subClass = in.readInt();
            int protocol = in.readInt();
            Parcelable[] endpoints = in.readParcelableArray(UsbEndpoint.class.getClassLoader());
            UsbInterface intf = new UsbInterface(id2, alternateSetting, name, Class2, subClass, protocol);
            intf.setEndpoints(endpoints);
            return intf;
        }

        public UsbInterface[] newArray(int size) {
            return new UsbInterface[size];
        }
    };

    public UsbInterface(int id2, int alternateSetting, @Nullable String name, int Class2, int subClass, int protocol) {
        this.mId = id2;
        this.mAlternateSetting = alternateSetting;
        this.mName = name;
        this.mClass = Class2;
        this.mSubclass = subClass;
        this.mProtocol = protocol;
    }

    public int getId() {
        return this.mId;
    }

    public int getAlternateSetting() {
        return this.mAlternateSetting;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    public int getInterfaceClass() {
        return this.mClass;
    }

    public int getInterfaceSubclass() {
        return this.mSubclass;
    }

    public int getInterfaceProtocol() {
        return this.mProtocol;
    }

    public int getEndpointCount() {
        return this.mEndpoints.length;
    }

    public UsbEndpoint getEndpoint(int index) {
        return (UsbEndpoint)this.mEndpoints[index];
    }

    public void setEndpoints(Parcelable[] endpoints) {
        this.mEndpoints = Preconditions.checkArrayElementsNotNull(endpoints, "endpoints");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("UsbInterface[mId=" + this.mId + ",mAlternateSetting=" + this.mAlternateSetting + ",mName=" + this.mName + ",mClass=" + this.mClass + ",mSubclass=" + this.mSubclass + ",mProtocol=" + this.mProtocol + ",mEndpoints=[");
        for (int i = 0; i < this.mEndpoints.length; ++i) {
            builder.append("\n");
            builder.append(this.mEndpoints[i].toString());
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mId);
        parcel.writeInt(this.mAlternateSetting);
        parcel.writeString(this.mName);
        parcel.writeInt(this.mClass);
        parcel.writeInt(this.mSubclass);
        parcel.writeInt(this.mProtocol);
        parcel.writeParcelableArray(this.mEndpoints, 0);
    }
}

