/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.AggregateResult;
import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.DataOrigin;
import android.health.connect.internal.datatypes.utils.AggregationTypeIdMapper;
import android.util.ArrayMap;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AggregateRecordsResponse<T> {
    private final Map<AggregationType<T>, AggregateResult<T>> mAggregateResults;

    public AggregateRecordsResponse(@NonNull Map<Integer, AggregateResult<?>> aggregateResults) {
        Objects.requireNonNull(aggregateResults);
        this.mAggregateResults = new ArrayMap<AggregationType<T>, AggregateResult<T>>(aggregateResults.size());
        aggregateResults.forEach((key, value) -> this.mAggregateResults.put(AggregationTypeIdMapper.getInstance().getAggregationTypeFor((int)key), (AggregateResult<T>)value));
    }

    @Nullable
    public static <U> ZoneOffset getZoneOffsetInternal(@NonNull AggregationType<U> aggregationType, Map<AggregationType<U>, AggregateResult<U>> mAggregateResults) {
        Objects.requireNonNull(aggregationType);
        AggregateResult<U> result = mAggregateResults.get(aggregationType);
        if (result == null) {
            return null;
        }
        return result.getZoneOffset();
    }

    public static <U> Set<DataOrigin> getDataOriginsInternal(@NonNull AggregationType<U> aggregationType, Map<AggregationType<U>, AggregateResult<U>> mAggregateResults) {
        Objects.requireNonNull(aggregationType);
        AggregateResult<U> result = mAggregateResults.get(aggregationType);
        if (result == null) {
            return Collections.emptySet();
        }
        return result.getDataOrigins();
    }

    @Nullable
    public static <U> U getInternal(@NonNull AggregationType<U> aggregationType, Map<AggregationType<U>, AggregateResult<U>> mAggregateResults) {
        Objects.requireNonNull(aggregationType);
        AggregateResult<U> result = mAggregateResults.get(aggregationType);
        if (result == null) {
            return null;
        }
        return result.getResult();
    }

    @NonNull
    public Map<Integer, AggregateResult<?>> getAggregateResults() {
        ArrayMap aggregateResultMap = new ArrayMap();
        this.mAggregateResults.forEach((key, value) -> aggregateResultMap.put(AggregationTypeIdMapper.getInstance().getIdFor((AggregationType<?>)key), (AggregateResult<?>)value));
        return aggregateResultMap;
    }

    @Nullable
    public T get(@NonNull AggregationType<T> aggregationType) {
        return AggregateRecordsResponse.getInternal(aggregationType, this.mAggregateResults);
    }

    @Nullable
    public ZoneOffset getZoneOffset(@NonNull AggregationType<T> aggregationType) {
        return AggregateRecordsResponse.getZoneOffsetInternal(aggregationType, this.mAggregateResults);
    }

    @Nullable
    public ZoneOffset getFirstZoneOffset() {
        AggregationType<T> firstAggregationType = this.getFirstAggregationType();
        return firstAggregationType != null ? this.getZoneOffset(firstAggregationType) : null;
    }

    @Nullable
    private AggregationType<T> getFirstAggregationType() {
        return this.mAggregateResults.keySet().stream().findFirst().orElse(null);
    }

    @NonNull
    public Set<DataOrigin> getDataOrigins(@NonNull AggregationType<T> aggregationType) {
        return AggregateRecordsResponse.getDataOriginsInternal(aggregationType, this.mAggregateResults);
    }
}

