/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.health.connect.datatypes.MedicalDataSource;
import android.health.connect.datatypes.MedicalResource;
import android.health.connect.internal.ParcelUtils;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;

@SystemApi
@FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
public class MedicalResourceTypeInfo
implements Parcelable {
    private final int mMedicalResourceType;
    @NonNull
    private final Set<MedicalDataSource> mContributingDataSources;
    @NonNull
    public static final Parcelable.Creator<MedicalResourceTypeInfo> CREATOR = new Parcelable.Creator<MedicalResourceTypeInfo>(){

        @Override
        public MedicalResourceTypeInfo createFromParcel(Parcel in) {
            return new MedicalResourceTypeInfo(in);
        }

        public MedicalResourceTypeInfo[] newArray(int size) {
            return new MedicalResourceTypeInfo[size];
        }
    };

    public MedicalResourceTypeInfo(int medicalResourceType, @NonNull Set<MedicalDataSource> contributingDataSources) {
        MedicalResource.validateMedicalResourceType(medicalResourceType);
        Objects.requireNonNull(contributingDataSources);
        this.mMedicalResourceType = medicalResourceType;
        this.mContributingDataSources = contributingDataSources;
    }

    private MedicalResourceTypeInfo(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        in = ParcelUtils.getParcelForSharedMemoryIfRequired(in);
        this.mMedicalResourceType = in.readInt();
        MedicalResource.validateMedicalResourceType(this.mMedicalResourceType);
        ArrayList contributingDataSources = new ArrayList();
        in.readParcelableList(contributingDataSources, MedicalDataSource.class.getClassLoader(), MedicalDataSource.class);
        this.mContributingDataSources = Set.copyOf(contributingDataSources);
    }

    public int getMedicalResourceType() {
        return this.mMedicalResourceType;
    }

    @NonNull
    public Set<MedicalDataSource> getContributingDataSources() {
        return this.mContributingDataSources;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        ParcelUtils.putToRequiredMemory(dest, flags, this::writeToParcelInternal);
    }

    private void writeToParcelInternal(@NonNull Parcel dest) {
        Objects.requireNonNull(dest);
        dest.writeInt(this.mMedicalResourceType);
        dest.writeParcelableList(this.mContributingDataSources.stream().toList(), 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MedicalResourceTypeInfo)) {
            return false;
        }
        MedicalResourceTypeInfo that = (MedicalResourceTypeInfo)o;
        return this.getMedicalResourceType() == that.getMedicalResourceType() && this.getContributingDataSources().equals(that.getContributingDataSources());
    }

    public int hashCode() {
        return Objects.hash(this.getMedicalResourceType(), this.getContributingDataSources());
    }
}

