/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import java.util.Objects;

public class PageTokenWrapper {
    public static final PageTokenWrapper EMPTY_PAGE_TOKEN = new PageTokenWrapper();
    private static final long MAX_ALLOWED_TIME_MILLIS = 0xFFFFFFFFFFFL;
    private static final long MAX_ALLOWED_OFFSET = 262143L;
    private static final int OFFSET_START_BIT = 45;
    private static final int TIMESTAMP_START_BIT = 1;
    private final boolean mIsAscending;
    private final long mTimeMillis;
    private final int mOffset;
    private final boolean mIsTimestampSet;
    private final boolean mIsEmpty;

    public boolean isAscending() {
        return this.mIsAscending;
    }

    public long timeMillis() {
        return this.mTimeMillis;
    }

    public int offset() {
        return this.mOffset;
    }

    public boolean isTimestampSet() {
        return this.mIsTimestampSet;
    }

    public boolean isEmpty() {
        return this.mIsEmpty;
    }

    public static PageTokenWrapper of(boolean isAscending, long timeMillis, int offset) {
        PageTokenWrapper.checkArgument(timeMillis >= 0L, "timestamp can not be negative");
        PageTokenWrapper.checkArgument(timeMillis <= 0xFFFFFFFFFFFL, "timestamp too large");
        PageTokenWrapper.checkArgument(offset >= 0, "offset can not be negative");
        int boundedOffset = Integer.min(262143, offset);
        return new PageTokenWrapper(isAscending, timeMillis, boundedOffset);
    }

    public static PageTokenWrapper ofAscending(boolean isAscending) {
        return new PageTokenWrapper(isAscending);
    }

    public static PageTokenWrapper from(long pageToken, boolean defaultIsAscending) {
        if (pageToken == -1L) {
            return PageTokenWrapper.ofAscending(defaultIsAscending);
        }
        PageTokenWrapper.checkArgument(pageToken >= 0L, "pageToken cannot be negative");
        return PageTokenWrapper.of(PageTokenWrapper.getIsAscending(pageToken), PageTokenWrapper.getTimestamp(pageToken), PageTokenWrapper.getOffset(pageToken));
    }

    private static boolean getIsAscending(long pageToken) {
        return (pageToken & 1L) == 0L;
    }

    private static long getTimestamp(long pageToken) {
        long mask = 0x1FFFFFFFFFFEL;
        return (pageToken & mask) >> 1;
    }

    private static int getOffset(long pageToken) {
        return (int)(pageToken >> 45);
    }

    private static void checkArgument(boolean expression, String errorMsg) {
        if (!expression) {
            throw new IllegalArgumentException(errorMsg);
        }
    }

    public long encode() {
        return this.mIsTimestampSet ? (long)this.mOffset << 45 | this.mTimeMillis << 1 | (long)(this.mIsAscending ? 0 : 1) : -1L;
    }

    public String toString() {
        if (this.mIsEmpty) {
            return "PageTokenWrapper{}";
        }
        StringBuilder builder = new StringBuilder("PageTokenWrapper{");
        builder.append("isAscending = ").append(this.mIsAscending);
        if (this.mIsTimestampSet) {
            builder.append(", timeMillis = ").append(this.mTimeMillis);
            builder.append(", offset = ").append(this.mOffset);
        }
        return builder.append("}").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PageTokenWrapper)) {
            return false;
        }
        PageTokenWrapper that = (PageTokenWrapper)o;
        return this.mIsAscending == that.mIsAscending && this.mTimeMillis == that.mTimeMillis && this.mOffset == that.mOffset && this.mIsTimestampSet == that.mIsTimestampSet && this.mIsEmpty == that.mIsEmpty;
    }

    public int hashCode() {
        return Objects.hash(this.mIsAscending, this.mOffset, this.mTimeMillis, this.mIsTimestampSet, this.mIsEmpty);
    }

    private PageTokenWrapper(boolean isAscending, long timeMillis, int offset) {
        this.mIsAscending = isAscending;
        this.mTimeMillis = timeMillis;
        this.mOffset = offset;
        this.mIsTimestampSet = true;
        this.mIsEmpty = false;
    }

    private PageTokenWrapper(boolean isAscending) {
        this.mIsAscending = isAscending;
        this.mTimeMillis = 0L;
        this.mOffset = 0;
        this.mIsTimestampSet = false;
        this.mIsEmpty = false;
    }

    private PageTokenWrapper() {
        this.mIsAscending = true;
        this.mTimeMillis = 0L;
        this.mOffset = 0;
        this.mIsTimestampSet = false;
        this.mIsEmpty = true;
    }
}

