/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.aidl;

import android.annotation.NonNull;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.health.connect.datatypes.AppInfo;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ApplicationInfoResponseParcel
implements Parcelable {
    private final List<AppInfo> mAppInfoList;
    private static final int COMPRESS_FACTOR = 100;
    public static final Parcelable.Creator<ApplicationInfoResponseParcel> CREATOR = new Parcelable.Creator<ApplicationInfoResponseParcel>(){

        @Override
        public ApplicationInfoResponseParcel createFromParcel(Parcel in) {
            return new ApplicationInfoResponseParcel(in);
        }

        public ApplicationInfoResponseParcel[] newArray(int size) {
            return new ApplicationInfoResponseParcel[size];
        }
    };

    public ApplicationInfoResponseParcel(@NonNull List<AppInfo> appInfoList) {
        Objects.requireNonNull(appInfoList);
        this.mAppInfoList = appInfoList;
    }

    protected ApplicationInfoResponseParcel(Parcel in) {
        int size = in.readInt();
        this.mAppInfoList = new ArrayList<AppInfo>(size);
        for (int i = 0; i < size; ++i) {
            String packageName = in.readString();
            String name = in.readString();
            byte[] icon = in.createByteArray();
            Bitmap bitmap = icon != null ? BitmapFactory.decodeByteArray(icon, 0, icon.length) : null;
            this.mAppInfoList.add(new AppInfo.Builder(packageName, name, bitmap).build());
        }
    }

    @NonNull
    public List<AppInfo> getAppInfoList() {
        return this.mAppInfoList;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mAppInfoList.size());
        this.mAppInfoList.forEach(appInfo -> {
            dest.writeString(appInfo.getPackageName());
            dest.writeString(appInfo.getName());
            Bitmap bitmap = appInfo.getIcon();
            byte[] bitmapData = null;
            if (bitmap != null) {
                try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                    bitmap.compress(Bitmap.CompressFormat.PNG, 100, stream);
                    bitmapData = stream.toByteArray();
                }
                catch (IOException exception) {
                    throw new IllegalArgumentException(exception);
                }
            }
            dest.writeByteArray(bitmapData);
        });
    }
}

