/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.aidl;

import android.health.connect.aidl.HealthConnectExceptionParcel;
import android.health.connect.datatypes.MedicalDataSource;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IMedicalDataSourcesResponseCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.health.connect.aidl.IMedicalDataSourcesResponseCallback";

    public void onResult(List<MedicalDataSource> var1) throws RemoteException;

    public void onError(HealthConnectExceptionParcel var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMedicalDataSourcesResponseCallback {
        static final int TRANSACTION_onResult = 1;
        static final int TRANSACTION_onError = 2;

        public Stub() {
            this.attachInterface(this, IMedicalDataSourcesResponseCallback.DESCRIPTOR);
        }

        public static IMedicalDataSourcesResponseCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IMedicalDataSourcesResponseCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IMedicalDataSourcesResponseCallback) {
                return (IMedicalDataSourcesResponseCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onResult";
                }
                case 2: {
                    return "onError";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IMedicalDataSourcesResponseCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    ArrayList<MedicalDataSource> _arg0 = data.createTypedArrayList(MedicalDataSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.onResult(_arg0);
                    break;
                }
                case 2: {
                    HealthConnectExceptionParcel _arg0 = data.readTypedObject(HealthConnectExceptionParcel.CREATOR);
                    data.enforceNoDataAvail();
                    this.onError(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IMedicalDataSourcesResponseCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IMedicalDataSourcesResponseCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(List<MedicalDataSource> result) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IMedicalDataSourcesResponseCallback.DESCRIPTOR);
                    _data.writeTypedList(result, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(HealthConnectExceptionParcel exception) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IMedicalDataSourcesResponseCallback.DESCRIPTOR);
                    _data.writeTypedObject(exception, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMedicalDataSourcesResponseCallback {
        @Override
        public void onResult(List<MedicalDataSource> result) throws RemoteException {
        }

        @Override
        public void onError(HealthConnectExceptionParcel exception) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

