/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.aidl;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.ReadMedicalResourcesInitialRequest;
import android.health.connect.ReadMedicalResourcesPageRequest;
import android.health.connect.datatypes.MedicalDataSource;
import android.health.connect.datatypes.MedicalResource;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class ReadMedicalResourcesRequestParcel
implements Parcelable {
    private final boolean mIsPageRequest;
    private int mMedicalResourceType;
    @NonNull
    private Set<String> mDataSourceIds = Set.of();
    @Nullable
    private String mPageToken = null;
    private final int mPageSize;
    public static final Parcelable.Creator<ReadMedicalResourcesRequestParcel> CREATOR = new Parcelable.Creator<ReadMedicalResourcesRequestParcel>(){

        @Override
        public ReadMedicalResourcesRequestParcel createFromParcel(Parcel in) {
            return new ReadMedicalResourcesRequestParcel(in);
        }

        public ReadMedicalResourcesRequestParcel[] newArray(int size) {
            return new ReadMedicalResourcesRequestParcel[size];
        }
    };

    public ReadMedicalResourcesRequestParcel(ReadMedicalResourcesInitialRequest request) {
        this.mIsPageRequest = false;
        this.mMedicalResourceType = request.getMedicalResourceType();
        this.mDataSourceIds = request.getDataSourceIds();
        this.mPageSize = request.getPageSize();
    }

    public ReadMedicalResourcesRequestParcel(ReadMedicalResourcesPageRequest request) {
        this.mIsPageRequest = true;
        this.mPageToken = request.getPageToken();
        this.mPageSize = request.getPageSize();
    }

    private ReadMedicalResourcesRequestParcel(Parcel in) {
        this.mIsPageRequest = in.readBoolean();
        this.mMedicalResourceType = in.readInt();
        this.mDataSourceIds = new HashSet<String>((Collection)Objects.requireNonNull(in.createStringArrayList()));
        MedicalDataSource.validateMedicalDataSourceIds(this.mDataSourceIds);
        this.mPageToken = in.readString();
        this.mPageSize = in.readInt();
        ValidationUtils.requireInRange(this.mPageSize, 1, 5000, "pageSize");
        if (this.mIsPageRequest && this.mPageToken == null) {
            throw new IllegalArgumentException("pageToken cannot be null when reading Parcel from page request.");
        }
        if (!this.mIsPageRequest) {
            MedicalResource.validateMedicalResourceType(this.mMedicalResourceType);
        }
    }

    public int getMedicalResourceType() {
        return this.mMedicalResourceType;
    }

    @NonNull
    public Set<String> getDataSourceIds() {
        return new ArraySet<String>(this.mDataSourceIds);
    }

    @Nullable
    public String getPageToken() {
        return this.mPageToken;
    }

    public int getPageSize() {
        return this.mPageSize;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeBoolean(this.mIsPageRequest);
        dest.writeInt(this.mMedicalResourceType);
        dest.writeStringList(new ArrayList<String>(this.mDataSourceIds));
        dest.writeString(this.mPageToken);
        dest.writeInt(this.mPageSize);
    }
}

