/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.aidl;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.internal.ParcelUtils;
import android.health.connect.internal.datatypes.RecordInternal;
import android.health.connect.internal.datatypes.utils.ParcelRecordConverter;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class RecordsParcel
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<RecordsParcel> CREATOR = new Parcelable.Creator<RecordsParcel>(){

        @Override
        public RecordsParcel createFromParcel(Parcel in) {
            return new RecordsParcel(in);
        }

        public RecordsParcel[] newArray(int size) {
            return new RecordsParcel[size];
        }
    };
    private final List<RecordInternal<?>> mRecordInternals;
    private long mRecordsChunkSize;
    @Nullable
    private List<Long> mRecordsSize;

    public RecordsParcel(@NonNull List<RecordInternal<?>> recordInternals) {
        this.mRecordInternals = recordInternals;
    }

    private RecordsParcel(@NonNull Parcel in) {
        long remainingParcelSize;
        in = ParcelUtils.getParcelForSharedMemoryIfRequired(in);
        int size = in.readInt();
        this.mRecordInternals = new ArrayList(size);
        this.mRecordsSize = new ArrayList<Long>(size);
        this.mRecordsChunkSize = remainingParcelSize = (long)in.dataAvail();
        for (int i = 0; i < size; ++i) {
            int identifier = in.readInt();
            try {
                this.mRecordInternals.add(ParcelRecordConverter.getInstance().getRecord(in, identifier));
                this.mRecordsSize.add(remainingParcelSize - (long)in.dataAvail());
                remainingParcelSize = in.dataAvail();
                continue;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        ParcelUtils.putToRequiredMemory(dest, flags, this::writeToParcelInternal);
    }

    @NonNull
    public List<RecordInternal<?>> getRecords() {
        return this.mRecordInternals;
    }

    @Nullable
    public List<Long> getRecordsSize() {
        return this.mRecordsSize;
    }

    public long getRecordsChunkSize() {
        return this.mRecordsChunkSize;
    }

    private void writeToParcelInternal(@NonNull Parcel dest) {
        dest.writeInt(this.mRecordInternals.size());
        for (RecordInternal<?> recordInternal : this.mRecordInternals) {
            dest.writeInt(recordInternal.getRecordType());
            recordInternal.writeToParcel(dest);
        }
    }
}

