/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.changelog;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.health.connect.MedicalResourceId;
import android.health.connect.aidl.DeletedLogsParcel;
import android.health.connect.aidl.DeletedMedicalResourcesParcel;
import android.health.connect.aidl.MedicalResourceListParcel;
import android.health.connect.aidl.RecordsParcel;
import android.health.connect.datatypes.MedicalResource;
import android.health.connect.datatypes.Record;
import android.health.connect.internal.ParcelUtils;
import android.health.connect.internal.datatypes.RecordInternal;
import android.health.connect.internal.datatypes.utils.InternalExternalRecordConverter;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.healthfitness.flags.AconfigFlagHelper;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ChangeLogsResponse
implements Parcelable {
    private final List<Record> mUpsertedRecords;
    private final List<DeletedLog> mDeletedLogs;
    private final List<MedicalResource> mUpsertedMedicalResources;
    private final List<DeletedMedicalResource> mDeletedMedicalResources;
    private final String mNextChangesToken;
    private final boolean mHasMorePages;
    @NonNull
    public static final Parcelable.Creator<ChangeLogsResponse> CREATOR = new Parcelable.Creator<ChangeLogsResponse>(){

        @Override
        public ChangeLogsResponse createFromParcel(Parcel in) {
            return new ChangeLogsResponse(in);
        }

        public ChangeLogsResponse[] newArray(int size) {
            return new ChangeLogsResponse[size];
        }
    };

    @Deprecated
    public ChangeLogsResponse(@NonNull RecordsParcel upsertedRecords, @NonNull List<DeletedLog> deletedLogs, @NonNull String nextChangesToken, boolean hasMorePages) {
        this.mUpsertedRecords = InternalExternalRecordConverter.getInstance().getExternalRecords(Objects.requireNonNull(upsertedRecords).getRecords());
        this.mDeletedLogs = Objects.requireNonNull(deletedLogs);
        this.mUpsertedMedicalResources = List.of();
        this.mDeletedMedicalResources = List.of();
        this.mNextChangesToken = Objects.requireNonNull(nextChangesToken);
        this.mHasMorePages = hasMorePages;
    }

    public ChangeLogsResponse(@NonNull List<Record> upsertedRecords, @NonNull List<DeletedLog> deletedLogs, @NonNull List<MedicalResource> upsertedMedicalResources, @NonNull List<DeletedMedicalResource> deletedMedicalResources, @NonNull String nextChangesToken, boolean hasMorePages) {
        this.mUpsertedRecords = Objects.requireNonNull(upsertedRecords);
        this.mDeletedLogs = Objects.requireNonNull(deletedLogs);
        this.mUpsertedMedicalResources = Objects.requireNonNull(upsertedMedicalResources);
        this.mDeletedMedicalResources = Objects.requireNonNull(deletedMedicalResources);
        this.mNextChangesToken = Objects.requireNonNull(nextChangesToken);
        this.mHasMorePages = hasMorePages;
    }

    private ChangeLogsResponse(Parcel in) {
        in = ParcelUtils.getParcelForSharedMemoryIfRequired(in);
        this.mUpsertedRecords = InternalExternalRecordConverter.getInstance().getExternalRecords(in.readParcelable(RecordsParcel.class.getClassLoader(), RecordsParcel.class).getRecords());
        this.mDeletedLogs = in.readParcelable(DeletedLogsParcel.class.getClassLoader(), DeletedLogsParcel.class).getDeletedLogs();
        this.mNextChangesToken = in.readString();
        this.mHasMorePages = in.readBoolean();
        this.mUpsertedMedicalResources = AconfigFlagHelper.isPhrChangeLogsEnabled() ? in.readParcelable(MedicalResourceListParcel.class.getClassLoader(), MedicalResourceListParcel.class).getMedicalResources() : List.of();
        this.mDeletedMedicalResources = AconfigFlagHelper.isPhrChangeLogsEnabled() ? in.readParcelable(DeletedMedicalResourcesParcel.class.getClassLoader(), DeletedMedicalResourcesParcel.class).getDeletedMedicalResources() : List.of();
    }

    @NonNull
    public List<Record> getUpsertedRecords() {
        return this.mUpsertedRecords;
    }

    @NonNull
    public List<DeletedLog> getDeletedLogs() {
        return this.mDeletedLogs;
    }

    @NonNull
    @FlaggedApi(value="com.android.healthfitness.flags.phr_change_logs")
    public List<MedicalResource> getUpsertedMedicalResources() {
        return this.mUpsertedMedicalResources;
    }

    @NonNull
    @FlaggedApi(value="com.android.healthfitness.flags.phr_change_logs")
    public List<DeletedMedicalResource> getDeletedMedicalResources() {
        return this.mDeletedMedicalResources;
    }

    @NonNull
    public String getNextChangesToken() {
        return this.mNextChangesToken;
    }

    public boolean hasMorePages() {
        return this.mHasMorePages;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        ParcelUtils.putToRequiredMemory(dest, flags, this::writeToParcelInternal);
    }

    private void writeToParcelInternal(@NonNull Parcel dest) {
        List<RecordInternal<?>> recordInternals = this.mUpsertedRecords.stream().map(Record::toRecordInternal).collect(Collectors.toList());
        dest.writeParcelable(new RecordsParcel(recordInternals), 0);
        dest.writeParcelable(new DeletedLogsParcel(this.mDeletedLogs), 0);
        dest.writeString(this.mNextChangesToken);
        dest.writeBoolean(this.mHasMorePages);
        if (AconfigFlagHelper.isPhrChangeLogsEnabled()) {
            dest.writeParcelable(new MedicalResourceListParcel(this.mUpsertedMedicalResources), 0);
            dest.writeParcelable(new DeletedMedicalResourcesParcel(this.mDeletedMedicalResources), 0);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof ChangeLogsResponse)) {
            return false;
        }
        ChangeLogsResponse that = (ChangeLogsResponse)o;
        return this.mHasMorePages == that.mHasMorePages && Objects.equals(this.mUpsertedRecords, that.mUpsertedRecords) && Objects.equals(this.mDeletedLogs, that.mDeletedLogs) && Objects.equals(this.mUpsertedMedicalResources, that.mUpsertedMedicalResources) && Objects.equals(this.mDeletedMedicalResources, that.mDeletedMedicalResources) && Objects.equals(this.mNextChangesToken, that.mNextChangesToken);
    }

    public int hashCode() {
        return Objects.hash(this.mUpsertedRecords, this.mDeletedLogs, this.mUpsertedMedicalResources, this.mDeletedMedicalResources, this.mNextChangesToken, this.mHasMorePages);
    }

    @FlaggedApi(value="com.android.healthfitness.flags.phr_change_logs")
    public static class DeletedMedicalResource {
        private final MedicalResourceId mDeletedMedicalResourceId;
        private final Instant mDeletedTime;

        public DeletedMedicalResource(@NonNull MedicalResourceId deletedMedicalResourceId, @NonNull Instant deletedTime) {
            Objects.requireNonNull(deletedMedicalResourceId);
            Objects.requireNonNull(deletedTime);
            this.mDeletedMedicalResourceId = deletedMedicalResourceId;
            this.mDeletedTime = deletedTime;
        }

        @NonNull
        public MedicalResourceId getDeletedMedicalResourceId() {
            return this.mDeletedMedicalResourceId;
        }

        @NonNull
        public String getDataSourceId() {
            return this.mDeletedMedicalResourceId.getDataSourceId();
        }

        @NonNull
        public Instant getDeletedTime() {
            return this.mDeletedTime;
        }

        public boolean equals(Object o) {
            if (!(o instanceof DeletedMedicalResource)) {
                return false;
            }
            DeletedMedicalResource that = (DeletedMedicalResource)o;
            return Objects.equals(this.mDeletedMedicalResourceId, that.mDeletedMedicalResourceId) && Objects.equals(this.mDeletedTime, that.mDeletedTime);
        }

        public int hashCode() {
            return Objects.hash(this.mDeletedMedicalResourceId, this.mDeletedTime);
        }
    }

    public static class DeletedLog {
        private final String mDeletedRecordId;
        private final Instant mDeletedTime;

        @Deprecated
        @FlaggedApi(value="com.android.healthfitness.flags.phr_change_logs")
        public DeletedLog(@NonNull String deletedRecordId, long deletedTime) {
            Objects.requireNonNull(deletedRecordId);
            this.mDeletedRecordId = deletedRecordId;
            this.mDeletedTime = Instant.ofEpochMilli(deletedTime);
        }

        @FlaggedApi(value="com.android.healthfitness.flags.phr_change_logs")
        public DeletedLog(@NonNull String deletedRecordId, @NonNull Instant deletedTime) {
            Objects.requireNonNull(deletedRecordId);
            Objects.requireNonNull(deletedTime);
            this.mDeletedRecordId = deletedRecordId;
            this.mDeletedTime = deletedTime;
        }

        @NonNull
        public String getDeletedRecordId() {
            return this.mDeletedRecordId;
        }

        @NonNull
        public Instant getDeletedTime() {
            return this.mDeletedTime;
        }

        public boolean equals(Object o) {
            if (!(o instanceof DeletedLog)) {
                return false;
            }
            DeletedLog that = (DeletedLog)o;
            return Objects.equals(this.mDeletedRecordId, that.mDeletedRecordId) && Objects.equals(this.mDeletedTime, that.mDeletedTime);
        }

        public int hashCode() {
            return Objects.hash(this.mDeletedRecordId, this.mDeletedTime);
        }
    }
}

