/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.InstantRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.units.Energy;
import android.health.connect.datatypes.units.Power;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.BasalMetabolicRateRecordInternal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;

@Identifier(recordIdentifier=16)
public class BasalMetabolicRateRecord
extends InstantRecord {
    private final Power mBasalMetabolicRate;
    @NonNull
    public static final AggregationType<Energy> BASAL_CALORIES_TOTAL = new AggregationType<Energy>(4, 3, 16, Energy.class);

    private BasalMetabolicRateRecord(@NonNull Metadata metadata, @NonNull Instant time, @NonNull ZoneOffset zoneOffset, @NonNull Power basalMetabolicRate, boolean skipValidation) {
        super(metadata, time, zoneOffset, skipValidation);
        Objects.requireNonNull(metadata);
        Objects.requireNonNull(time);
        Objects.requireNonNull(zoneOffset);
        Objects.requireNonNull(basalMetabolicRate);
        if (!skipValidation) {
            ValidationUtils.requireInRange(basalMetabolicRate.getInWatts(), 0.0, 484.259, "basalMetabolicRate");
        }
        this.mBasalMetabolicRate = basalMetabolicRate;
    }

    @NonNull
    public Power getBasalMetabolicRate() {
        return this.mBasalMetabolicRate;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof BasalMetabolicRateRecord)) {
            return false;
        }
        BasalMetabolicRateRecord that = (BasalMetabolicRateRecord)o;
        return this.getBasalMetabolicRate().equals(that.getBasalMetabolicRate());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getBasalMetabolicRate());
    }

    public BasalMetabolicRateRecordInternal toRecordInternal() {
        BasalMetabolicRateRecordInternal recordInternal = (BasalMetabolicRateRecordInternal)new BasalMetabolicRateRecordInternal().setMetaData(this.getMetadata());
        recordInternal.setTime(this.getTime().toEpochMilli());
        recordInternal.setZoneOffset(this.getZoneOffset().getTotalSeconds());
        recordInternal.setBasalMetabolicRate(this.mBasalMetabolicRate.getInWatts());
        return recordInternal;
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mTime;
        private ZoneOffset mZoneOffset;
        private final Power mBasalMetabolicRate;

        public Builder(@NonNull Metadata metadata, @NonNull Instant time, @NonNull Power basalMetabolicRate) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(time);
            Objects.requireNonNull(basalMetabolicRate);
            this.mMetadata = metadata;
            this.mTime = time;
            this.mBasalMetabolicRate = basalMetabolicRate;
            this.mZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(time);
        }

        @NonNull
        public Builder setZoneOffset(@NonNull ZoneOffset zoneOffset) {
            Objects.requireNonNull(zoneOffset);
            this.mZoneOffset = zoneOffset;
            return this;
        }

        @NonNull
        public Builder clearZoneOffset() {
            this.mZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public BasalMetabolicRateRecord buildWithoutValidation() {
            return new BasalMetabolicRateRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mBasalMetabolicRate, true);
        }

        @NonNull
        public BasalMetabolicRateRecord build() {
            return new BasalMetabolicRateRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mBasalMetabolicRate, false);
        }
    }
}

