/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.InstantRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.units.Mass;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.BodyWaterMassRecordInternal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;

@Identifier(recordIdentifier=34)
public class BodyWaterMassRecord
extends InstantRecord {
    private final Mass mBodyWaterMass;

    private BodyWaterMassRecord(@NonNull Metadata metadata, @NonNull Instant time, @NonNull ZoneOffset zoneOffset, @NonNull Mass bodyWaterMass, boolean skipValidation) {
        super(metadata, time, zoneOffset, skipValidation);
        Objects.requireNonNull(bodyWaterMass);
        if (!skipValidation) {
            ValidationUtils.requireInRange(bodyWaterMass.getInGrams(), 0.0, 1000000.0, "mass");
        }
        this.mBodyWaterMass = bodyWaterMass;
    }

    @NonNull
    public Mass getBodyWaterMass() {
        return this.mBodyWaterMass;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof BodyWaterMassRecord)) {
            return false;
        }
        BodyWaterMassRecord that = (BodyWaterMassRecord)o;
        return this.getBodyWaterMass().equals(that.getBodyWaterMass());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getBodyWaterMass());
    }

    public BodyWaterMassRecordInternal toRecordInternal() {
        BodyWaterMassRecordInternal recordInternal = (BodyWaterMassRecordInternal)new BodyWaterMassRecordInternal().setMetaData(this.getMetadata());
        recordInternal.setTime(this.getTime().toEpochMilli());
        recordInternal.setZoneOffset(this.getZoneOffset().getTotalSeconds());
        recordInternal.setBodyWaterMass(this.mBodyWaterMass.getInGrams());
        return recordInternal;
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mTime;
        private final Mass mBodyWaterMass;
        private ZoneOffset mZoneOffset;

        public Builder(@NonNull Metadata metadata, @NonNull Instant time, @NonNull Mass bodyWaterMass) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(time);
            Objects.requireNonNull(bodyWaterMass);
            this.mMetadata = metadata;
            this.mTime = time;
            this.mBodyWaterMass = bodyWaterMass;
            this.mZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(time);
        }

        @NonNull
        public Builder setZoneOffset(@NonNull ZoneOffset zoneOffset) {
            Objects.requireNonNull(zoneOffset);
            this.mZoneOffset = zoneOffset;
            return this;
        }

        @NonNull
        public Builder clearZoneOffset() {
            this.mZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public BodyWaterMassRecord buildWithoutValidation() {
            return new BodyWaterMassRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mBodyWaterMass, true);
        }

        @NonNull
        public BodyWaterMassRecord build() {
            return new BodyWaterMassRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mBodyWaterMass, false);
        }
    }
}

