/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.IntervalRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.CyclingPedalingCadenceRecordInternal;
import com.android.healthfitness.flags.Flags;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;

@Identifier(recordIdentifier=12)
public class CyclingPedalingCadenceRecord
extends IntervalRecord {
    @NonNull
    public static final AggregationType<Double> RPM_AVG = new AggregationType<Double>(75, 2, 12, Double.class);
    @NonNull
    public static final AggregationType<Double> RPM_MIN = new AggregationType<Double>(76, 1, 12, Double.class);
    @NonNull
    public static final AggregationType<Double> RPM_MAX = new AggregationType<Double>(77, 0, 12, Double.class);
    private final List<CyclingPedalingCadenceRecordSample> mCyclingPedalingCadenceRecordSamples;

    private CyclingPedalingCadenceRecord(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull ZoneOffset startZoneOffset, @NonNull Instant endTime, @NonNull ZoneOffset endZoneOffset, @NonNull List<CyclingPedalingCadenceRecordSample> cyclingPedalingCadenceRecordSamples, boolean skipValidation) {
        super(metadata, startTime, startZoneOffset, endTime, endZoneOffset, skipValidation, true);
        Objects.requireNonNull(cyclingPedalingCadenceRecordSamples);
        if (!skipValidation) {
            ValidationUtils.validateSampleStartAndEndTime(startTime, endTime, cyclingPedalingCadenceRecordSamples.stream().map(CyclingPedalingCadenceRecordSample::getTime).toList());
        }
        this.mCyclingPedalingCadenceRecordSamples = cyclingPedalingCadenceRecordSamples;
    }

    @NonNull
    public List<CyclingPedalingCadenceRecordSample> getSamples() {
        return this.mCyclingPedalingCadenceRecordSamples;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (super.equals(object)) {
            if (!(object instanceof CyclingPedalingCadenceRecord)) {
                return false;
            }
            CyclingPedalingCadenceRecord other = (CyclingPedalingCadenceRecord)object;
            if (Flags.sampleTimeOrdering()) {
                return this.getSamples().equals(other.getSamples());
            }
            if (this.getSamples().size() != other.getSamples().size()) {
                return false;
            }
            for (int idx = 0; idx < this.getSamples().size(); ++idx) {
                if (this.getSamples().get(idx).getRevolutionsPerMinute() == other.getSamples().get(idx).getRevolutionsPerMinute() && this.getSamples().get(idx).getTime().toEpochMilli() == other.getSamples().get(idx).getTime().toEpochMilli()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSamples());
    }

    public CyclingPedalingCadenceRecordInternal toRecordInternal() {
        HashSet<CyclingPedalingCadenceRecordInternal.CyclingPedalingCadenceRecordSample> samples = new HashSet<CyclingPedalingCadenceRecordInternal.CyclingPedalingCadenceRecordSample>(this.getSamples().size());
        for (CyclingPedalingCadenceRecordSample cyclingPedalingCadenceRecordSample : this.getSamples()) {
            samples.add(new CyclingPedalingCadenceRecordInternal.CyclingPedalingCadenceRecordSample(cyclingPedalingCadenceRecordSample.getRevolutionsPerMinute(), cyclingPedalingCadenceRecordSample.getTime().toEpochMilli()));
        }
        CyclingPedalingCadenceRecordInternal recordInternal = new CyclingPedalingCadenceRecordInternal(samples);
        recordInternal.setTimeInterval(this);
        recordInternal.setMetaData(this.getMetadata());
        return recordInternal;
    }

    public static class CyclingPedalingCadenceRecordSample {
        private final double mRevolutionsPerMinute;
        private final Instant mTime;

        public CyclingPedalingCadenceRecordSample(double revolutionsPerMinute, @NonNull Instant time) {
            this(revolutionsPerMinute, time, false);
        }

        public CyclingPedalingCadenceRecordSample(double revolutionsPerMinute, @NonNull Instant time, boolean skipValidation) {
            Objects.requireNonNull(time);
            if (!skipValidation) {
                ValidationUtils.requireInRange(revolutionsPerMinute, 0.0, 10000.0, "revolutionsPerMinute");
            }
            this.mTime = time;
            this.mRevolutionsPerMinute = revolutionsPerMinute;
        }

        public double getRevolutionsPerMinute() {
            return this.mRevolutionsPerMinute;
        }

        @NonNull
        public Instant getTime() {
            return this.mTime;
        }

        public boolean equals(@Nullable Object object) {
            if (Flags.sampleTimeOrdering()) {
                if (object instanceof CyclingPedalingCadenceRecordSample) {
                    CyclingPedalingCadenceRecordSample other = (CyclingPedalingCadenceRecordSample)object;
                    return this.getRevolutionsPerMinute() == other.getRevolutionsPerMinute() && this.getTime().toEpochMilli() == other.getTime().toEpochMilli();
                }
            } else if (super.equals(object) && object instanceof CyclingPedalingCadenceRecordSample) {
                CyclingPedalingCadenceRecordSample other = (CyclingPedalingCadenceRecordSample)object;
                return this.getRevolutionsPerMinute() == other.getRevolutionsPerMinute() && this.getTime().toEpochMilli() == other.getTime().toEpochMilli();
            }
            return false;
        }

        public int hashCode() {
            if (Flags.sampleTimeOrdering()) {
                return Objects.hash(this.getRevolutionsPerMinute(), this.getTime());
            }
            return Objects.hash(super.hashCode(), this.getRevolutionsPerMinute(), this.getTime());
        }
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mStartTime;
        private final Instant mEndTime;
        private final List<CyclingPedalingCadenceRecordSample> mSamples;
        private ZoneOffset mStartZoneOffset;
        private ZoneOffset mEndZoneOffset;

        public Builder(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull Instant endTime, @NonNull List<CyclingPedalingCadenceRecordSample> samples) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(startTime);
            Objects.requireNonNull(endTime);
            Objects.requireNonNull(samples);
            this.mMetadata = metadata;
            this.mStartTime = startTime;
            this.mEndTime = endTime;
            if (Flags.sampleTimeOrdering()) {
                TreeSet<CyclingPedalingCadenceRecordSample> sampleSet = new TreeSet<CyclingPedalingCadenceRecordSample>(Comparator.comparing(CyclingPedalingCadenceRecordSample::getTime));
                sampleSet.addAll(samples);
                this.mSamples = sampleSet.stream().toList();
            } else {
                this.mSamples = samples;
            }
            this.mStartZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(startTime);
            this.mEndZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(endTime);
        }

        @NonNull
        public Builder setStartZoneOffset(@NonNull ZoneOffset startZoneOffset) {
            Objects.requireNonNull(startZoneOffset);
            this.mStartZoneOffset = startZoneOffset;
            return this;
        }

        @NonNull
        public Builder setEndZoneOffset(@NonNull ZoneOffset endZoneOffset) {
            Objects.requireNonNull(endZoneOffset);
            this.mEndZoneOffset = endZoneOffset;
            return this;
        }

        @NonNull
        public Builder clearStartZoneOffset() {
            this.mStartZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public Builder clearEndZoneOffset() {
            this.mEndZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public CyclingPedalingCadenceRecord buildWithoutValidation() {
            return new CyclingPedalingCadenceRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mSamples, true);
        }

        @NonNull
        public CyclingPedalingCadenceRecord build() {
            return new CyclingPedalingCadenceRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mSamples, false);
        }
    }
}

