/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.FhirVersion;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import java.time.Instant;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

@FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
public class MedicalDataSource
implements Parcelable {
    @NonNull
    private final String mId;
    @NonNull
    private final String mPackageName;
    @NonNull
    private final Uri mFhirBaseUri;
    @NonNull
    private final String mDisplayName;
    @NonNull
    private final FhirVersion mFhirVersion;
    @Nullable
    private final Instant mLastDataUpdateTime;
    @NonNull
    public static final Parcelable.Creator<MedicalDataSource> CREATOR = new Parcelable.Creator<MedicalDataSource>(){

        @Override
        @NonNull
        public MedicalDataSource createFromParcel(@NonNull Parcel in) {
            return new MedicalDataSource(in);
        }

        @NonNull
        public MedicalDataSource[] newArray(int size) {
            return new MedicalDataSource[size];
        }
    };

    private MedicalDataSource(@NonNull String id2, @NonNull String packageName, @NonNull Uri fhirBaseUri, @NonNull String displayName, @NonNull FhirVersion fhirVersion, @Nullable Instant lastDataUpdateTime) {
        Objects.requireNonNull(id2);
        Objects.requireNonNull(packageName);
        Objects.requireNonNull(fhirBaseUri);
        Objects.requireNonNull(displayName);
        Objects.requireNonNull(fhirVersion);
        this.mId = id2;
        this.mPackageName = packageName;
        this.mFhirBaseUri = fhirBaseUri;
        this.mDisplayName = displayName;
        this.mFhirVersion = fhirVersion;
        this.mLastDataUpdateTime = lastDataUpdateTime;
    }

    private MedicalDataSource(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        this.mId = Objects.requireNonNull(in.readString());
        this.mPackageName = Objects.requireNonNull(in.readString());
        this.mFhirBaseUri = Objects.requireNonNull(in.readParcelable(Uri.class.getClassLoader(), Uri.class));
        this.mDisplayName = Objects.requireNonNull(in.readString());
        this.mFhirVersion = Objects.requireNonNull(in.readParcelable(FhirVersion.class.getClassLoader(), FhirVersion.class));
        long lastDataUpdateTimeMillis = in.readLong();
        this.mLastDataUpdateTime = lastDataUpdateTimeMillis == 0L ? null : Instant.ofEpochMilli(lastDataUpdateTimeMillis);
    }

    @NonNull
    public String getId() {
        return this.mId;
    }

    @NonNull
    public String getPackageName() {
        return this.mPackageName;
    }

    @NonNull
    public String getDisplayName() {
        return this.mDisplayName;
    }

    @NonNull
    public FhirVersion getFhirVersion() {
        return this.mFhirVersion;
    }

    @Nullable
    public Instant getLastDataUpdateTime() {
        return this.mLastDataUpdateTime;
    }

    @NonNull
    public Uri getFhirBaseUri() {
        return this.mFhirBaseUri;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mId);
        dest.writeString(this.mPackageName);
        dest.writeParcelable(this.mFhirBaseUri, 0);
        dest.writeString(this.mDisplayName);
        dest.writeParcelable(this.mFhirVersion, 0);
        dest.writeLong(this.mLastDataUpdateTime == null ? 0L : this.mLastDataUpdateTime.toEpochMilli());
    }

    public static Set<UUID> validateMedicalDataSourceIds(@NonNull Set<String> ids) {
        HashSet<String> invalidIds = new HashSet<String>();
        HashSet<UUID> uuids = new HashSet<UUID>();
        for (String id2 : ids) {
            try {
                uuids.add(UUID.fromString(id2));
            }
            catch (IllegalArgumentException e) {
                invalidIds.add(id2);
            }
        }
        if (!invalidIds.isEmpty()) {
            throw new IllegalArgumentException("Invalid data source ID(s): " + invalidIds);
        }
        return uuids;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MedicalDataSource)) {
            return false;
        }
        MedicalDataSource that = (MedicalDataSource)o;
        return this.getId().equals(that.getId()) && this.getPackageName().equals(that.getPackageName()) && ((Object)this.getFhirBaseUri()).equals(that.getFhirBaseUri()) && this.getDisplayName().equals(that.getDisplayName()) && this.getFhirVersion().equals(that.getFhirVersion()) && Objects.equals(this.getLastDataUpdateTime(), that.getLastDataUpdateTime());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getPackageName(), this.getFhirBaseUri(), this.getDisplayName(), this.getFhirVersion(), this.getLastDataUpdateTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("{");
        sb.append("id=").append(this.getId());
        sb.append(",packageName=").append(this.getPackageName());
        sb.append(",fhirBaseUri=").append(this.getFhirBaseUri());
        sb.append(",displayName=").append(this.getDisplayName());
        sb.append(",fhirVersion=").append(this.getFhirVersion());
        sb.append(",lastDataUpdateTime=").append(this.getLastDataUpdateTime());
        sb.append("}");
        return sb.toString();
    }

    public static class Builder {
        @NonNull
        private String mId;
        @NonNull
        private String mPackageName;
        @NonNull
        private Uri mFhirBaseUri;
        @NonNull
        private String mDisplayName;
        @NonNull
        private FhirVersion mFhirVersion;
        @Nullable
        private Instant mLastDataUpdateTime;

        public Builder(@NonNull String id2, @NonNull String packageName, @NonNull Uri fhirBaseUri, @NonNull String displayName, @NonNull FhirVersion fhirVersion) {
            Objects.requireNonNull(id2);
            Objects.requireNonNull(packageName);
            Objects.requireNonNull(fhirBaseUri);
            Objects.requireNonNull(displayName);
            Objects.requireNonNull(fhirVersion);
            this.mId = id2;
            this.mPackageName = packageName;
            this.mFhirBaseUri = fhirBaseUri;
            this.mDisplayName = displayName;
            this.mFhirVersion = fhirVersion;
        }

        public Builder(@NonNull Builder other) {
            Objects.requireNonNull(other);
            this.mId = other.mId;
            this.mPackageName = other.mPackageName;
            this.mFhirBaseUri = other.mFhirBaseUri;
            this.mDisplayName = other.mDisplayName;
            this.mFhirVersion = other.mFhirVersion;
            this.mLastDataUpdateTime = other.mLastDataUpdateTime;
        }

        public Builder(@NonNull MedicalDataSource other) {
            Objects.requireNonNull(other);
            this.mId = other.getId();
            this.mPackageName = other.getPackageName();
            this.mFhirBaseUri = other.getFhirBaseUri();
            this.mDisplayName = other.getDisplayName();
            this.mFhirVersion = other.getFhirVersion();
            this.mLastDataUpdateTime = other.getLastDataUpdateTime();
        }

        @NonNull
        public Builder setId(@NonNull String id2) {
            Objects.requireNonNull(id2);
            this.mId = id2;
            return this;
        }

        @NonNull
        public Builder setPackageName(@NonNull String packageName) {
            Objects.requireNonNull(packageName);
            this.mPackageName = packageName;
            return this;
        }

        @NonNull
        public Builder setFhirBaseUri(@NonNull Uri fhirBaseUri) {
            Objects.requireNonNull(fhirBaseUri);
            this.mFhirBaseUri = fhirBaseUri;
            return this;
        }

        @NonNull
        public Builder setDisplayName(@NonNull String displayName) {
            Objects.requireNonNull(displayName);
            this.mDisplayName = displayName;
            return this;
        }

        @NonNull
        public Builder setFhirVersion(@NonNull FhirVersion fhirVersion) {
            Objects.requireNonNull(fhirVersion);
            this.mFhirVersion = fhirVersion;
            return this;
        }

        @NonNull
        public Builder setLastDataUpdateTime(@Nullable Instant lastDataUpdateTime) {
            this.mLastDataUpdateTime = lastDataUpdateTime;
            return this;
        }

        @NonNull
        public MedicalDataSource build() {
            return new MedicalDataSource(this.mId, this.mPackageName, this.mFhirBaseUri, this.mDisplayName, this.mFhirVersion, this.mLastDataUpdateTime);
        }
    }
}

