/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.DataOrigin;
import android.health.connect.datatypes.Device;
import android.health.connect.datatypes.validation.ValidationUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Instant;
import java.util.Objects;
import java.util.Set;

public class Metadata {
    public static final int RECORDING_METHOD_UNKNOWN = 0;
    public static final int RECORDING_METHOD_ACTIVELY_RECORDED = 1;
    public static final int RECORDING_METHOD_AUTOMATICALLY_RECORDED = 2;
    public static final int RECORDING_METHOD_MANUAL_ENTRY = 3;
    public static final Set<Integer> VALID_TYPES = Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));
    private final Device mDevice;
    private final DataOrigin mDataOrigin;
    private final Instant mLastModifiedTime;
    @Nullable
    private final String mClientRecordId;
    private final long mClientRecordVersion;
    private final int mRecordingMethod;
    private String mId;

    private Metadata(Device device, DataOrigin dataOrigin, String id2, Instant lastModifiedTime, @Nullable String clientRecordId, long clientRecordVersion, int recordingMethod) {
        ValidationUtils.validateIntDefValue(recordingMethod, VALID_TYPES, RecordingMethod.class.getSimpleName());
        this.mDevice = device;
        this.mDataOrigin = dataOrigin;
        this.mId = id2;
        this.mLastModifiedTime = lastModifiedTime;
        this.mClientRecordId = clientRecordId;
        this.mClientRecordVersion = clientRecordVersion;
        this.mRecordingMethod = recordingMethod;
    }

    @Nullable
    public String getClientRecordId() {
        return this.mClientRecordId;
    }

    public long getClientRecordVersion() {
        return this.mClientRecordVersion;
    }

    @NonNull
    public DataOrigin getDataOrigin() {
        return this.mDataOrigin;
    }

    @NonNull
    public String getId() {
        return this.mId;
    }

    public void setId(@NonNull String id2) {
        Objects.requireNonNull(id2);
        this.mId = id2;
    }

    public int getRecordingMethod() {
        return this.mRecordingMethod;
    }

    @NonNull
    public Instant getLastModifiedTime() {
        return this.mLastModifiedTime;
    }

    @NonNull
    public Device getDevice() {
        return this.mDevice;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Metadata) {
            Metadata other = (Metadata)object;
            return this.getDevice().equals(other.getDevice()) && this.getDataOrigin().equals(other.getDataOrigin()) && this.getId().equals(other.getId()) && Objects.equals(this.getClientRecordId(), other.getClientRecordId()) && this.getClientRecordVersion() == other.getClientRecordVersion() && this.getRecordingMethod() == other.getRecordingMethod();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getDevice(), this.getDataOrigin(), this.getId(), this.getClientRecordId(), this.getClientRecordVersion(), this.getLastModifiedTime(), this.getRecordingMethod());
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RecordingMethod {
    }

    public static class Builder {
        private Device mDevice = new Device.Builder().build();
        private DataOrigin mDataOrigin = new DataOrigin.Builder().build();
        private String mId = "";
        private Instant mLastModifiedTime = Instant.EPOCH;
        @Nullable
        private String mClientRecordId;
        private long mClientRecordVersion = 0L;
        private int mRecordingMethod = 0;

        @NonNull
        public Builder setDevice(@NonNull Device device) {
            Objects.requireNonNull(device);
            this.mDevice = device;
            return this;
        }

        @NonNull
        public Builder setDataOrigin(@NonNull DataOrigin dataOrigin) {
            Objects.requireNonNull(dataOrigin);
            this.mDataOrigin = dataOrigin;
            return this;
        }

        @NonNull
        public Builder setId(@NonNull String id2) {
            Objects.requireNonNull(id2);
            this.mId = id2;
            return this;
        }

        @NonNull
        public Builder setLastModifiedTime(@NonNull Instant lastModifiedTime) {
            Objects.requireNonNull(lastModifiedTime);
            this.mLastModifiedTime = lastModifiedTime;
            return this;
        }

        @NonNull
        public Builder setClientRecordId(@Nullable String clientRecordId) {
            this.mClientRecordId = clientRecordId;
            return this;
        }

        @NonNull
        public Builder setClientRecordVersion(long clientRecordVersion) {
            this.mClientRecordVersion = clientRecordVersion;
            return this;
        }

        @NonNull
        public Builder setRecordingMethod(int recordingMethod) {
            this.mRecordingMethod = recordingMethod;
            return this;
        }

        @NonNull
        public Metadata build() {
            return new Metadata(this.mDevice, this.mDataOrigin, this.mId, this.mLastModifiedTime, this.mClientRecordId, this.mClientRecordVersion, this.mRecordingMethod);
        }
    }
}

