/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.IntervalRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.units.Mass;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.NicotineIntakeRecordInternal;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.Set;

@Identifier(recordIdentifier=43)
@FlaggedApi(value="com.android.healthfitness.flags.smoking")
public class NicotineIntakeRecord
extends IntervalRecord {
    public static final int NICOTINE_INTAKE_TYPE_VAPE = 0;
    public static final int NICOTINE_INTAKE_TYPE_CIGARETTE = 1;
    private static final Set<Integer> VALID_NICOTINE_INTAKE_TYPES = Set.of(Integer.valueOf(0), Integer.valueOf(1));
    @Nullable
    private final Mass mNicotineIntake;
    private final int mQuantity;
    private final int mNicotineIntakeType;

    private NicotineIntakeRecord(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull ZoneOffset startZoneOffset, @NonNull Instant endTime, @NonNull ZoneOffset endZoneOffset, @Nullable Mass nicotineIntake, int quantity, int nicotineIntakeType, boolean skipValidation) {
        super(metadata, startTime, startZoneOffset, endTime, endZoneOffset, skipValidation, true);
        if (!skipValidation) {
            ValidationUtils.requireInRange(quantity, 0, 100, "quantity");
            ValidationUtils.validateIntDefValue(nicotineIntakeType, VALID_NICOTINE_INTAKE_TYPES, NicotineIntakeType.class.getSimpleName());
        }
        this.mNicotineIntake = nicotineIntake;
        this.mQuantity = quantity;
        this.mNicotineIntakeType = nicotineIntakeType;
    }

    @Nullable
    public Mass getNicotineIntake() {
        return this.mNicotineIntake;
    }

    public int getQuantity() {
        return this.mQuantity;
    }

    public int getNicotineIntakeType() {
        return this.mNicotineIntakeType;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NicotineIntakeRecord)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NicotineIntakeRecord that = (NicotineIntakeRecord)o;
        return Objects.equals(this.mNicotineIntake, that.mNicotineIntake) && this.mQuantity == that.mQuantity && this.mNicotineIntakeType == that.mNicotineIntakeType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mNicotineIntake, this.mQuantity, this.mNicotineIntakeType);
    }

    public NicotineIntakeRecordInternal toRecordInternal() {
        NicotineIntakeRecordInternal recordInternal = (NicotineIntakeRecordInternal)new NicotineIntakeRecordInternal().setMetaData(this.getMetadata());
        recordInternal.setTimeInterval(this);
        recordInternal.setQuantity(this.mQuantity);
        recordInternal.setNicotineIntakeType(this.mNicotineIntakeType);
        if (this.mNicotineIntake != null) {
            recordInternal.setNicotineIntakeGrams(this.mNicotineIntake.getInGrams());
        }
        return recordInternal;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NicotineIntakeType {
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mStartTime;
        private final Instant mEndTime;
        private ZoneOffset mStartZoneOffset;
        private ZoneOffset mEndZoneOffset;
        @Nullable
        private Mass mNicotineIntake;
        private final int mQuantity;
        private final int mNicotineIntakeType;

        public Builder(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull Instant endTime, int quantity, int nicotineIntakeType) {
            this.mMetadata = Objects.requireNonNull(metadata);
            this.mStartTime = Objects.requireNonNull(startTime);
            this.mEndTime = Objects.requireNonNull(endTime);
            this.mStartZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(startTime);
            this.mEndZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(startTime);
            this.mQuantity = quantity;
            this.mNicotineIntakeType = nicotineIntakeType;
        }

        @NonNull
        public Builder setStartZoneOffset(@NonNull ZoneOffset startZoneOffset) {
            this.mStartZoneOffset = Objects.requireNonNull(startZoneOffset);
            return this;
        }

        @NonNull
        public Builder setEndZoneOffset(@NonNull ZoneOffset endZoneOffset) {
            this.mEndZoneOffset = Objects.requireNonNull(endZoneOffset);
            return this;
        }

        @NonNull
        public Builder setNicotineIntake(@Nullable Mass nicotineIntake) {
            this.mNicotineIntake = nicotineIntake;
            return this;
        }

        @NonNull
        public NicotineIntakeRecord build(boolean skipValidation) {
            return new NicotineIntakeRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mNicotineIntake, this.mQuantity, this.mNicotineIntakeType, skipValidation);
        }

        @NonNull
        public NicotineIntakeRecord build() {
            return this.build(false);
        }
    }
}

