/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.ExerciseCompletionGoal;
import android.health.connect.datatypes.ExercisePerformanceGoal;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.internal.datatypes.ExerciseCompletionGoalInternal;
import android.health.connect.internal.datatypes.ExercisePerformanceGoalInternal;
import android.health.connect.internal.datatypes.PlannedExerciseStepInternal;
import android.util.ArraySet;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class PlannedExerciseStep {
    private final int mExerciseType;
    private final int mExerciseCategory;
    @Nullable
    private final CharSequence mDescription;
    private final ExerciseCompletionGoal mCompletionGoal;
    private final List<ExercisePerformanceGoal> mPerformanceGoals;
    public static final int EXERCISE_CATEGORY_UNKNOWN = 0;
    public static final int EXERCISE_CATEGORY_WARMUP = 1;
    public static final int EXERCISE_CATEGORY_REST = 2;
    public static final int EXERCISE_CATEGORY_ACTIVE = 3;
    public static final int EXERCISE_CATEGORY_COOLDOWN = 4;
    public static final int EXERCISE_CATEGORY_RECOVERY = 5;
    private static final Set<Integer> VALID_EXERCISE_CATEGORIES = Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5));

    private PlannedExerciseStep(int exerciseType, @Nullable CharSequence description, int exerciseCategory, ExerciseCompletionGoal completionGoal, List<ExercisePerformanceGoal> performanceGoals) {
        this.mExerciseType = exerciseType;
        this.mDescription = description;
        this.mExerciseCategory = exerciseCategory;
        this.mCompletionGoal = completionGoal;
        this.mPerformanceGoals = performanceGoals;
    }

    public int getExerciseType() {
        return this.mExerciseType;
    }

    @Nullable
    public CharSequence getDescription() {
        return this.mDescription;
    }

    public int getExerciseCategory() {
        return this.mExerciseCategory;
    }

    @NonNull
    public ExerciseCompletionGoal getCompletionGoal() {
        return this.mCompletionGoal;
    }

    @NonNull
    public List<ExercisePerformanceGoal> getPerformanceGoals() {
        return this.mPerformanceGoals;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlannedExerciseStep)) {
            return false;
        }
        PlannedExerciseStep that = (PlannedExerciseStep)o;
        return RecordUtils.isEqualNullableCharSequences(this.getDescription(), that.getDescription()) && this.getExerciseCategory() == that.getExerciseCategory() && this.getExerciseType() == that.getExerciseType() && Objects.equals(this.getCompletionGoal(), that.getCompletionGoal()) && Objects.equals(this.getPerformanceGoals(), that.getPerformanceGoals());
    }

    public int hashCode() {
        return Objects.hash(this.getDescription(), this.getExerciseCategory(), this.getExerciseType(), this.getCompletionGoal(), this.getPerformanceGoals());
    }

    public PlannedExerciseStepInternal toInternalObject() {
        PlannedExerciseStepInternal result = new PlannedExerciseStepInternal(this.getExerciseType(), this.getExerciseCategory(), ExerciseCompletionGoalInternal.fromExternalObject(this.getCompletionGoal()));
        if (this.mDescription != null) {
            result.setDescription(this.mDescription.toString());
        }
        result.setPerformanceGoals(this.getPerformanceGoals().stream().map(ExercisePerformanceGoalInternal::fromExternalObject).collect(Collectors.toList()));
        return result;
    }

    public static boolean isValidExerciseCategory(int exerciseCategory) {
        return VALID_EXERCISE_CATEGORIES.contains(exerciseCategory);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ExerciseCategory {
    }

    public static class Builder {
        private int mExerciseType;
        private int mExerciseCategory;
        @Nullable
        private CharSequence mDescription;
        private ExerciseCompletionGoal mCompletionGoal;
        private List<ExercisePerformanceGoal> mPerformanceGoals = new ArrayList<ExercisePerformanceGoal>();

        public Builder(int exerciseType, int exerciseCategory, @NonNull ExerciseCompletionGoal completionGoal) {
            this.mExerciseType = exerciseType;
            this.mExerciseCategory = exerciseCategory;
            this.mCompletionGoal = completionGoal;
        }

        @NonNull
        public Builder setExerciseType(int exerciseType) {
            this.mExerciseType = exerciseType;
            return this;
        }

        @NonNull
        public Builder setExerciseCategory(int category) {
            this.mExerciseCategory = category;
            return this;
        }

        @NonNull
        public Builder setDescription(@Nullable CharSequence description) {
            this.mDescription = description;
            return this;
        }

        @NonNull
        public Builder setCompletionGoal(@NonNull ExerciseCompletionGoal completionGoal) {
            Objects.requireNonNull(completionGoal);
            this.mCompletionGoal = completionGoal;
            return this;
        }

        @NonNull
        public Builder addPerformanceGoal(@NonNull ExercisePerformanceGoal performanceGoal) {
            Objects.requireNonNull(performanceGoal);
            this.mPerformanceGoals.add(performanceGoal);
            return this;
        }

        @NonNull
        public Builder setPerformanceGoals(@NonNull List<ExercisePerformanceGoal> performanceGoals) {
            Objects.requireNonNull(performanceGoals);
            this.mPerformanceGoals.clear();
            this.mPerformanceGoals.addAll(performanceGoals);
            return this;
        }

        @NonNull
        public Builder clearPerformanceGoals() {
            this.mPerformanceGoals.clear();
            return this;
        }

        @NonNull
        public PlannedExerciseStep build() {
            ArraySet classes = new ArraySet();
            for (ExercisePerformanceGoal goal : this.mPerformanceGoals) {
                classes.add(goal.getClass());
            }
            if (classes.size() != this.mPerformanceGoals.size()) {
                throw new IllegalArgumentException("At most one of each type of performance goal is permitted.");
            }
            if (!PlannedExerciseStep.isValidExerciseCategory(this.mExerciseCategory)) {
                throw new IllegalArgumentException("Invalid exercise category.");
            }
            return new PlannedExerciseStep(this.mExerciseType, this.mDescription, this.mExerciseCategory, this.mCompletionGoal, List.copyOf(this.mPerformanceGoals));
        }
    }
}

