/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import java.time.Instant;
import java.util.Objects;

public class TimeInterval
implements Comparable<TimeInterval> {
    private final Instant mStartTime;
    private final Instant mEndTime;

    @Override
    public int compareTo(TimeInterval interval) {
        if (this.getStartTime().compareTo(interval.getStartTime()) != 0) {
            return this.getStartTime().compareTo(interval.getStartTime());
        }
        return this.getEndTime().compareTo(interval.getEndTime());
    }

    public TimeInterval(@NonNull Instant startTime, @NonNull Instant endTime) {
        Objects.requireNonNull(startTime);
        Objects.requireNonNull(endTime);
        if (!endTime.isAfter(startTime)) {
            throw new IllegalArgumentException("End time must be after start time.");
        }
        this.mStartTime = startTime;
        this.mEndTime = endTime;
    }

    @NonNull
    public Instant getStartTime() {
        return this.mStartTime;
    }

    @NonNull
    public Instant getEndTime() {
        return this.mEndTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimeInterval)) {
            return false;
        }
        TimeInterval that = (TimeInterval)o;
        return this.getStartTime().toEpochMilli() == that.getStartTime().toEpochMilli() && this.getEndTime().toEpochMilli() == that.getEndTime().toEpochMilli();
    }

    public int hashCode() {
        return Objects.hash(this.getStartTime(), this.getEndTime());
    }

    public static interface TimeIntervalHolder {
        public TimeInterval getInterval();
    }
}

